/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.api.impl;

import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IJobXMLSource;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.ws.BatchStatusValidator;
import com.ibm.jbatch.container.ws.BatchSubmitInvalidParametersException;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.WSBatchAuthService;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.jbatch.spi.services.IJobXMLLoaderService;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionIsRunningException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.operations.JobOperator;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobSecurityException;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.operations.NoSuchJobException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.operations.NoSuchJobInstanceException;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.StepExecution;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class JobOperatorImpl
implements JobOperator {
    private static final Logger logger = Logger.getLogger(JobOperatorImpl.class.getName());
    private ServicesManager servicesManager;
    private BatchSecurityHelper batchSecurityHelper;
    private WSBatchAuthService authService;
    private BatchEventsPublisher eventsPublisher;
    static final long serialVersionUID = -4049623281601265074L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobOperatorImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "<init>", new Object[0]);
        }
        this.eventsPublisher = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "activate", new Object[]{context, config});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Deactivate
    protected void deactivate() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "deactivate", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "deactivate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEventsPublisher(BatchEventsPublisher publisher) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "setEventsPublisher", new Object[]{publisher});
        }
        this.eventsPublisher = publisher;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "setEventsPublisher");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetEventsPublisher(BatchEventsPublisher publisher) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "unsetEventsPublisher", new Object[]{publisher});
        }
        if (this.eventsPublisher == publisher) {
            this.eventsPublisher = publisher;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "unsetEventsPublisher");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWSBatchAuthService(WSBatchAuthService bas) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "setWSBatchAuthService", new Object[]{bas});
        }
        this.authService = bas;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "setWSBatchAuthService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetWSBatchAuthService(WSBatchAuthService bas) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "unsetWSBatchAuthService", new Object[]{bas});
        }
        if (this.authService == bas) {
            this.authService = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "unsetWSBatchAuthService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setServicesManager(ServicesManager ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "setServicesManager", new Object[]{ref});
        }
        this.servicesManager = ref;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "setServicesManager");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setBatchSecurityHelper(BatchSecurityHelper batchSecurityHelper) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "setBatchSecurityHelper", new Object[]{batchSecurityHelper});
        }
        this.batchSecurityHelper = batchSecurityHelper;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "setBatchSecurityHelper");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetBatchSecurityHelper(BatchSecurityHelper bsh) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "unsetBatchSecurityHelper", new Object[]{bsh});
        }
        if (this.batchSecurityHelper == bsh) {
            this.batchSecurityHelper = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "unsetBatchSecurityHelper");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected IBatchKernelService getBatchKernelService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getBatchKernelService", new Object[0]);
        }
        IBatchKernelService iBatchKernelService = this.servicesManager.getBatchKernelService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iBatchKernelService = iBatchKernelService;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getBatchKernelService", iBatchKernelService);
        }
        return iBatchKernelService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected IPersistenceManagerService getPersistenceManagerService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getPersistenceManagerService", new Object[0]);
        }
        IPersistenceManagerService iPersistenceManagerService = this.servicesManager.getPersistenceManagerService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iPersistenceManagerService = iPersistenceManagerService;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getPersistenceManagerService", iPersistenceManagerService);
        }
        return iPersistenceManagerService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected IJobXMLLoaderService getJobXMLLoaderService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobXMLLoaderService", new Object[0]);
        }
        IJobXMLLoaderService iJobXMLLoaderService = this.servicesManager.getDelegatingJobXMLLoaderService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iJobXMLLoaderService = iJobXMLLoaderService;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobXMLLoaderService", iJobXMLLoaderService);
        }
        return iJobXMLLoaderService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={JobSecurityException.class})
    public long start(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "start", new Object[]{jobXMLName, jobParameters});
        }
        long retVal = 0L;
        try {
            retVal = this.startInternal(jobXMLName, jobParameters);
        }
        catch (JobSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.api.impl.JobOperatorImpl", (String)"206", (Object)this, (Object[])new Object[]{jobXMLName, jobParameters});
            throw new JobStartException((Throwable)e);
        }
        long l = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "start", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={IOException.class})
    protected String traceJobParameters(Properties jobParameters) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "traceJobParameters", new Object[]{jobParameters});
        }
        if (logger.isLoggable(Level.FINE)) {
            StringWriter jobParameterWriter = new StringWriter();
            if (jobParameters != null) {
                try {
                    jobParameters.store(jobParameterWriter, "Job parameters: ");
                }
                catch (IOException e) {
                    jobParameterWriter.write("Job parameters: not printable due to IOException: " + e.getMessage());
                }
            } else {
                jobParameterWriter.write("Job parameters: null");
            }
            String string = jobParameterWriter.toString();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "traceJobParameters", string);
            }
            return string;
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "traceJobParameters", string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private long startInternal(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "startInternal", new Object[]{jobXMLName, jobParameters});
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Starting job: jobXMLName = " + jobXMLName + "\n" + this.traceJobParameters(jobParameters));
        }
        if (this.authService != null) {
            this.authService.authorizedJobSubmission();
        }
        WSJobInstance jobInstance = this.getBatchKernelService().createJobInstanceIntraApplication(jobXMLName, this.batchSecurityHelper.getRunAsUser());
        JobExecutionEntity jobExecution = this.getPersistenceManagerService().createJobExecution(jobInstance.getInstanceId(), jobParameters, new Date());
        IJobXMLSource jobXML = null;
        long executionId = 0L;
        try {
            jobXML = this.getJobXMLLoaderService().loadJSL(jobXMLName);
            executionId = this.getBatchKernelService().startJob(jobInstance, jobXML, jobParameters, jobExecution.getExecutionId()).getKey();
        }
        catch (BatchSubmitInvalidParametersException batchSubmitInvalidParametersException) {
            void bsipe;
            FFDCFilter.processException((Throwable)batchSubmitInvalidParametersException, (String)"com.ibm.jbatch.container.api.impl.JobOperatorImpl", (String)"258", (Object)this, (Object[])new Object[]{jobXMLName, jobParameters});
            this.markInstanceExecutionFailed(jobInstance, jobExecution, this.getCorrelationId(jobParameters));
            throw bsipe;
        }
        catch (RuntimeException bsipe) {
            void e;
            FFDCFilter.processException((Throwable)bsipe, (String)"com.ibm.jbatch.container.api.impl.JobOperatorImpl", (String)"261", (Object)this, (Object[])new Object[]{jobXMLName, jobParameters});
            this.markInstanceExecutionFailed(jobInstance, jobExecution, this.getCorrelationId(jobParameters));
            throw e;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Started job execution with executionId: " + executionId);
        }
        long l = executionId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "startInternal", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void markInstanceExecutionFailed(long executionId, String correlationId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "markInstanceExecutionFailed", new Object[]{executionId, correlationId});
        }
        JobExecutionEntity jobExecution = this.getPersistenceManagerService().getJobExecution(executionId);
        JobInstanceEntity jobInstance = jobExecution.getJobInstance();
        this.markInstanceExecutionFailed(jobInstance, jobExecution, correlationId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "markInstanceExecutionFailed");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void markInstanceExecutionFailed(WSJobInstance jobInstance, WSJobExecution jobExecution, String correlationId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "markInstanceExecutionFailed", new Object[]{jobInstance, jobExecution, correlationId});
        }
        if (jobInstance.getBatchStatus() == BatchStatus.ABANDONED) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt to transition from BatchStatus ABANDONED to FAILED is disallowed. ");
            }
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "markInstanceExecutionFailed");
            }
            return;
        }
        this.getPersistenceManagerService().updateJobInstanceWithInstanceStateAndBatchStatus(jobInstance.getInstanceId(), InstanceState.FAILED, BatchStatus.FAILED, new Date());
        this.publishEvent(jobInstance, "batch/jobs/instance/failed", correlationId);
        this.getPersistenceManagerService().updateJobExecutionAndInstanceOnStatusChange(jobExecution.getExecutionId(), BatchStatus.FAILED, new Date());
        this.publishEvent(jobExecution, "batch/jobs/execution/failed", correlationId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "markInstanceExecutionFailed");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getCorrelationId(Properties jobParameters) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getCorrelationId", new Object[]{jobParameters});
        }
        if (jobParameters != null) {
            String string = jobParameters.getProperty("com_ibm_ws_batch_events_correlationId", null);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getCorrelationId", string);
            }
            return string;
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getCorrelationId", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void abandon(long executionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "abandon", new Object[]{executionId});
        }
        this.batchRoleCheck();
        long jobInstanceId = this.getPersistenceManagerService().getJobInstanceIdFromExecutionId(executionId);
        if (this.authService != null) {
            this.authService.authorizedJobAbandonByInstance(jobInstanceId);
        }
        JobExecutionEntity jobEx = this.getPersistenceManagerService().getJobExecution(executionId);
        List<BatchStatus> runningStatusesList = Arrays.asList(BatchStatus.STARTED, BatchStatus.STARTING);
        Set<BatchStatus> runningStatusesSet = Collections.unmodifiableSet(new HashSet<BatchStatus>(runningStatusesList));
        if (runningStatusesSet.contains(jobEx.getBatchStatus())) {
            throw new JobExecutionIsRunningException("Job Execution: " + executionId + " is still running");
        }
        this.getPersistenceManagerService().updateJobExecutionAndInstanceOnStatusChange(jobEx.getExecutionId(), BatchStatus.ABANDONED, new Date());
        logger.fine("Job Execution: " + executionId + " was abandoned");
        this.publishEvent(jobEx, "batch/jobs/execution/abandoned");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "abandon");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void publishEvent(WSJobExecution jobEx, String topicToPublish) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "publishEvent", new Object[]{jobEx, topicToPublish});
        }
        this.publishEvent(jobEx, topicToPublish, null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "publishEvent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void publishEvent(WSJobExecution jobEx, String topicToPublish, String correlationId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "publishEvent", new Object[]{jobEx, topicToPublish, correlationId});
        }
        if (this.eventsPublisher != null) {
            this.eventsPublisher.publishJobExecutionEvent(jobEx, topicToPublish, correlationId);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "publishEvent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void publishEvent(WSJobInstance jobInst, String topicToPublish, String correlationId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "publishEvent", new Object[]{jobInst, topicToPublish, correlationId});
        }
        if (this.eventsPublisher != null) {
            this.eventsPublisher.publishJobInstanceEvent(jobInst, topicToPublish, correlationId);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "publishEvent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution getJobExecution(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobExecution", new Object[]{jobExecutionId});
        }
        if (this.authService != null) {
            this.authService.authorizedExecutionRead(jobExecutionId);
        }
        JobExecutionEntity jobExecutionEntity = this.getPersistenceManagerService().getJobExecution(jobExecutionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobExecution", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobExecutions", new Object[]{instance});
        }
        if (this.authService != null) {
            this.authService.authorizedInstanceRead(instance.getInstanceId());
        }
        ArrayList<JobExecution> arrayList = new ArrayList<JobExecution>(this.getPersistenceManagerService().getJobExecutionsFromJobInstanceId(instance.getInstanceId()));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobExecutions", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobInstance", new Object[]{executionId});
        }
        if (this.authService != null) {
            this.authService.authorizedExecutionRead(executionId);
        }
        JobInstanceEntity jobInstanceEntity = this.getPersistenceManagerService().getJobInstanceFromExecutionId(executionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobInstance", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobInstanceCount", new Object[]{jobName});
        }
        int jobInstanceCount = 0;
        if (this.authService == null || this.authService.isAdmin() || this.authService.isMonitor()) {
            jobInstanceCount = this.getPersistenceManagerService().getJobInstanceCount(jobName);
        } else if (this.authService.isSubmitter()) {
            jobInstanceCount = this.getPersistenceManagerService().getJobInstanceCount(jobName, this.batchSecurityHelper.getRunAsUser());
        } else {
            throw new JobSecurityException("Current user " + this.authService.getRunAsUser() + " is not authorized to perform batch operations");
        }
        if (jobInstanceCount == 0) {
            this.validateJobName(jobName);
        }
        int n = jobInstanceCount;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobInstanceCount", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void validateJobName(String jobName) throws NoSuchJobException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "validateJobName", new Object[]{jobName});
        }
        if (!this.getJobNames().contains(jobName)) {
            logger.fine("Job Name " + jobName + " not found");
            throw new NoSuchJobException("Job Name " + jobName + " not found");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "validateJobName");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstance> getJobInstances(String jobName, int start, int count) throws NoSuchJobException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobInstances", new Object[]{jobName, start, count});
        }
        this.batchRoleCheck();
        List<Object> jobInstances = new ArrayList();
        if (count == 0) {
            ArrayList<JobInstance> arrayList = new ArrayList<JobInstance>();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                arrayList = arrayList;
                logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobInstances", arrayList);
            }
            return arrayList;
        }
        if (count < 0) {
            throw new IllegalArgumentException("Count should be a positive integer (or 0, which will return an empty list)");
        }
        if (this.authService == null || this.authService.isAdmin() || this.authService.isMonitor()) {
            jobInstances = this.getPersistenceManagerService().getJobInstances(jobName, start, count);
        } else if (this.authService.isSubmitter()) {
            jobInstances = this.getPersistenceManagerService().getJobInstances(jobName, this.batchSecurityHelper.getRunAsUser(), start, count);
        } else {
            throw new JobSecurityException("Current user " + this.authService.getRunAsUser() + " is not authorized to perform batch operations");
        }
        if (jobInstances.size() == 0) {
            try {
                this.validateJobName(jobName);
            }
            catch (NoSuchJobException noSuchJobException) {
                void e;
                FFDCFilter.processException((Throwable)noSuchJobException, (String)"com.ibm.jbatch.container.api.impl.JobOperatorImpl", (String)"506", (Object)this, (Object[])new Object[]{jobName, start, count});
                throw e;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(jobInstances);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobInstances", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getJobNames() throws JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobNames", new Object[0]);
        }
        this.batchRoleCheck();
        if (this.authService == null || this.authService.isAdmin() || this.authService.isMonitor()) {
            Set<String> set = this.getPersistenceManagerService().getJobNamesSet();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                set = set;
                logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobNames", set);
            }
            return set;
        }
        if (this.authService.isSubmitter()) {
            Set<String> set = this.getPersistenceManagerService().getJobNamesSet(this.batchSecurityHelper.getRunAsUser());
            if (logger != null && logger.isLoggable(Level.FINER)) {
                set = set;
                logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getJobNames", set);
            }
            return set;
        }
        throw new JobSecurityException("Current user " + this.authService.getRunAsUser() + " is not authorized to perform batch operations");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Properties getParameters(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getParameters", new Object[]{executionId});
        }
        if (this.authService != null) {
            this.authService.authorizedExecutionRead(executionId);
        }
        Properties properties = this.getPersistenceManagerService().getJobExecutionParameters(executionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            properties = properties;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getParameters", properties);
        }
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Long> getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getRunningExecutions", new Object[]{jobName});
        }
        this.batchRoleCheck();
        ArrayList<Long> authorizedRunningExecutions = new ArrayList<Long>();
        List<Long> allRunningExecutions = this.getPersistenceManagerService().getJobExecutionsRunning(jobName);
        for (long id : allRunningExecutions) {
            try {
                logger.finer("Examining executionId: " + id);
                if (this.authService == null || this.authService.isAuthorizedInstanceRead(this.getPersistenceManagerService().getJobInstanceIdFromExecutionId(id))) {
                    JobExecutionEntity jobEx = this.getPersistenceManagerService().getJobExecution(id);
                    authorizedRunningExecutions.add(jobEx.getExecutionId());
                    continue;
                }
                logger.finer("Don't have authorization for executionId: " + id);
            }
            catch (NoSuchJobExecutionException jobEx) {
                void e;
                FFDCFilter.processException((Throwable)jobEx, (String)"com.ibm.jbatch.container.api.impl.JobOperatorImpl", (String)"566", (Object)this, (Object[])new Object[]{jobName});
                String errorMsg = "Just found execution with id = " + id + " in table, but now seeing it as gone";
                throw new IllegalStateException(errorMsg, (Throwable)e);
            }
        }
        if (authorizedRunningExecutions.size() == 0) {
            this.validateJobName(jobName);
        }
        ArrayList<Long> arrayList = authorizedRunningExecutions;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getRunningExecutions", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<StepExecution> getStepExecutions(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getStepExecutions", new Object[]{jobExecutionId});
        }
        if (this.authService != null) {
            this.authService.authorizedExecutionRead(jobExecutionId);
        }
        JobExecutionEntity jobEx = this.getPersistenceManagerService().getJobExecution(jobExecutionId);
        ArrayList<StepExecution> stepExecutions = new ArrayList<StepExecution>();
        stepExecutions.addAll(this.getPersistenceManagerService().getStepExecutionsTopLevelFromJobExecutionId(jobExecutionId));
        ArrayList<StepExecution> arrayList = stepExecutions;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "getStepExecutions", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={JobExecutionAlreadyCompleteException.class, NoSuchJobExecutionException.class, JobExecutionNotMostRecentException.class, JobSecurityException.class})
    public long restart(long oldExecutionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "restart", new Object[]{oldExecutionId, restartParameters});
        }
        this.batchRoleCheck();
        long retVal = 0L;
        try {
            retVal = this.restartInternal(oldExecutionId, restartParameters);
        }
        catch (JobExecutionAlreadyCompleteException e) {
            throw e;
        }
        catch (NoSuchJobExecutionException e) {
            throw e;
        }
        catch (JobExecutionNotMostRecentException e) {
            throw e;
        }
        catch (JobSecurityException e) {
            this.markInstanceExecutionFailed(oldExecutionId, this.getCorrelationId(restartParameters));
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.api.impl.JobOperatorImpl", (String)"625", (Object)this, (Object[])new Object[]{oldExecutionId, restartParameters});
            this.markInstanceExecutionFailed(oldExecutionId, this.getCorrelationId(restartParameters));
            throw new JobRestartException((Throwable)e);
        }
        long l = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "restart", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private long restartInternal(long oldExecutionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "restartInternal", new Object[]{oldExecutionId, restartParameters});
        }
        if (this.authService != null) {
            this.authService.authorizedJobRestartByExecution(oldExecutionId);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobOperator restart, with old executionId = " + oldExecutionId + "\n" + this.traceJobParameters(restartParameters));
        }
        BatchStatusValidator.validateStatusAtExecutionRestart(oldExecutionId, restartParameters);
        long instanceId = this.getPersistenceManagerService().getJobInstanceIdFromExecutionId(oldExecutionId);
        this.getPersistenceManagerService().updateJobInstanceOnRestart(instanceId, new Date());
        JobExecutionEntity jobExecution = this.getPersistenceManagerService().createJobExecution(instanceId, restartParameters, new Date());
        long newExecutionId = this.getBatchKernelService().restartJob(jobExecution.getExecutionId(), restartParameters).getKey();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Restarted job with new executionId: " + newExecutionId + ", and old executionID: " + oldExecutionId);
        }
        long l = newExecutionId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "restartInternal", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "stop", new Object[]{executionId});
        }
        if (this.authService != null) {
            this.authService.authorizedJobStopByExecution(executionId);
        }
        this.getBatchKernelService().stopJob(executionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "stop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void batchRoleCheck() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "batchRoleCheck", new Object[0]);
        }
        if (this.authService != null && !this.authService.isInAnyBatchRole()) {
            throw new JobSecurityException("Current user " + this.authService.getRunAsUser() + " is not authorized to perform batch operations");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.api.impl.JobOperatorImpl", "batchRoleCheck");
        }
    }
}

