/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.db;

import com.google.auto.value.AutoValue;
import io.opentelemetry.instrumentation.api.db.AutoSqlSanitizer;
import io.opentelemetry.instrumentation.api.db.AutoValue_SqlStatementSanitizer_CacheKey;
import io.opentelemetry.instrumentation.api.db.SqlDialect;
import io.opentelemetry.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.internal.SupportabilityMetrics;
import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import javax.annotation.Nullable;

public final class SqlStatementSanitizer {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private static final Cache<CacheKey, SqlStatementInfo> sqlToStatementInfoCache = Cache.bounded(1000);
    private final boolean statementSanitizationEnabled;

    public static SqlStatementSanitizer create(boolean statementSanitizationEnabled) {
        return new SqlStatementSanitizer(statementSanitizationEnabled);
    }

    private SqlStatementSanitizer(boolean statementSanitizationEnabled) {
        this.statementSanitizationEnabled = statementSanitizationEnabled;
    }

    public SqlStatementInfo sanitize(@Nullable String statement) {
        return this.sanitize(statement, SqlDialect.DEFAULT);
    }

    public SqlStatementInfo sanitize(@Nullable String statement, SqlDialect dialect) {
        if (!this.statementSanitizationEnabled || statement == null) {
            return SqlStatementInfo.create(statement, null, null);
        }
        return sqlToStatementInfoCache.computeIfAbsent(CacheKey.create(statement, dialect), k -> {
            supportability.incrementCounter("SqlStatementSanitizer cache miss");
            return AutoSqlSanitizer.sanitize(statement, dialect);
        });
    }

    @AutoValue
    static abstract class CacheKey {
        CacheKey() {
        }

        static CacheKey create(String statement, SqlDialect dialect) {
            return new AutoValue_SqlStatementSanitizer_CacheKey(statement, dialect);
        }

        abstract String getStatement();

        abstract SqlDialect getDialect();
    }
}

