/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi40.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.OpenAPIVersion;
import io.openliberty.microprofile.openapi20.internal.services.OpenAPIVersionUsageChecker;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Components;
import org.eclipse.microprofile.openapi.annotations.OpenAPIDefinition;
import org.eclipse.microprofile.openapi.annotations.callbacks.Callback;
import org.eclipse.microprofile.openapi.annotations.callbacks.Callbacks;
import org.eclipse.microprofile.openapi.annotations.info.Info;
import org.eclipse.microprofile.openapi.annotations.info.License;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameters;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class OpenAPI31VersionUsageChecker
implements OpenAPIVersionUsageChecker {
    private static final TraceComponent tc = Tr.register(OpenAPI31VersionUsageChecker.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final OpenAPIVersion VERSION_31 = new OpenAPIVersion(3, 1);
    public static final List<DotName> OUTER_ANNOTATIONS = Stream.of(APIResponse.class, APIResponses.class, Callback.class, Callbacks.class, OpenAPIDefinition.class, Parameter.class, Parameters.class, RequestBody.class, Schema.class, SchemaProperty.class).map(DotName::createSimple).collect(Collectors.toUnmodifiableList());
    static final long serialVersionUID = 6475485395947349652L;

    public void checkAnnotations(IndexView index, OpenAPIVersion openAPIVersion) {
        if (openAPIVersion.compareTo(VERSION_31) >= 0) {
            return;
        }
        for (DotName outerAnnoName : OUTER_ANNOTATIONS) {
            for (AnnotationInstance outerAnnoInstance : index.getAnnotations(outerAnnoName)) {
                this.forEachNewParameterUsage(outerAnnoInstance, (annoInstance, parameterName) -> this.warnAbout(outerAnnoInstance.target(), (AnnotationInstance)annoInstance, (String)parameterName, openAPIVersion));
            }
        }
    }

    private void forEachNewParameterUsage(AnnotationInstance anno, BiConsumer<AnnotationInstance, String> action) {
        New31Parameter paramMetadata = New31Parameter.forName(anno.name());
        if (paramMetadata != null) {
            for (String paramName : paramMetadata.getParameters()) {
                if (anno.value(paramName) == null) continue;
                action.accept(anno, paramName);
            }
        }
        for (AnnotationValue value : anno.values()) {
            if (value.kind() == AnnotationValue.Kind.NESTED) {
                this.forEachNewParameterUsage(value.asNested(), action);
                continue;
            }
            if (value.kind() != AnnotationValue.Kind.ARRAY || value.componentKind() != AnnotationValue.Kind.NESTED) continue;
            for (AnnotationInstance instance : value.asNestedArray()) {
                this.forEachNewParameterUsage(instance, action);
            }
        }
    }

    private void warnAbout(AnnotationTarget target, AnnotationInstance annotation, String parameterName, OpenAPIVersion currentVersion) {
        Tr.warning((TraceComponent)tc, (String)"OPENAPI_ANNOTATION_TOO_NEW_CWWKO1687W", (Object[])new Object[]{annotation.name().withoutPackagePrefix() + "." + parameterName, this.getContainingClassName(target), "3.1", currentVersion});
    }

    private String getContainingClassName(AnnotationTarget target) {
        try {
            return this.getContainingClass(target).name().toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"io.openliberty.microprofile.openapi40.internal.impl.OpenAPI31VersionUsageChecker", (String)"208", (Object)this, (Object[])new Object[]{target});
            return "Unknown";
        }
    }

    private ClassInfo getContainingClass(AnnotationTarget target) {
        ClassInfo clazz;
        switch (target.kind()) {
            case CLASS: {
                clazz = target.asClass();
                break;
            }
            case FIELD: {
                clazz = target.asField().declaringClass();
                break;
            }
            case METHOD: {
                clazz = target.asMethod().declaringClass();
                break;
            }
            case METHOD_PARAMETER: {
                clazz = target.asMethodParameter().method().declaringClass();
                break;
            }
            case RECORD_COMPONENT: {
                clazz = target.asRecordComponent().declaringClass();
                break;
            }
            case TYPE: {
                clazz = this.getContainingClass(target.asType().enclosingTarget());
                break;
            }
            default: {
                throw new IllegalArgumentException("Annotation target kind is unknown: " + target);
            }
        }
        return clazz;
    }

    public static enum New31Parameter {
        INFO(Info.class, "summary"),
        COMPONENTS(Components.class, "pathItems"),
        OPENAPI(OpenAPIDefinition.class, "webhooks"),
        LICENSE(License.class, "identifier"),
        SCHEMA(Schema.class, "comment", "ifSchema", "thenSchema", "elseSchema", "dependentSchemas", "contains", "maxContains", "minContains", "prefixItems", "patternProperties", "dependentRequired", "propertyNames", "contentEncoding", "contentMediaType", "contentSchema"),
        SCHEMA_PROPERTY(SchemaProperty.class, "comment", "ifSchema", "thenSchema", "elseSchema", "dependentSchemas", "contains", "maxContains", "minContains", "prefixItems", "patternProperties", "dependentRequired", "propertyNames", "contentEncoding", "contentMediaType", "contentSchema");

        private static Map<DotName, New31Parameter> byName;
        private final DotName name;
        private final List<String> parameters;

        private New31Parameter(Class<? extends Annotation> clazz, String ... parameters) {
            this.name = DotName.createSimple(clazz);
            this.parameters = Collections.unmodifiableList(Arrays.asList(parameters));
        }

        public List<String> getParameters() {
            return this.parameters;
        }

        public DotName getName() {
            return this.name;
        }

        public static New31Parameter forName(DotName name) {
            return byName.get(name);
        }

        static {
            byName = new HashMap<DotName, New31Parameter>();
            for (New31Parameter parameter : New31Parameter.values()) {
                byName.put(parameter.getName(), parameter);
            }
        }
    }
}

