/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi40.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.services.OASValidator;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.OASValidator30Impl;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import io.openliberty.microprofile.openapi40.internal.validation.OpenAPIDefinition31Validator;
import io.openliberty.microprofile.openapi40.internal.validation.Operation31Validator;
import io.openliberty.microprofile.openapi40.internal.validation.PathItem31Validator;
import io.openliberty.microprofile.openapi40.internal.validation.Reference31Validator;
import io.openliberty.microprofile.openapi40.internal.validation.Schema31Validator;
import io.openliberty.microprofile.openapi40.internal.validation.ServerVariable31Validator;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OASValidator.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"openapi.version=3.1"})
public class OpenAPI31Validator
extends OASValidator30Impl {
    private static final TraceComponent tc = Tr.register(OpenAPI31Validator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = 7603611385790872805L;

    public OASValidationResult validate(OpenAPI model) {
        ValidationOperation31 validator = new ValidationOperation31(model);
        return validator.run();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class ValidationOperation31
    extends OASValidator30Impl.ValidationOperation {
        static final long serialVersionUID = 2390403968402920059L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ValidationOperation31(OpenAPI model) {
            super((OASValidator30Impl)OpenAPI31Validator.this, model);
        }

        public void visitOpenAPI(OpenAPIModelWalker.Context context) {
            OpenAPIDefinition31Validator.getInstance().validate((ValidationHelper)this, context, context.getModel());
        }

        public Operation visitOperation(OpenAPIModelWalker.Context context, Operation operation) {
            Operation31Validator.getInstance().validate((ValidationHelper)this, context, operation);
            return operation;
        }

        public ServerVariable visitServerVariable(OpenAPIModelWalker.Context context, String key, ServerVariable sv) {
            ServerVariable31Validator.getInstance().validate((ValidationHelper)this, context, key, sv);
            return sv;
        }

        public PathItem visitPathItem(OpenAPIModelWalker.Context context, String key, PathItem item) {
            PathItem31Validator.getInstance().validate((ValidationHelper)this, context, key, item);
            return item;
        }

        public <T> T validateReference(OpenAPIModelWalker.Context context, String key, String ref, Class<T> clazz) {
            Object component = this.validateReference(context, key, ref);
            if (component == null) {
                return null;
            }
            if (clazz.isInstance(component)) {
                return clazz.cast(component);
            }
            String message = ValidatorUtils.formatMessage((String)"referenceToObjectInvalid", (Object[])new Object[]{ref});
            this.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return null;
        }

        public Schema visitSchema(OpenAPIModelWalker.Context context, Schema schema) {
            Schema31Validator.getInstance().validate((ValidationHelper)this, context, schema);
            return schema;
        }

        public Schema visitSchema(OpenAPIModelWalker.Context context, String key, Schema schema) {
            Schema31Validator.getInstance().validate((ValidationHelper)this, context, key, schema);
            return schema;
        }

        public Object validateReference(OpenAPIModelWalker.Context context, String key, String ref) {
            return Reference31Validator.getInstance().validate((ValidationHelper)this, context, ref);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi40.internal.impl.OpenAPI31Validator$ValidationOperation31", ValidationOperation31.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    }
}

