/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.apache.aries.jndi.ContextHelper;
import org.apache.aries.jndi.ServicePair;
import org.apache.aries.jndi.Utils;
import org.apache.aries.jndi.startup.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ObjectFactoryHelper
implements ObjectFactory {
    private static final Logger logger = Logger.getLogger(ObjectFactoryHelper.class.getName());
    protected BundleContext defaultContext;
    protected BundleContext callerContext;

    public ObjectFactoryHelper(BundleContext defaultContext, BundleContext callerContext) {
        this.defaultContext = defaultContext;
        this.callerContext = callerContext;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        return this.getObjectInstance(obj, name, nameCtx, environment, null);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        return Utils.doPrivilegedE(() -> this.doGetObjectInstance(obj, name, nameCtx, environment, attrs));
    }

    private Object doGetObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        if (obj instanceof Referenceable) {
            obj = ((Referenceable)obj).getReference();
        }
        Object result = obj;
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            String className = ref.getFactoryClassName();
            result = className != null ? this.getObjectInstanceUsingClassName(obj, className, obj, name, nameCtx, environment, attrs) : this.getObjectInstanceUsingRefAddress(ref.getAll(), obj, name, nameCtx, environment, attrs);
        }
        if (result == null || result == obj) {
            result = this.getObjectInstanceUsingObjectFactoryBuilders(obj, name, nameCtx, environment, attrs);
        }
        if (!(result != null && result != obj || obj instanceof Reference && ((Reference)obj).getFactoryClassName() != null)) {
            result = this.getObjectInstanceUsingObjectFactories(obj, name, nameCtx, environment, attrs);
        }
        if (result == null || result == obj) {
            result = this.getObjectInstanceViaContextDotObjectFactories(obj, name, nameCtx, environment, attrs);
        }
        return result == null ? obj : result;
    }

    private Object getObjectInstanceUsingObjectFactories(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        for (ServiceReference<ObjectFactory> ref : Activator.getReferences(this.callerContext, ObjectFactory.class)) {
            ObjectFactory factory;
            if (!this.canCallObjectFactory(obj, ref) || (factory = Activator.getService(this.callerContext, ref)) == null) continue;
            try {
                Object result = this.getObjectFromFactory(obj, name, nameCtx, environment, attrs, factory);
                if (result == null || result == obj) continue;
                return result;
            }
            catch (Exception exception) {
            }
        }
        return obj;
    }

    private boolean canCallObjectFactory(Object obj, ServiceReference ref) {
        if (obj instanceof Reference) {
            return true;
        }
        Object prop = ref.getProperty("aries.object.factory.requires.reference");
        if (Boolean.TRUE.equals(prop)) {
            return false;
        }
        return ref.getProperty("osgi.jndi.url.scheme") == null;
    }

    private Object getObjectInstanceUsingClassName(Object reference, String className, Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        Object result = null;
        ObjectFactory factory = ObjectFactoryHelper.findObjectFactoryByClassName(this.defaultContext, className);
        if (factory != null) {
            result = this.getObjectFromFactory(reference, name, nameCtx, environment, attrs, factory);
        }
        return result == null ? obj : result;
    }

    private Object getObjectInstanceUsingObjectFactoryBuilders(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        ObjectFactory factory = null;
        for (ObjectFactoryBuilder ofb : Activator.getServices(this.callerContext, ObjectFactoryBuilder.class)) {
            try {
                factory = ofb.createObjectFactory(obj, environment);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (factory == null) continue;
            break;
        }
        Object result = null;
        if (factory != null) {
            result = this.getObjectFromFactory(obj, name, nameCtx, environment, attrs, factory);
        }
        return result == null ? obj : result;
    }

    private Object getObjectInstanceViaContextDotObjectFactories(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        Object result = null;
        String factories = (String)environment.get("java.naming.factory.object");
        if (factories != null && factories.length() > 0) {
            String[] candidates = factories.split(":");
            ClassLoader cl = Utils.doPrivileged(Thread.currentThread()::getContextClassLoader);
            for (String cand : candidates) {
                ObjectFactory factory;
                try {
                    Class<?> clz = cl.loadClass(cand);
                    factory = (ObjectFactory)clz.newInstance();
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "Exception instantiating factory: " + e);
                    continue;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "cand=" + cand + " factory=" + factory);
                }
                if (factory != null) {
                    result = this.getObjectFromFactory(obj, name, nameCtx, environment, attrs, factory);
                }
                if (result != null && result != obj) break;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "result = " + result);
        }
        return result == null ? obj : result;
    }

    private Object getObjectInstanceUsingRefAddress(Enumeration<RefAddr> addresses, Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        while (addresses.hasMoreElements()) {
            String urlScheme;
            ServicePair<ObjectFactory> factoryService;
            RefAddr address = addresses.nextElement();
            if (!(address instanceof StringRefAddr) || !"URL".equals(address.getType()) || (factoryService = ContextHelper.getURLObjectFactory(this.callerContext, urlScheme = ObjectFactoryHelper.getUrlScheme((String)address.getContent()), environment)) == null) continue;
            ObjectFactory factory = factoryService.get();
            String value = (String)address.getContent();
            Object result = this.getObjectFromFactory(value, name, nameCtx, environment, attrs, factory);
            if (result == null || result == obj) continue;
            return result;
        }
        return obj;
    }

    private Object getObjectFromFactory(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs, ObjectFactory factory) throws Exception {
        Object result = factory instanceof DirObjectFactory ? ((DirObjectFactory)factory).getObjectInstance(obj, name, nameCtx, environment, attrs) : factory.getObjectInstance(obj, name, nameCtx, environment);
        return result;
    }

    private static String getUrlScheme(String name) {
        String scheme = name;
        int index = name.indexOf(58);
        if (index != -1) {
            scheme = name.substring(0, index);
        }
        return scheme;
    }

    private static ObjectFactory findObjectFactoryByClassName(BundleContext ctx, String className) {
        return Utils.doPrivileged(() -> {
            ServiceReference ref = ctx.getServiceReference(className);
            if (ref != null) {
                return (ObjectFactory)Activator.getService(ctx, ref);
            }
            return null;
        });
    }
}

