/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.wsspi.webcontainer.webapp.IWebAppDispatcherContext;
import io.openliberty.http.monitor.HttpServerStatsMonitor;
import io.openliberty.http.monitor.HttpStatAttributes;
import io.openliberty.http.monitor.MonitorAppStateListener;
import io.openliberty.http.monitor.Servlet4Helper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Duration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServletFilter
implements Filter {
    private static final TraceComponent tc = Tr.register(ServletFilter.class, null, null);
    private static final String REST_HTTP_ROUTE_ATTR = "REST.HTTP.ROUTE";
    static final long serialVersionUID = 3063855967438184975L;

    public void init(FilterConfig config) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={IOException.class, ServletException.class, Exception.class})
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!MonitorAppStateListener.isHTTPEnabled()) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String appName = servletRequest.getServletContext().getAttribute("com.ibm.websphere.servlet.enterprise.application.name").toString();
        ServletException servletException = null;
        Exception exception = null;
        String contextPath = servletRequest.getServletContext().getContextPath();
        contextPath = contextPath == null ? null : contextPath.trim();
        long nanosStart = System.nanoTime();
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (IOException ioe) {
            try {
                throw ioe;
                catch (ServletException se) {
                    servletException = se;
                    throw se;
                }
                catch (Exception e) {
                    exception = e;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                long elapsednanos = System.nanoTime() - nanosStart;
                HttpStatAttributes.Builder builder = HttpStatAttributes.builder();
                this.resolveRequestAttributes(servletRequest, builder);
                if (servletException != null) {
                    if (servletException instanceof ServletErrorReport) {
                        ServletErrorReport ser = (ServletErrorReport)servletException;
                        builder.withResponseStatus(ser.getErrorCode());
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)String.format("Servlet Exception occured, but could not obtain a ServletErrorReport. Default to a 500 response. The exception [%s].", new Object[]{servletException}), (Object[])new Object[0]);
                        }
                        builder.withResponseStatus(500);
                    }
                } else if (exception != null) {
                    builder.withResponseStatus(this.resolveStatusForException(exception));
                } else {
                    this.resolveResponseAttributes(servletResponse, builder);
                }
                String httpRoute = (String)servletRequest.getAttribute(REST_HTTP_ROUTE_ATTR);
                if (httpRoute == null) {
                    if (servletRequest instanceof SRTServletRequest) {
                        SRTServletRequest srtServletRequest = (SRTServletRequest)servletRequest;
                        httpRoute = this.resolveHttpRoute(srtServletRequest, contextPath);
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)String.format("Servlet request is not an instance of SRTServletRequest", servletRequest), (Object[])new Object[0]);
                    }
                }
                builder.withHttpRoute(httpRoute);
                HttpServerStatsMonitor httpMetricsMonitor = HttpServerStatsMonitor.getInstance();
                if (httpMetricsMonitor != null) {
                    httpMetricsMonitor.updateHttpStatDuration(builder, Duration.ofNanos(elapsednanos), appName);
                    throw throwable;
                }
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isDebugEnabled()) throw throwable;
                Tr.debug((TraceComponent)tc, (String)"Could not acquire instance of HttpServerStatsMonitor. Can not proceed to create/update Mbean.", (Object[])new Object[0]);
                throw throwable;
            }
        }
        long elapsednanos = System.nanoTime() - nanosStart;
        HttpStatAttributes.Builder builder = HttpStatAttributes.builder();
        this.resolveRequestAttributes(servletRequest, builder);
        if (servletException != null) {
            if (servletException instanceof ServletErrorReport) {
                ServletErrorReport ser = (ServletErrorReport)servletException;
                builder.withResponseStatus(ser.getErrorCode());
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)String.format("Servlet Exception occured, but could not obtain a ServletErrorReport. Default to a 500 response. The exception [%s].", new Object[]{servletException}), (Object[])new Object[0]);
                }
                builder.withResponseStatus(500);
            }
        } else if (exception != null) {
            builder.withResponseStatus(this.resolveStatusForException(exception));
        } else {
            this.resolveResponseAttributes(servletResponse, builder);
        }
        String httpRoute = (String)servletRequest.getAttribute(REST_HTTP_ROUTE_ATTR);
        if (httpRoute == null) {
            if (servletRequest instanceof SRTServletRequest) {
                SRTServletRequest srtServletRequest = (SRTServletRequest)servletRequest;
                httpRoute = this.resolveHttpRoute(srtServletRequest, contextPath);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)String.format("Servlet request is not an instance of SRTServletRequest", servletRequest), (Object[])new Object[0]);
            }
        }
        builder.withHttpRoute(httpRoute);
        HttpServerStatsMonitor httpMetricsMonitor = HttpServerStatsMonitor.getInstance();
        if (httpMetricsMonitor != null) {
            httpMetricsMonitor.updateHttpStatDuration(builder, Duration.ofNanos(elapsednanos), appName);
            return;
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isDebugEnabled()) return;
        Tr.debug((TraceComponent)tc, (String)"Could not acquire instance of HttpServerStatsMonitor. Can not proceed to create/update Mbean.", (Object[])new Object[0]);
    }

    private void resolveRequestAttributes(ServletRequest servletRequest, HttpStatAttributes.Builder builder) {
        if (HttpServletRequest.class.isInstance(servletRequest)) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            builder.withRequestMethod(httpServletRequest.getMethod());
            builder.withScheme(httpServletRequest.getScheme());
            this.resolveNetworkProtocolInfo(httpServletRequest.getProtocol(), builder);
            builder.withServerName(httpServletRequest.getServerName());
            builder.withServerPort(httpServletRequest.getServerPort());
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("Expected an HttpServletRequest, instead got [%s].", servletRequest.getClass().toString()), (Object[])new Object[0]);
        }
    }

    private void resolveResponseAttributes(ServletResponse servletResponse, HttpStatAttributes.Builder builder) {
        if (servletResponse instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            builder.withResponseStatus(httpServletResponse.getStatus());
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("Expected an HttpServletResponse, instead got [%s].", servletResponse.getClass().toString()), (Object[])new Object[0]);
        }
    }

    private void resolveNetworkProtocolInfo(String protocolInfo, HttpStatAttributes.Builder builder) {
        String[] networkInfo = protocolInfo.trim().split("/");
        String networkProtocolName = null;
        String networkVersion = "";
        if (networkInfo.length == 1) {
            networkProtocolName = networkInfo[0].toLowerCase();
        } else if (networkInfo.length == 2) {
            networkProtocolName = networkInfo[0];
            networkVersion = networkInfo[1];
        }
        builder.withNetworkProtocolName(networkProtocolName);
        builder.withNetworkProtocolVersion(networkVersion);
    }

    private int resolveStatusForException(Throwable th) {
        UnavailableException ue;
        Throwable rootCause = th;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        int status = rootCause instanceof FileNotFoundException ? 404 : (rootCause instanceof UnavailableException ? ((ue = (UnavailableException)rootCause).isPermanent() ? 404 : 503) : (rootCause instanceof IOException && th.getMessage() != null && th.getMessage().contains("CWWWC0005I") ? 400 : 500));
        return status;
    }

    private String resolveHttpRoute(SRTServletRequest srtServletRequest, String contextPath) {
        String httpRoute = null;
        String pathInfo = srtServletRequest.getPathInfo();
        pathInfo = pathInfo == null ? null : pathInfo.trim();
        String servletPath = srtServletRequest.getServletPath();
        servletPath = servletPath == null ? null : servletPath.trim();
        String requestURI = srtServletRequest.getRequestURI();
        requestURI = requestURI == null ? null : requestURI.trim();
        IWebAppDispatcherContext iwadc = srtServletRequest.getWebAppDispatcherContext();
        WebAppDispatcherContext wadc = null;
        if (iwadc instanceof WebAppDispatcherContext) {
            wadc = (WebAppDispatcherContext)iwadc;
        }
        if (servletPath != null && !servletPath.isEmpty()) {
            if (pathInfo == null) {
                if (servletPath.endsWith(".jsp")) {
                    httpRoute = wadc != null && wadc.getMappingValue() != null && wadc.getMappingValue().endsWith(".jsp") ? contextPath + servletPath : contextPath + "/*";
                } else if (servletPath.startsWith("/jakarta.faces.resource") || servletPath.startsWith("/javax.faces.resource")) {
                    String[] arr = servletPath.split("\\.");
                    String extension = arr[arr.length - 1];
                    httpRoute = contextPath + "/*." + extension;
                } else {
                    String pattern;
                    httpRoute = Servlet4Helper.isServlet4Up() ? ((pattern = Servlet4Helper.getPattern(iwadc)) != null && (pattern.endsWith("/*") || pattern.startsWith("*.")) ? contextPath + "/" + pattern : contextPath + servletPath) : (servletPath.endsWith(".jsf") ? contextPath + "/*.jsf" : (servletPath.endsWith(".faces") ? contextPath + "/*.faces" : (servletPath.endsWith(".xhtml") ? contextPath + "/*.xhtml" : contextPath + servletPath)));
                }
            } else {
                httpRoute = pathInfo != null && !pathInfo.isEmpty() ? contextPath + servletPath + "/*" : contextPath + servletPath;
            }
        } else if (pathInfo != null && servletPath != null && servletPath.isEmpty()) {
            if (pathInfo.trim().equals("/")) {
                httpRoute = contextPath + pathInfo;
            } else if (!pathInfo.isEmpty()) {
                httpRoute = contextPath + "/*";
            } else {
                httpRoute = contextPath + "/*";
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)String.format("Defaulting to \"/*\" for request URI [%s] with the provided pathInfo is [%s] and servlet path [%s]", requestURI, pathInfo, servletPath), (Object[])new Object[0]);
                }
            }
        } else {
            httpRoute = contextPath + "/*";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)String.format("Defaulting to \"/*\" for request URI [%s] with the provided pathInfo is [%s] and servlet path [%s]", requestURI, pathInfo, servletPath), (Object[])new Object[0]);
            }
        }
        return httpRoute;
    }

    public void destroy() {
    }
}

