/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.http.monitor.HttpServerStatsMonitor;
import java.util.Map;
import java.util.stream.Stream;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationStateListener.class}, configurationPid={"com.ibm.ws.monitor.internal.MonitoringFrameworkExtender"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true)
public class MonitorAppStateListener
implements ApplicationStateListener {
    private static final String MONITORING_GROUP_FILTER = "filter";
    private static final TraceComponent tc = Tr.register(MonitorAppStateListener.class, null, null);
    private static volatile boolean isHTTPEnabled = true;
    static final long serialVersionUID = -901256900006769374L;

    public static boolean isHTTPEnabled() {
        return isHTTPEnabled;
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        HttpServerStatsMonitor.getInstance().removeStat(appInfo.getDeploymentName());
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.resolveMonitorFilter(properties);
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> properties) {
        this.resolveMonitorFilter(properties);
    }

    private void resolveMonitorFilter(Map<String, Object> properties) {
        String filter = (String)properties.get(MONITORING_GROUP_FILTER);
        if (filter != null && filter.length() != 0) {
            isHTTPEnabled = filter.length() > 0 ? Stream.of(filter.split(",")).anyMatch(item -> item.equals("HTTP")) : true;
        } else if (filter == null) {
            isHTTPEnabled = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("HTTP filter is enabled set to: [%s]", isHTTPEnabled), (Object[])new Object[0]);
        }
    }
}

