/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transaction.context.internal;

import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.ws.uow.embeddable.SystemException;
import com.ibm.ws.uow.embeddable.UOWManager;
import com.ibm.ws.uow.embeddable.UOWManagerFactory;
import com.ibm.ws.uow.embeddable.UOWToken;
import com.ibm.wsspi.threadcontext.ThreadContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.concurrent.RejectedExecutionException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TransactionContextImpl
implements ThreadContext {
    private static final TraceComponent tc = Tr.register(TransactionContextImpl.class, (String)"TransactionContext", null);
    private static final long serialVersionUID = -6094017242267061944L;
    private static final String CLEARED = "C";
    private static final String UNCHANGED = "U";
    private static final String TYPE = "T";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("T", String.class)};
    private transient UOWToken suspendedUOW;
    transient Boolean suspendTranOfExecutionThread;

    TransactionContextImpl(boolean suspendTranOfExecuctionThread) {
        this.suspendTranOfExecutionThread = suspendTranOfExecuctionThread;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public ThreadContext clone() {
        try {
            TransactionContextImpl copy = (TransactionContextImpl)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException copy) {
            void x;
            FFDCFilter.processException((Throwable)copy, (String)"com.ibm.ws.transaction.context.internal.TransactionContextImpl", (String)"91", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)x);
        }
    }

    @Trivial
    public void taskStarting() throws RejectedExecutionException {
        if (this.suspendTranOfExecutionThread.booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"clear", (Object[])new Object[0]);
            }
            try {
                UOWManager uowManager = UOWManagerFactory.getUOWManager();
                this.suspendedUOW = uowManager.suspend();
            }
            catch (SystemException uowManager) {
                FFDCFilter.processException((Throwable)uowManager, (String)"com.ibm.ws.transaction.context.internal.TransactionContextImpl", (String)"108", (Object)this, (Object[])new Object[0]);
            }
            LocalTransactionCurrent ltCurrent = EmbeddableTransactionManagerFactory.getLocalTransactionCurrent();
            ltCurrent.begin();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public void taskStopping() {
        if (this.suspendTranOfExecutionThread.booleanValue()) {
            Exception exception = null;
            UOWCurrent uowCurrent = EmbeddableTransactionManagerFactory.getUOWCurrent();
            switch (uowCurrent.getUOWType()) {
                case 2: {
                    try {
                        EmbeddableWebSphereTransactionManager tm = EmbeddableTransactionManagerFactory.getTransactionManager();
                        tm.rollback();
                    }
                    catch (Exception tm) {
                        void e;
                        FFDCFilter.processException((Throwable)tm, (String)"com.ibm.ws.transaction.context.internal.TransactionContextImpl", (String)"132", (Object)this, (Object[])new Object[0]);
                        exception = e;
                    }
                    break;
                }
                case 1: {
                    try {
                        LocalTransactionCurrent ltCurrent = EmbeddableTransactionManagerFactory.getLocalTransactionCurrent();
                        ltCurrent.end(0);
                    }
                    catch (Exception ltCurrent) {
                        void e;
                        FFDCFilter.processException((Throwable)ltCurrent, (String)"com.ibm.ws.transaction.context.internal.TransactionContextImpl", (String)"142", (Object)this, (Object[])new Object[0]);
                        exception = e;
                    }
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    exception = new Exception("Invalid transaction type: " + uowCurrent.getUOWType());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("restore   " + this.suspendedUOW), (Object[])new Object[0]);
            }
            try {
                if (this.suspendedUOW != null) {
                    UOWManager uowManager = UOWManagerFactory.getUOWManager();
                    uowManager.resume(this.suspendedUOW);
                    this.suspendedUOW = null;
                }
            }
            catch (Throwable uowManager) {
                void e;
                FFDCFilter.processException((Throwable)uowManager, (String)"com.ibm.ws.transaction.context.internal.TransactionContextImpl", (String)"164", (Object)this, (Object[])new Object[0]);
                exception = e;
            }
            if (exception != null) {
                throw new IllegalStateException(exception);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        Object type = fields.get(TYPE, null);
        if (CLEARED.equals(type)) {
            this.suspendTranOfExecutionThread = true;
        } else if (UNCHANGED.equals(type)) {
            this.suspendTranOfExecutionThread = false;
        }
    }

    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder(100).append(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(this.hashCode()));
        if (this.suspendTranOfExecutionThread.booleanValue()) {
            sb.append(" suspend=true");
        } else {
            sb.append(" unchanged");
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream outStream) throws IOException {
        ObjectOutputStream.PutField fields = outStream.putFields();
        fields.put(TYPE, this.suspendTranOfExecutionThread != false ? CLEARED : UNCHANGED);
        outStream.writeFields();
    }
}

