/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.IdToTransactionTable;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;

public class StaticCATTransaction {
    private static String CLASS_NAME = StaticCATTransaction.class.getName();
    private static CommsByteBufferPool poolManager = CommsByteBufferPool.getInstance();
    private static final TraceComponent tc = SibTr.register(StaticCATTransaction.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");

    static void rcvCreateUCTransaction(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCreateUCTransaction", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectId = request.getShort();
        int clientTransactionId = request.getInt();
        boolean allowSubordinates = true;
        if (conversation.getHandshakeProperties().getFapLevel() >= 5) {
            boolean bl = allowSubordinates = (request.get() & 1) == 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SICoreConnection Id:", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"Client transaction Id:", (Object)clientTransactionId);
        }
        CATConnection catConn = (CATConnection)convState.getObject(connectionObjectId);
        SICoreConnection connection = catConn.getSICoreConnection();
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        SIUncoordinatedTransaction ucTran = null;
        try {
            ucTran = connection.createUncoordinatedTransaction(allowSubordinates);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateUCTransaction"), (String)"3-009-0001");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Failed to create the transaction", (Object)((Object)e));
            }
            linkState.getTransactionTable().addLocalTran(clientTransactionId, conversation.getId(), IdToTransactionTable.INVALID_TRANSACTION);
            linkState.getTransactionTable().markAsRollbackOnly(clientTransactionId, e);
        }
        if (ucTran != null) {
            linkState.getTransactionTable().addLocalTran(clientTransactionId, conversation.getId(), ucTran);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCreateUCTransaction");
        }
    }

    static void rcvCommitTransaction(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCommitTransaction", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        short connectionObjectId = request.getShort();
        int clientTransactionId = request.getInt();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SICoreConnection Id:", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"Client transaction Id:", (Object)clientTransactionId);
        }
        try {
            boolean tranIsRollbackOnly;
            ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
            SITransaction tran = linkState.getTransactionTable().get(clientTransactionId);
            boolean bl = tranIsRollbackOnly = tran == IdToTransactionTable.INVALID_TRANSACTION || linkState.getTransactionTable().isLocalTransactionRollbackOnly(clientTransactionId);
            if (tranIsRollbackOnly) {
                Throwable t = linkState.getTransactionTable().getExceptionForRollbackOnlyLocalTransaction(clientTransactionId);
                linkState.getTransactionTable().removeLocalTransaction(clientTransactionId);
                SIUncoordinatedTransaction siTran = (SIUncoordinatedTransaction)tran;
                if (siTran != null && siTran != IdToTransactionTable.INVALID_TRANSACTION) {
                    siTran.rollback();
                }
                SIRollbackException r = new SIRollbackException(nls.getFormattedMessage("TRANSACTION_MARKED_AS_ERROR_SICO2008", new Object[]{t}, null), t);
                StaticCATHelper.sendExceptionToClient((Throwable)r, null, conversation, requestNumber);
            } else {
                linkState.getTransactionTable().removeLocalTransaction(clientTransactionId);
                SIUncoordinatedTransaction siTran = (SIUncoordinatedTransaction)tran;
                siTran.commit();
                try {
                    conversation.send((JFapByteBuffer)poolManager.allocate(), 209, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCommitTransaction"), (String)"3-009-0006");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                    }
                    SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2026", (Object)((Object)e));
                }
            }
        }
        catch (SIException e) {
            if (!((ConversationState)conversation.getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCommitTransaction"), (String)"3-009-0007");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-009-0007", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCommitTransaction");
        }
    }

    static void rcvRollbackTransaction(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvRollbackTransaction", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        short connectionObjectId = request.getShort();
        int clientTransactionId = request.getInt();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SICoreConnection Id:", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"Client transaction Id:", (Object)clientTransactionId);
        }
        try {
            ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
            SITransaction tran = linkState.getTransactionTable().get(clientTransactionId);
            if (tran == IdToTransactionTable.INVALID_TRANSACTION) {
                Throwable e = linkState.getTransactionTable().getExceptionForRollbackOnlyLocalTransaction(clientTransactionId);
                linkState.getTransactionTable().removeLocalTransaction(clientTransactionId);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Looks like the transaction failed to create", (Object)e);
                }
            } else {
                linkState.getTransactionTable().removeLocalTransaction(clientTransactionId);
                SIUncoordinatedTransaction siTran = (SIUncoordinatedTransaction)tran;
                siTran.rollback();
            }
            try {
                conversation.send((JFapByteBuffer)poolManager.allocate(), 210, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvRollbackTransaction"), (String)"3-009-0008");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2026", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!((ConversationState)conversation.getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvRollbackTransaction"), (String)"3-009-0009");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-009-0009", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvRollbackTransaction");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATTransaction.java, SIB.comms, WASX.SIB, aa1225.01 1.50");
        }
    }
}

