/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.serialization.DeserializationObjectInputStream;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.client.ConsumerMonitorListenerCache;
import com.ibm.ws.sib.comms.client.DestinationListenerCache;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.server.CommsServerByteBuffer;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.ConversationStateFullException;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATConnection;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.CATOrderingContext;
import com.ibm.ws.sib.comms.server.clientsupport.CachedSessionProperties;
import com.ibm.ws.sib.comms.server.clientsupport.ServerConsumerMonitorListener;
import com.ibm.ws.sib.comms.server.clientsupport.ServerDestinationListener;
import com.ibm.ws.sib.comms.server.clientsupport.ServerSICoreConnectionListener;
import com.ibm.ws.sib.comms.server.clientsupport.ServerSideConnection;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.ConsumerSetChangeCallback;
import com.ibm.wsspi.sib.core.DestinationAvailability;
import com.ibm.wsspi.sib.core.DestinationListener;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SICommandInvocationFailedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class StaticCATConnection {
    private static final TraceComponent tc = SibTr.register(StaticCATConnection.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    public static final String $sccsid = "@(#) 1.81 SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATConnection.java, SIB.comms, WASX.SIB, aa1225.01 11/09/16 06:56:53 [7/2/12 05:59:00]";
    private static String CLASS_NAME;
    private static CommsByteBufferPool poolManager;

    static void rcvReceiveConnMsg(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvReceiveConnMsg", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + partOfExchange});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        short connectionObjectId = request.getShort();
        int transactionId = request.getSITransactionId(connectionObjectId, linkState, optimizedTx);
        short reliabilityShort = request.getShort();
        long timeout = request.getLong();
        short destinationTypeShort = request.getShort();
        short unrecovShort = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"consumerObjectId", (Object)connectionObjectId);
            SibTr.debug((TraceComponent)tc, (String)"transactionId", (Object)transactionId);
            SibTr.debug((TraceComponent)tc, (String)"reliability", (Object)reliabilityShort);
            SibTr.debug((TraceComponent)tc, (String)"timeout", (Object)timeout);
            SibTr.debug((TraceComponent)tc, (String)"destinationType", (Object)destinationTypeShort);
            SibTr.debug((TraceComponent)tc, (String)"Unrecov Reliability", (Object)unrecovShort);
        }
        Reliability reliability = null;
        if (reliabilityShort != -1) {
            reliability = Reliability.getReliability((int)reliabilityShort);
        }
        DestinationType destType = null;
        if (destinationTypeShort != -1) {
            destType = DestinationType.getDestinationType((int)destinationTypeShort);
        }
        Reliability unrecoverableReliability = Reliability.getReliability((int)unrecovShort);
        SIDestinationAddress destAddr = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
        SelectionCriteria criteria = request.getSelectionCriteria();
        String alternateUser = request.getString();
        SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectId)).getSICoreConnection();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Cached destination is: " + convState.getCachedConsumerProps()));
        }
        CachedSessionProperties newProps = new CachedSessionProperties(destAddr, criteria, reliability);
        CATMainConsumer consumer = convState.getCachedConsumer();
        if (convState.getCachedConsumer() == null || !newProps.equals(convState.getCachedConsumerProps())) {
            try {
                if (consumer != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Cached consumer was not null. Closing old session");
                    }
                    consumer.getConsumerSession().close();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Creating new session");
                }
                ConsumerSession consumerSession = connection.createConsumerSession(destAddr, destType, criteria, reliability, false, false, unrecoverableReliability, false, alternateUser);
                consumer = new CATMainConsumer(conversation, 0, consumerSession, false, false, unrecoverableReliability);
                consumer.setUsingConnectionReceive(true);
                consumer.start(requestNumber, false, false, null);
            }
            catch (SINotAuthorizedException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
            }
            catch (SIException e) {
                if (!convState.hasMETerminated()) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvReceiveConnMsg"), (String)"3-006-0009");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                StaticCATHelper.sendExceptionToClient(e, "3-006-0009", conversation, requestNumber);
            }
            convState.setCachedConsumerProps(newProps);
            convState.setCachedConsumer(consumer);
        }
        consumer.receive(requestNumber, transactionId, timeout);
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvReceiveConnMsg");
        }
    }

    static void rcvCloneConnection(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCloneConnection", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short conversationId = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"conversationId", (Object)conversationId);
        }
        SICoreConnection parent = ((ServerLinkLevelState)conversation.getLinkLevelAttachment()).getSICoreConnectionTable().get(conversationId);
        try {
            CommsByteBuffer reply = poolManager.allocate();
            StaticCATConnection._cloneConnection(conversation, parent, reply);
            try {
                conversation.send((JFapByteBuffer)reply, 227, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCloneConnection"), (String)"3-006-0001");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2021", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCloneConnection"), (String)"3-006-0002");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-006-0002", conversation, requestNumber);
        }
        catch (ConversationStateFullException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCloneConnection"), (String)"3-006-0003");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-006-0003", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCloneConnection");
        }
    }

    private static void _cloneConnection(Conversation conversation, SICoreConnection parent, CommsByteBuffer reply) throws SIConnectionUnavailableException, ConversationStateFullException, SIConnectionUnavailableException, SIConnectionUnavailableException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_cloneConnection", (Object)("conversation=" + conversation + ", parent=" + parent + ", reply=" + reply));
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        ServerSideConnection cc = new ServerSideConnection(conversation, parent);
        convState.setCommsConnection((CommsConnection)cc);
        SICoreConnection clonedConnection = parent.cloneConnection();
        cc.setSICoreConnection(clonedConnection);
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        ServerSICoreConnectionListener listener = linkState.getSICoreConnectionListener();
        listener.addSICoreConnection(clonedConnection, conversation);
        clonedConnection.addConnectionListener((SICoreConnectionListener)listener);
        CATConnection clonedConn = new CATConnection(clonedConnection);
        short connectionObjectID = (short)convState.addObject(clonedConn);
        convState.setConnectionObjectId(connectionObjectID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"clonedConnectionID=", (Object)connectionObjectID);
        }
        reply.putShort(connectionObjectID);
        if (conversation.getHandshakeProperties().getFapLevel() >= 9) {
            byte[] uniqueId = StaticCATConnection.createUniqueId(clonedConnection);
            reply.putShort(uniqueId.length);
            reply.put(uniqueId);
            int storeId = StaticCATConnection.createOrderContext(convState, clonedConnection);
            reply.putShort(storeId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_cloneConnection");
        }
    }

    static void rcvCloseConnection(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        boolean fap9orAbove;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCloseConnection", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectID = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectID", (Object)connectionObjectID);
        }
        CATConnection catConnection = (CATConnection)convState.getObject(connectionObjectID);
        SICoreConnection connection = catConnection.getSICoreConnection();
        ServerSideConnection serverConnection = (ServerSideConnection)convState.getCommsConnection();
        boolean resetConnection = false;
        SICoreConnection parent = serverConnection.getParentConnection();
        boolean bl = fap9orAbove = conversation.getHandshakeProperties().getFapLevel() >= 9;
        if (fap9orAbove) {
            boolean bl2 = resetConnection = request.get() == 1;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("resetConnection=" + resetConnection));
            }
            if (parent == null) {
                resetConnection = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Current connection has no parent so forcing a close on this connection, resetConnection=" + resetConnection));
                }
            }
        }
        try {
            ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
            connection.removeConnectionListener((SICoreConnectionListener)linkState.getSICoreConnectionListener());
            connection.close();
            linkState.getSICoreConnectionListener().removeSICoreConnection(connection);
            linkState.getSICoreConnectionTable().remove(conversation.getId());
            convState.removeObject(connectionObjectID);
            linkState.getTransactionTable().rollbackEnlisted(conversation);
            linkState.getTransactionTable().removeTransactions(conversation, linkState.getDispatchableMap());
            convState.emptyObjectStore();
            CommsByteBuffer reply = poolManager.allocate();
            if (fap9orAbove) {
                if (resetConnection) {
                    try {
                        reply.put((byte)1);
                        StaticCATConnection._cloneConnection(conversation, parent, reply);
                    }
                    catch (SIConnectionUnavailableException e) {
                        reply.release();
                        reply = poolManager.allocate();
                        reply.put((byte)0);
                        resetConnection = false;
                    }
                } else {
                    reply.put((byte)0);
                }
            }
            try {
                conversation.send((JFapByteBuffer)reply, 192, requestNumber, -1, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCloseConnection"), (String)"3-006-0004");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2021", (Object)((Object)e));
            }
            serverConnection.close(resetConnection);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCloseConnection"), (String)"3-006-0005");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-006-0005", conversation, requestNumber);
        }
        catch (ConversationStateFullException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCloseConnection"), (String)"3-006-0019");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-006-0019", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCloseConnection");
        }
    }

    static void rcvGetUniqueId(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvGetUniqueId", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectID = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"connectionObjectID", (Object)connectionObjectID);
        }
        SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectID)).getSICoreConnection();
        try {
            byte[] uniqueId = StaticCATConnection.createUniqueId(connection);
            CommsByteBuffer reply = poolManager.allocate();
            reply.putShort(uniqueId.length);
            reply.put(uniqueId);
            try {
                conversation.send((JFapByteBuffer)reply, 228, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvGetUniqueId"), (String)"3-006-0006");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2021", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvGetUniqueId"), (String)"3-006-0007");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-006-0007", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvGetUniqueId");
        }
    }

    private static byte[] createUniqueId(SICoreConnection connection) throws SIConnectionUnavailableException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createUniqueId", (Object)("connection=" + connection));
        }
        byte[] uniqueId = connection.createUniqueId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"ID Length", (Object)uniqueId.length);
            SibTr.debug((TraceComponent)tc, (String)"ID: ");
            SibTr.bytes((TraceComponent)tc, (byte[])uniqueId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createUniqueId");
        }
        return uniqueId;
    }

    static void rcvCreateOrderContext(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCreateOrderContext", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectId = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SICoreConnection Id:", (Object)("" + connectionObjectId));
        }
        SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectId)).getSICoreConnection();
        try {
            int storeId = StaticCATConnection.createOrderContext(convState, connection);
            CommsByteBuffer reply = poolManager.allocate();
            reply.putShort(storeId);
            try {
                conversation.send((JFapByteBuffer)reply, 236, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateOrderContext"), (String)"3-006-0010");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2021", (Object)((Object)e));
            }
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateOrderContext"), (String)"3-006-0011");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-006-0011", conversation, requestNumber);
        }
        catch (ConversationStateFullException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCreateOrderContext"), (String)"3-006-0012");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
            }
            StaticCATHelper.sendExceptionToClient(e, "3-006-0012", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCreateOrderContext");
        }
    }

    private static int createOrderContext(ConversationState convState, SICoreConnection connection) throws SIConnectionUnavailableException, ConversationStateFullException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createOrderContext", (Object)("convState=" + convState + ", connection=" + connection));
        }
        CATOrderingContext orderContext = new CATOrderingContext(connection.createOrderingContext());
        int storeId = convState.addObject(orderContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createOrderContext", (Object)("rc=" + storeId));
        }
        return storeId;
    }

    static void rcvCloseOrderContext(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCloseOrderContext", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectId = request.getShort();
        short orderContextId = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SICoreConnection Id:", (Object)("" + connectionObjectId));
            SibTr.debug((TraceComponent)tc, (String)"OrderContext Id:", (Object)("" + orderContextId));
        }
        convState.removeObject(orderContextId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Successfully removed the item from the store");
        }
        try {
            conversation.send((JFapByteBuffer)poolManager.allocate(), 238, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCloseOrderContext"), (String)"3-006-0012");
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2021", (Object)((Object)e));
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCloseOrderContext");
        }
    }

    static void rcvCheckMessagingRequired(CommsByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvCheckMessagingRequired", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool});
        }
        ConversationState convState = (ConversationState)conversation.getAttachment();
        short connectionObjectId = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SICoreConnection Id:", (Object)("" + connectionObjectId));
        }
        SIDestinationAddress requestDestinationAddress = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Request destination address", (Object)requestDestinationAddress);
        }
        SIDestinationAddress replyDestinationAddress = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Reply destination address", (Object)replyDestinationAddress);
        }
        short destinationTypeShort = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Destination Code", (Object)("" + destinationTypeShort));
        }
        DestinationType destType = null;
        if (destinationTypeShort != -1) {
            destType = DestinationType.getDestinationType((int)destinationTypeShort);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Destination Type", (Object)destType);
        }
        String alternateUser = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Alternate User", (Object)alternateUser);
        }
        try {
            HandshakeProperties props = conversation.getHandshakeProperties();
            CommsUtils.checkFapLevel((HandshakeProperties)props, (short)2);
            SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectId)).getSICoreConnection();
            SIDestinationAddress resolvedRequestDestination = connection.checkMessagingRequired(requestDestinationAddress, replyDestinationAddress, destType, alternateUser);
            CommsByteBuffer reply = poolManager.allocate();
            if (resolvedRequestDestination != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Sending back ", (Object)resolvedRequestDestination);
                }
                reply.putSIDestinationAddress(resolvedRequestDestination, conversation.getHandshakeProperties().getFapLevel());
            }
            try {
                conversation.send((JFapByteBuffer)reply, 242, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCheckMessagingRequired"), (String)"3-006-0013");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2021", (Object)((Object)e));
            }
        }
        catch (SINotAuthorizedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvCheckMessagingRequired"), (String)"3-006-0014");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-006-0014", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvCheckMessagingRequired");
        }
    }

    static void rcvInvokeCommand(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean transactedCall) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvInvokeCommand", (Object)new Object[]{request, conversation, "" + requestNumber, "" + allocatedFromBufferPool, "" + transactedCall});
        }
        ServerLinkLevelState linkState = (ServerLinkLevelState)conversation.getLinkLevelAttachment();
        ConversationState convState = (ConversationState)conversation.getAttachment();
        boolean optimizedTx = CommsUtils.requiresOptimizedTransaction((Conversation)conversation);
        short connectionObjectId = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SICoreConnection Id:", (Object)("" + connectionObjectId));
        }
        SITransaction siTran = null;
        if (transactedCall) {
            int transactionId = request.getSITransactionId(connectionObjectId, linkState, optimizedTx);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Transaction Id: ", (Object)("" + transactionId));
            }
            siTran = linkState.getTransactionTable().get(transactionId);
        }
        String keyName = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Key Name", (Object)keyName);
        }
        String cmdName = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Command Name", (Object)cmdName);
        }
        int dataLength = request.getInt();
        byte[] cmdData = request.get(dataLength);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.bytes((TraceComponent)tc, (byte[])cmdData);
        }
        try {
            HandshakeProperties props = conversation.getHandshakeProperties();
            CommsUtils.checkFapLevel((HandshakeProperties)props, (short)5);
            if (transactedCall) {
                CommsUtils.checkFapLevel((HandshakeProperties)props, (short)6);
            }
            Serializable inputObject = null;
            ObjectInputStream ois = null;
            try {
                ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                ois = new DeserializationObjectInputStream((InputStream)new ByteArrayInputStream(cmdData), cl);
                inputObject = (Serializable)ois.readObject();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Successfully deserialized the object", (Object)inputObject);
                }
            }
            catch (Exception e) {
                throw new SICommandInvocationFailedException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"FAILED_TO_DESERIALIZE_COMMAND_SICO2162", null, (String)"FAILED_TO_DESERIALIZE_COMMAND_SICO2162"), (Throwable)e);
            }
            finally {
                block34: {
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block34;
                        SibTr.debug((TraceComponent)tc, (String)"Exception closing the ObjectInputStream", (Object)ex);
                    }
                }
            }
            SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectId)).getSICoreConnection();
            Serializable returnObject = null;
            returnObject = transactedCall ? connection.invokeCommand(keyName, cmdName, inputObject, siTran) : connection.invokeCommand(keyName, cmdName, inputObject);
            CommsByteBuffer reply = poolManager.allocate();
            if (returnObject != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Sending back ", (Object)returnObject);
                }
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(returnObject);
                    byte[] returnDataBytes = baos.toByteArray();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.bytes((TraceComponent)tc, (byte[])returnDataBytes);
                    }
                    reply.putInt(returnDataBytes.length);
                    reply.put(returnDataBytes);
                }
                catch (IOException e) {
                    throw new SICommandInvocationFailedException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.comms.CWSICMessages", (String)"FAILED_TO_SERIALIZE_COMMAND_SICO2161", null, (String)"FAILED_TO_SERIALIZE_COMMAND_SICO2161"), (Throwable)e);
                }
            }
            try {
                conversation.send((JFapByteBuffer)reply, 243, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvInvokeCommand"), (String)"3-006-0015");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2021", (Object)((Object)e));
            }
        }
        catch (SINotAuthorizedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvInvokeCommand"), (String)"3-006-0016");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, "3-006-0016", conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvInvokeCommand");
        }
    }

    static void rcvAddDestinationListener(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvAddDestinationListener");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("conversation=" + conversation + ",requestNumber=" + requestNumber + ",allocatedFromBufferPool=" + allocatedFromBufferPool + ",partOfExchange=" + partOfExchange));
        }
        short connectionObjectId = request.getShort();
        short destinationListenerId = request.getShort();
        short destinationTypeShort = request.getShort();
        short destinationAvailabilityShort = request.getShort();
        String destinationNamePattern = request.getString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("connectionObjectId=" + connectionObjectId));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destinationListenerId=" + destinationListenerId));
        }
        DestinationType destinationType = null;
        if (destinationTypeShort != -1) {
            destinationType = DestinationType.getDestinationType((int)destinationTypeShort);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destinationType=" + destinationType));
        }
        DestinationAvailability destinationAvailability = null;
        if (destinationAvailabilityShort != -1) {
            destinationAvailability = DestinationAvailability.getDestinationAvailability((int)destinationAvailabilityShort);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destinationAvailability=" + destinationAvailability));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destinationNamePattern=" + destinationNamePattern));
        }
        SIDestinationAddress[] results = null;
        ConversationState convState = (ConversationState)conversation.getAttachment();
        try {
            SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectId)).getSICoreConnection();
            DestinationListenerCache destinationListenerCache = convState.getDestinationListenerCache();
            DestinationListener destinationListener = destinationListenerCache.get(destinationListenerId);
            if (destinationListener == null) {
                destinationListener = new ServerDestinationListener(destinationListenerId, connectionObjectId, conversation);
                destinationListenerCache.add(destinationListenerId, destinationListener);
            }
            results = connection.addDestinationListener(destinationNamePattern, destinationListener, destinationType, destinationAvailability);
            CommsByteBuffer reply = poolManager.allocate();
            reply.putShort(connectionObjectId);
            int count = (short)(results == null ? 0 : (short)results.length);
            reply.putShort((short)count);
            for (int i = 0; i < count; ++i) {
                reply.putSIDestinationAddress(results[i], conversation.getHandshakeProperties().getFapLevel());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"rcvAddDestinationListener", (Object)(count + " SIDestinationAddress objects to return"));
            }
            try {
                conversation.send((JFapByteBuffer)reply, 253, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvAddDestinationListener"), (String)"3-006-0017");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2021", (Object)((Object)e));
            }
        }
        catch (SIIncorrectCallException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SICommandInvocationFailedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIConnectionUnavailableException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvAddDestinationListener"), (String)"3-006-0018");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvAddDestinationListener");
        }
    }

    static void rcvAddConsumerMonitorListener(CommsServerByteBuffer request, Conversation conversation, int requestNumber, boolean allocatedFromBufferPool, boolean partOfExchange) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rcvAddConsumerMonitorListener", (Object)new Object[]{"conversation=" + conversation + ",requestNumber=" + requestNumber + ",allocatedFromBufferPool=" + allocatedFromBufferPool + ",partOfExchange=" + partOfExchange});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("conversation=" + conversation + ",requestNumber=" + requestNumber + ",allocatedFromBufferPool=" + allocatedFromBufferPool + ",partOfExchange=" + partOfExchange));
        }
        short connectionObjectId = request.getShort();
        SIDestinationAddress destinationAddress = request.getSIDestinationAddress(conversation.getHandshakeProperties().getFapLevel());
        String topicExpression = request.getString();
        short consumerMonitorListenerID = request.getShort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("connectionObjectId=" + connectionObjectId));
            SibTr.debug((TraceComponent)tc, (String)("destinationAddress=" + destinationAddress));
            SibTr.debug((TraceComponent)tc, (String)("topicExpression=" + topicExpression));
            SibTr.debug((TraceComponent)tc, (String)("consumerMonitorListenerID=" + consumerMonitorListenerID));
        }
        boolean areConsumers = false;
        ConversationState convState = (ConversationState)conversation.getAttachment();
        try {
            SICoreConnection connection = ((CATConnection)convState.getObject(connectionObjectId)).getSICoreConnection();
            ConsumerMonitorListenerCache consumerMonitorListenerCache = convState.getConsumerMonitorListenerCache();
            ConsumerSetChangeCallback consumerSetChangeCallback = consumerMonitorListenerCache.get(consumerMonitorListenerID);
            if (consumerSetChangeCallback == null) {
                consumerSetChangeCallback = new ServerConsumerMonitorListener(consumerMonitorListenerID, connectionObjectId, conversation);
                consumerMonitorListenerCache.add(consumerMonitorListenerID, consumerSetChangeCallback);
            }
            areConsumers = connection.registerConsumerSetMonitor(destinationAddress, topicExpression, consumerSetChangeCallback);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"rcvAddConsumerMonitorListener", (Object)("areConsumers : " + areConsumers));
            }
            CommsByteBuffer reply = poolManager.allocate();
            reply.putShort(connectionObjectId);
            reply.putBoolean(areConsumers);
            try {
                conversation.send((JFapByteBuffer)reply, 132, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvAddConsumerMonitorListener"), (String)"3-006-0020");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2021", (Object)((Object)e));
            }
        }
        catch (SIErrorException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        catch (SIException e) {
            if (!convState.hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".rcvAddConsumerMonitorListener"), (String)"3-006-0021");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            StaticCATHelper.sendExceptionToClient(e, null, conversation, requestNumber);
        }
        request.release(allocatedFromBufferPool);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rcvAddConsumerMonitorListener");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.81 SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATConnection.java, SIB.comms, WASX.SIB, aa1225.01 11/09/16 06:56:53 [7/2/12 05:59:00]");
        }
        CLASS_NAME = StaticCATConnection.class.getName();
        poolManager = CommsByteBufferPool.getInstance();
    }
}

