/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.util.Hashtable;
import java.util.List;

public class ServerSICoreConnectionListener
implements SICoreConnectionListener {
    private static String CLASS_NAME = ServerSICoreConnectionListener.class.getName();
    private static final TraceComponent tc = SibTr.register(ServerSICoreConnectionListener.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private final Hashtable<String, Object> quiesceNotif = new Hashtable();
    private final Hashtable<String, Object> termNotif = new Hashtable();
    private final Hashtable<SICoreConnection, Conversation> conversationTable = new Hashtable();

    public void addSICoreConnection(SICoreConnection conn, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSICoreConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Params: connection, conversation", (Object)new Object[]{conn, conversation});
        }
        this.conversationTable.put(conn, conversation);
        this.quiesceNotif.remove(conn.getMeUuid());
        this.termNotif.remove(conn.getMeUuid());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSICoreConnection");
        }
    }

    public void removeSICoreConnection(SICoreConnection conn) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeSICoreConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Params: connection", (Object)conn);
        }
        this.conversationTable.remove(conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeSICoreConnection");
        }
    }

    public void asynchronousException(ConsumerSession session, Throwable e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"asynchronousException", (Object)new Object[]{session, e});
        }
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".asynchronousException"), (String)"3-005-0003", (Object)this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Caught an async exception:", (Object)e);
        }
        try {
            this.sendMeNotificationEvent((short)4, null, session, e);
        }
        catch (SIException e2) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".asynchronousException"), (String)"3-005-0006", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
            }
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2018", (Object)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"asynchronousException");
        }
    }

    public void meQuiescing(SICoreConnection conn) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"meQuiescing");
        }
        String meUuid = conn.getMeUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"ME Uuid: ", (Object)meUuid);
        }
        if (this.quiesceNotif.get(meUuid) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"We have not sent a notification about this ME");
            }
            try {
                this.sendMeNotificationEvent((short)2, conn, null, null);
                this.quiesceNotif.put(meUuid, new Object());
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".meQuiescing"), (String)"3-005-0005", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2018", (Object)((Object)e));
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Already sent notification about this ME");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"meQuiescing");
        }
    }

    public void meTerminated(SICoreConnection conn) {
        Conversation conversation;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"meTerminated");
        }
        if ((conversation = this.conversationTable.get(conn)) != null) {
            ConversationState convState = (ConversationState)conversation.getAttachment();
            convState.setMETerminated();
        }
        String meUuid = conn.getMeUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"ME Uuid: ", (Object)meUuid);
        }
        if (this.termNotif.get(meUuid) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"We have not sent a notification about this ME");
            }
            try {
                this.sendMeNotificationEvent((short)3, conn, null, null);
                this.termNotif.put(meUuid, new Object());
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".meTerminated"), (String)"3-005-0002", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2018", (Object)((Object)e));
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Already sent notification about this ME");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"meTerminated");
        }
    }

    private void sendMeNotificationEvent(short eventId, SICoreConnection conn, ConsumerSession sess, Throwable t) throws SIConnectionLostException, SIConnectionDroppedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendMeNotificationEvent", (Object)new Object[]{"" + eventId, conn, sess, t});
        }
        Conversation conversation2 = null;
        int consumerId = -1;
        if (conn != null) {
            conversation2 = this.conversationTable.get(conn);
        } else {
            for (Conversation conversation2 : this.conversationTable.values()) {
                ConversationState convState = (ConversationState)conversation2.getAttachment();
                List allObjs = convState.getAllObjects();
                for (int x = 0; x < allObjs.size(); ++x) {
                    CATMainConsumer mainConsumer;
                    ConsumerSession ourSession;
                    if (!(allObjs.get(x) instanceof CATMainConsumer) || (ourSession = (mainConsumer = (CATMainConsumer)allObjs.get(x)).getConsumerSession()) != sess) continue;
                    consumerId = mainConsumer.getClientSessionId();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Located consumer. Session Id is", (Object)("" + consumerId));
                    break;
                }
                if (consumerId == -1) continue;
                break;
            }
        }
        if (consumerId == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Consumer Id was 0 - ignoring this notification");
            }
        } else if (conversation2 == null) {
            NullPointerException npe = new NullPointerException("No conversation was located");
            FFDCFilter.processException((Throwable)npe, (String)(CLASS_NAME + ".sendMeNotificationEvent"), (String)"3-005-0001", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)npe.getMessage(), (Object)npe);
            }
        } else if (sess != null && consumerId == -1) {
            SIResourceException e = new SIResourceException("Unable to locate consumer session");
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendMeNotificationEvent"), (String)"3-005-0001", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)e);
            }
        } else {
            ConversationState convState = (ConversationState)conversation2.getAttachment();
            CommsByteBuffer buffer = CommsByteBufferPool.getInstance().allocate();
            buffer.putShort(convState.getConnectionObjectId());
            buffer.putShort(eventId);
            if (sess != null) {
                buffer.putShort(consumerId);
                buffer.putException(t, null, conversation2);
            }
            if (eventId == 3 || eventId == 2) {
                conversation2.send((JFapByteBuffer)buffer, 225, 0, 11, true, Conversation.ThrottlingPolicy.DISCARD_TRANSMISSION, null);
            } else {
                conversation2.send((JFapByteBuffer)buffer, 225, 0, 11, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendMeNotificationEvent");
        }
    }

    public void commsFailure(SICoreConnection conn, SIConnectionLostException e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commsFailure", (Object)new Object[]{conn, e});
        }
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".commsFailure"), (String)"3-005-0004", (Object)this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Caught a comms exception:", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commsFailure");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/ServerSICoreConnectionListener.java, SIB.comms, WASX.SIB, aa1225.01 1.31");
        }
    }
}

