/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security.authentication.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.ws.messaging.security.MessagingSecurityConstants;
import com.ibm.ws.messaging.security.MessagingSecurityException;
import com.ibm.ws.messaging.security.authentication.MessagingAuthenticationException;
import com.ibm.ws.messaging.security.authentication.MessagingAuthenticationService;
import com.ibm.ws.messaging.security.authentication.actions.MessagingLoginAction;
import com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImpl;
import com.ibm.ws.messaging.security.utility.MessagingSecurityUtility;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.AccessController;
import java.security.cert.Certificate;
import javax.security.auth.Subject;

public class MessagingAuthenticationServiceImpl
implements MessagingAuthenticationService,
MessagingSecurityConstants {
    private static TraceComponent tc = SibTr.register(MessagingAuthenticationServiceImpl.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.";
    private MessagingSecurityServiceImpl _messagingSecurityService = null;
    private final AuthenticationData authenticationDataForSubject = new WSAuthenticationData();
    private final AuditManager auditManager = new AuditManager();

    public MessagingAuthenticationServiceImpl(MessagingSecurityServiceImpl messagingSecurityService) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.constructor", (Object)messagingSecurityService);
        }
        this._messagingSecurityService = messagingSecurityService;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.constructor");
        }
    }

    public Subject login(Subject subj) throws MessagingAuthenticationException {
        String busName = null;
        String messagingEngine = null;
        String credType = "User subject";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.login", (Object)subj);
        }
        if (this.auditManager != null) {
            if (this.auditManager.getJMSBusName() != null) {
                busName = this.auditManager.getJMSBusName();
            }
            if (this.auditManager.getJMSMessagingEngine() != null) {
                messagingEngine = this.auditManager.getJMSMessagingEngine();
            }
        }
        Subject result = null;
        result = AccessController.doPrivileged(new MessagingLoginAction(this.authenticationDataForSubject, "SUBJECT", this._messagingSecurityService.getSecurityService(), subj));
        if (result == null) {
            String userName = null;
            try {
                userName = this._messagingSecurityService.getUniqueUserName(subj);
            }
            catch (MessagingSecurityException messagingSecurityException) {
                // empty catch block
            }
            if (this.auditManager != null && this.auditManager.getJMSConversationMetaData() != null) {
                ConversationMetaData cmd = (ConversationMetaData)this.auditManager.getJMSConversationMetaData();
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, cmd.getRemoteAddress().getHostAddress(), new Integer(cmd.getRemotePort()).toString(), cmd.getChainName(), busName, messagingEngine, credType, Integer.valueOf("201")});
            } else {
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, null, null, null, busName, messagingEngine, credType, Integer.valueOf("201")});
            }
            this.throwAuthenticationException(userName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.login", (Object)result);
        }
        if (this.auditManager != null && this.auditManager.getJMSConversationMetaData() != null) {
            ConversationMetaData cmd = (ConversationMetaData)this.auditManager.getJMSConversationMetaData();
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{subj.getPrincipals().iterator().next().getName(), cmd.getRemoteAddress().getHostAddress(), new Integer(cmd.getRemotePort()).toString(), cmd.getChainName(), busName, messagingEngine, credType, Integer.valueOf("200")});
        } else {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{subj.getPrincipals().iterator().next().getName(), null, null, null, busName, messagingEngine, credType, Integer.valueOf("200")});
        }
        return result;
    }

    public Subject login(String userName, String password) throws MessagingAuthenticationException {
        ConversationMetaData cmd;
        String busName = null;
        String messagingEngine = null;
        String credType = "Userid+Password";
        if (this.auditManager != null) {
            if (this.auditManager.getJMSBusName() != null) {
                busName = this.auditManager.getJMSBusName();
            }
            if (this.auditManager.getJMSMessagingEngine() != null) {
                messagingEngine = this.auditManager.getJMSMessagingEngine();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.login", (Object)new Object[]{userName, "Password Not Traced"});
        }
        Subject result = null;
        AuthenticationData authData = MessagingSecurityUtility.createAuthenticationData(userName, password);
        result = AccessController.doPrivileged(new MessagingLoginAction(authData, "USERID", this._messagingSecurityService.getSecurityService()));
        if (result == null) {
            if (this.auditManager != null && this.auditManager.getJMSConversationMetaData() != null) {
                cmd = (ConversationMetaData)this.auditManager.getJMSConversationMetaData();
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, cmd.getRemoteAddress().getHostAddress(), new Integer(cmd.getRemotePort()).toString(), cmd.getChainName(), busName, messagingEngine, credType, Integer.valueOf("201")});
            } else {
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, null, null, null, busName, messagingEngine, credType, Integer.valueOf("201")});
            }
            this.throwAuthenticationException(userName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.login", (Object)result);
        }
        if (this.auditManager != null && this.auditManager.getJMSConversationMetaData() != null) {
            cmd = (ConversationMetaData)this.auditManager.getJMSConversationMetaData();
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, cmd.getRemoteAddress().getHostAddress(), new Integer(cmd.getRemotePort()).toString(), cmd.getChainName(), busName, messagingEngine, credType, Integer.valueOf("200")});
        } else {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, null, null, null, busName, messagingEngine, credType, Integer.valueOf("200")});
        }
        return result;
    }

    public Subject login(byte[] securityToken, String securityTokenType) throws MessagingAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.login", (Object)new Object[]{securityToken, securityTokenType});
        }
        String busName = null;
        String messagingEngine = null;
        String credType = "Token";
        if (this.auditManager != null) {
            if (this.auditManager.getJMSBusName() != null) {
                busName = this.auditManager.getJMSBusName();
            }
            if (this.auditManager.getJMSMessagingEngine() != null) {
                messagingEngine = this.auditManager.getJMSMessagingEngine();
            }
        }
        Subject result = null;
        boolean doLogin = "LTPA".equals(securityTokenType);
        if (doLogin) {
            AuthenticationData authData = MessagingSecurityUtility.createAuthenticationData(securityToken);
            result = AccessController.doPrivileged(new MessagingLoginAction(authData, "LTPA", this._messagingSecurityService.getSecurityService()));
            if (result == null) {
                String userName = null;
                try {
                    userName = this._messagingSecurityService.getUniqueUserName(result);
                }
                catch (MessagingSecurityException messagingSecurityException) {
                    // empty catch block
                }
                if (this.auditManager != null && this.auditManager.getJMSConversationMetaData() != null) {
                    ConversationMetaData cmd = (ConversationMetaData)this.auditManager.getJMSConversationMetaData();
                    Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, cmd.getRemoteAddress().getHostAddress(), new Integer(cmd.getRemotePort()).toString(), cmd.getChainName(), busName, messagingEngine, credType, Integer.valueOf("201")});
                } else {
                    Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, null, null, null, busName, messagingEngine, credType, Integer.valueOf("201")});
                }
                this.throwAuthenticationException(userName);
            }
        } else {
            SibTr.error((TraceComponent)tc, (String)"SECURITY_TOKEN_TYPE_NOT_SUPPORTED_MSE1002", (Object)securityTokenType);
            result = null;
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{new String(securityToken), this.auditManager.getJMSConversationMetaData(), busName, messagingEngine, credType, Integer.valueOf("201")});
            throw new MessagingAuthenticationException(Tr.formatMessage((TraceComponent)tc, (String)"SECURITY_TOKEN_TYPE_NOT_SUPPORTED_MSE1002", (Object[])new Object[0]));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.login", (Object)result);
        }
        if (this.auditManager != null && this.auditManager.getJMSConversationMetaData() != null) {
            ConversationMetaData cmd = (ConversationMetaData)this.auditManager.getJMSConversationMetaData();
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{new String(securityToken), cmd.getRemoteAddress().getHostAddress(), new Integer(cmd.getRemotePort()).toString(), cmd.getChainName(), busName, messagingEngine, credType, Integer.valueOf("200")});
        } else {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{new String(securityToken), null, null, null, busName, messagingEngine, credType, Integer.valueOf("200")});
        }
        return result;
    }

    public Subject login(String userName) throws MessagingAuthenticationException {
        ConversationMetaData cmd;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.login", (Object)userName);
        }
        String busName = null;
        String messagingEngine = null;
        String credType = "UserId";
        if (this.auditManager != null) {
            if (this.auditManager.getJMSBusName() != null) {
                busName = this.auditManager.getJMSBusName();
            }
            if (this.auditManager.getJMSMessagingEngine() != null) {
                messagingEngine = this.auditManager.getJMSMessagingEngine();
            }
        }
        Subject result = null;
        AuthenticationData authData = MessagingSecurityUtility.createAuthenticationData(userName, this._messagingSecurityService.getUserRegistry());
        result = AccessController.doPrivileged(new MessagingLoginAction(authData, "IDASSERTION", this._messagingSecurityService.getSecurityService()));
        if (result == null) {
            if (this.auditManager != null && this.auditManager.getJMSConversationMetaData() != null) {
                cmd = (ConversationMetaData)this.auditManager.getJMSConversationMetaData();
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, cmd.getRemoteAddress().getHostAddress(), new Integer(cmd.getRemotePort()).toString(), cmd.getChainName(), busName, messagingEngine, credType, Integer.valueOf("201")});
            } else {
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, null, null, null, busName, messagingEngine, credType, Integer.valueOf("201")});
            }
            this.throwAuthenticationException(userName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.login", (Object)result);
        }
        if (this.auditManager != null && this.auditManager.getJMSConversationMetaData() != null) {
            cmd = (ConversationMetaData)this.auditManager.getJMSConversationMetaData();
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, cmd.getRemoteAddress().getHostAddress(), new Integer(cmd.getRemotePort()).toString(), cmd.getChainName(), busName, messagingEngine, credType, Integer.valueOf("200")});
        } else {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, null, null, null, busName, messagingEngine, credType, Integer.valueOf("200")});
        }
        return result;
    }

    public Subject login(Certificate[] certificates) throws MessagingAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.login", (Object)certificates);
        }
        String busName = null;
        String messagingEngine = null;
        String credType = "Certificates";
        if (this.auditManager != null) {
            if (this.auditManager.getJMSBusName() != null) {
                busName = this.auditManager.getJMSBusName();
            }
            if (this.auditManager.getJMSMessagingEngine() != null) {
                messagingEngine = this.auditManager.getJMSMessagingEngine();
            }
        }
        Subject result = null;
        if (certificates == null) {
            result = null;
        } else {
            AuthenticationData authData = MessagingSecurityUtility.createAuthenticationData(certificates, this._messagingSecurityService.getUserRegistry());
            result = AccessController.doPrivileged(new MessagingLoginAction(authData, "CLIENTSSL", this._messagingSecurityService.getSecurityService()));
            if (result == null) {
                String userName = null;
                try {
                    userName = this._messagingSecurityService.getUniqueUserName(result);
                }
                catch (MessagingSecurityException messagingSecurityException) {
                    // empty catch block
                }
                if (this.auditManager != null && this.auditManager.getJMSConversationMetaData() != null) {
                    ConversationMetaData cmd = (ConversationMetaData)this.auditManager.getJMSConversationMetaData();
                    Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, cmd.getRemoteAddress().getHostAddress(), new Integer(cmd.getRemotePort()).toString(), cmd.getChainName(), busName, messagingEngine, credType, Integer.valueOf("201")});
                } else {
                    Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{userName, null, null, null, busName, messagingEngine, credType, Integer.valueOf("201")});
                }
                this.throwAuthenticationException(userName);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.login", result);
        }
        if (this.auditManager != null && this.auditManager.getJMSConversationMetaData() != null) {
            ConversationMetaData cmd = (ConversationMetaData)this.auditManager.getJMSConversationMetaData();
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{certificates.toString(), cmd.getRemoteAddress().getHostAddress(), new Integer(cmd.getRemotePort()).toString(), cmd.getChainName(), busName, messagingEngine, credType, Integer.valueOf("200")});
        } else {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_01, (Object[])new Object[]{certificates.toString(), null, null, null, busName, messagingEngine, credType, Integer.valueOf("200")});
        }
        return result;
    }

    public void logout(Subject subj) {
        String userName = null;
        try {
            userName = this._messagingSecurityService.getUniqueUserName(subj);
        }
        catch (MessagingSecurityException messagingSecurityException) {
            // empty catch block
        }
        if (this.auditManager != null && this.auditManager.getJMSConversationMetaData() != null) {
            ConversationMetaData cmd = (ConversationMetaData)this.auditManager.getJMSConversationMetaData();
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_TERMINATE_01, (Object[])new Object[]{userName, cmd.getRemoteAddress().getHostAddress(), new Integer(cmd.getRemotePort()).toString(), cmd.getChainName(), this.auditManager.getJMSBusName(), this.auditManager.getJMSMessagingEngine(), null, Integer.valueOf("200")});
        } else {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_JMS_AUTHN_TERMINATE_01, (Object[])new Object[]{userName, null, null, null, this.auditManager.getJMSBusName(), this.auditManager.getJMSMessagingEngine(), null, Integer.valueOf("200")});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.logout", (Object)subj);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl.logout");
        }
    }

    private void throwAuthenticationException(String userName) throws MessagingAuthenticationException {
        throw new MessagingAuthenticationException(Tr.formatMessage((TraceComponent)tc, (String)"USER_NOT_AUTHENTICATED_MSE1009", (Object[])new Object[]{userName}));
    }
}

