/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security.authentication.actions;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.security.MessagingSecurityConstants;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;

public class MessagingLoginAction
implements MessagingSecurityConstants,
PrivilegedAction<Subject> {
    private static TraceComponent tc = SibTr.register(MessagingLoginAction.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.authentication.actions.MessagingLoginAction";
    protected static AuthenticationService _authenticationService = null;
    protected AuthenticationData _authenticationData = null;
    protected String _loginType = null;
    protected Subject _partialSubject = null;

    public MessagingLoginAction(AuthenticationData authData, String loginType, SecurityService securityService) {
        this(authData, loginType, securityService, null);
    }

    public MessagingLoginAction(AuthenticationData authData, String loginType, SecurityService securityService, Subject partialSubject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.actions.MessagingLoginActionconstructor", (Object)new Object[]{authData, loginType, securityService});
        }
        this._authenticationData = authData;
        this._loginType = loginType;
        _authenticationService = this.getAuthenticationService(securityService);
        this._partialSubject = partialSubject;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.actions.MessagingLoginActionconstructor");
        }
    }

    public AuthenticationService getAuthenticationService(SecurityService securityService) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.actions.MessagingLoginActiongetAuthenticationService", (Object)securityService);
        }
        if (_authenticationService == null && securityService != null) {
            _authenticationService = securityService.getAuthenticationService();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.actions.MessagingLoginActiongetAuthenticationService", (Object)_authenticationService);
        }
        return _authenticationService;
    }

    @Override
    public final Subject run() {
        return this.login();
    }

    public String getLoginType() {
        return this._loginType;
    }

    protected Subject login() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.actions.MessagingLoginActionlogin");
        }
        Subject subject = null;
        try {
            if (_authenticationService != null) {
                subject = _authenticationService.authenticate("system.DEFAULT", this._authenticationData, this._partialSubject);
            }
        }
        catch (AuthenticationException ae) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"EXCEPTION_OCCURED_DURING_AUTHENTICATION_MSE1001");
                SibTr.exception((TraceComponent)tc, (Exception)((Object)ae));
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.actions.MessagingLoginActionlogin");
            }
        }
        return subject;
    }
}

