/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.BusinessLocalWrapperProxy;
import com.ibm.ejs.container.EJSLocalHomeWrapperProxy;
import com.ibm.ejs.container.EJSLocalWrapperProxy;
import com.ibm.ejs.container.LocalBeanWrapperProxy;
import com.ibm.ejs.container.WrapperProxyState;
import com.ibm.ejs.container.util.DeploymentUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.JITUtils;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.EJBLocalObject;
import java.util.ArrayList;
import java.util.Arrays;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class EJBWrapperProxy {
    private static final TraceComponent tc = Tr.register(EJBWrapperProxy.class, (String)"JITDeploy", (String)"com.ibm.ejs.container.container");
    private static final String WRAPPER_PROXY_STATE_INTERNAL_NAME = JITUtils.convertClassName(WrapperProxyState.class.getName());
    private static final String WRAPPER_PROXY_STATE_TYPE_NAME = 'L' + WRAPPER_PROXY_STATE_INTERNAL_NAME + ';';
    private static final String LOCAL_WRAPPER_PROXY_INTERNAL_NAME = JITUtils.convertClassName(EJSLocalWrapperProxy.class.getName());
    private static final String LOCAL_HOME_WRAPPER_PROXY_INTERNAL_NAME = JITUtils.convertClassName(EJSLocalHomeWrapperProxy.class.getName());
    private static final String BUSINESS_LOCAL_WRAPPER_PROXY_INTERNAL_NAME = JITUtils.convertClassName(BusinessLocalWrapperProxy.class.getName());
    private static final String LOCAL_BEAN_WRAPPER_PROXY_INTERNAL_NAME = JITUtils.convertClassName(LocalBeanWrapperProxy.class.getName());
    public static final String LOCAL_BEAN_PROXY_FIELD = "ivProxy";
    private static final String LOCAL_BEAN_PROXY_FIELD_TYPE_NAME = 'L' + BUSINESS_LOCAL_WRAPPER_PROXY_INTERNAL_NAME + ";";

    public static String getProxyClassName(Class<?> intf) {
        String intfName = intf.getName();
        if (intfName.startsWith("java.")) {
            return "com.ibm.ejs.container.deploy." + intfName;
        }
        StringBuilder stubBuilder = new StringBuilder(intfName);
        int packageOffset = Math.max(intfName.lastIndexOf(46) + 1, intfName.lastIndexOf(36) + 1);
        stubBuilder.insert(packageOffset, "EJSProxy$$");
        return stubBuilder.toString();
    }

    public static byte[] generateClassBytes(String proxyClassName, Class<?>[] intfs, java.lang.reflect.Method[] methods) {
        String internalSuperName;
        boolean isClassProxy;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        String internalClassName = JITUtils.convertClassName(proxyClassName);
        Object[] internalInterfaceNames = new String[intfs.length];
        String resolveDesc = "(L" + BUSINESS_LOCAL_WRAPPER_PROXY_INTERNAL_NAME + ";)Ljava/lang/Object;";
        for (int i = 0; i < internalInterfaceNames.length; ++i) {
            internalInterfaceNames[i] = JITUtils.convertClassName(intfs[i].getName());
        }
        boolean bl = isClassProxy = !intfs[0].isInterface();
        if (isClassProxy) {
            internalSuperName = JITUtils.convertClassName(internalInterfaceNames[0]);
            internalInterfaceNames[0] = LOCAL_BEAN_WRAPPER_PROXY_INTERNAL_NAME;
        } else {
            boolean isEJBLocalHome = false;
            boolean isEJBLocalObject = false;
            Class<?>[] classArray = intfs;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> intf = classArray[i];
                isEJBLocalHome |= EJBLocalHome.class.isAssignableFrom(intf);
                isEJBLocalObject |= EJBLocalObject.class.isAssignableFrom(intf);
            }
            String string = isEJBLocalHome ? LOCAL_HOME_WRAPPER_PROXY_INTERNAL_NAME : (internalSuperName = isEJBLocalObject ? LOCAL_WRAPPER_PROXY_INTERNAL_NAME : BUSINESS_LOCAL_WRAPPER_PROXY_INTERNAL_NAME);
            if (isEJBLocalHome || isEJBLocalObject) {
                resolveDesc = "(L" + LOCAL_WRAPPER_PROXY_INTERNAL_NAME + ";)Ljava/lang/Object;";
            }
        }
        if (isTraceOn) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"generateClassBytes", (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("     className = " + internalClassName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("     interface = " + Arrays.toString(internalInterfaceNames)), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("     super     = " + internalSuperName), (Object[])new Object[0]);
            }
        }
        ClassWriter cw = new ClassWriter(1);
        cw.visit(46, 33, internalClassName, null, internalSuperName, (String[])internalInterfaceNames);
        EJBWrapperProxy.addFields(cw, isClassProxy);
        EJBWrapperProxy.addCtor(cw, internalClassName, isClassProxy, internalSuperName);
        if (isClassProxy) {
            EJBWrapperProxy.addClassProxyEqualsMethod(cw, internalClassName);
            EJBWrapperProxy.addClassProxyHashCodeMethod(cw, internalClassName);
        }
        for (java.lang.reflect.Method method : methods) {
            EJBWrapperProxy.addMethod(cw, internalClassName, isClassProxy, resolveDesc, method);
        }
        if (isClassProxy) {
            ArrayList<java.lang.reflect.Method> nonPublicMethods = DeploymentUtil.getNonPublicMethods(intfs[0], methods);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("     Non-public methods : " + nonPublicMethods.size()), (Object[])new Object[0]);
            }
            for (java.lang.reflect.Method method : nonPublicMethods) {
                EJBWrapperProxy.addMethod(cw, internalClassName, true, resolveDesc, method);
            }
        }
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JITUtils.writeToClassFile(internalClassName, classBytes);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateClassBytes: " + classBytes.length + " bytes"));
        }
        return classBytes;
    }

    private static void addFields(ClassWriter cw, boolean isClassProxy) {
        if (isClassProxy) {
            boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("     adding field : ivProxy " + LOCAL_BEAN_PROXY_FIELD_TYPE_NAME), (Object[])new Object[0]);
            }
            cw.visitField(18, LOCAL_BEAN_PROXY_FIELD, LOCAL_BEAN_PROXY_FIELD_TYPE_NAME, null, null);
        }
    }

    private static void addCtor(ClassWriter cw, String internalClassName, boolean isClassProxy, String internalSuperName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : <init> ()V", (Object[])new Object[0]);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + WRAPPER_PROXY_STATE_TYPE_NAME + ")V", null, null);
        mv.visitCode();
        if (isClassProxy) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, internalSuperName, "<init>", "()V");
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, BUSINESS_LOCAL_WRAPPER_PROXY_INTERNAL_NAME);
            mv.visitInsn(89);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, BUSINESS_LOCAL_WRAPPER_PROXY_INTERNAL_NAME, "<init>", "(" + WRAPPER_PROXY_STATE_TYPE_NAME + ")V");
            mv.visitFieldInsn(181, internalClassName, LOCAL_BEAN_PROXY_FIELD, LOCAL_BEAN_PROXY_FIELD_TYPE_NAME);
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, internalSuperName, "<init>", "(" + WRAPPER_PROXY_STATE_TYPE_NAME + ")V");
        }
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static void addClassProxyEqualsMethod(ClassWriter cw, String implClassName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : equals (Ljava/lang/Object;)Z", (Object[])new Object[0]);
        }
        String desc = "(Ljava/lang/Object;)Z";
        MethodVisitor mv = cw.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(193, implClassName);
        Label if_instanceofType_End = new Label();
        mv.visitJumpInsn(153, if_instanceofType_End);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, implClassName, LOCAL_BEAN_PROXY_FIELD, LOCAL_BEAN_PROXY_FIELD_TYPE_NAME);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, implClassName);
        mv.visitFieldInsn(180, implClassName, LOCAL_BEAN_PROXY_FIELD, LOCAL_BEAN_PROXY_FIELD_TYPE_NAME);
        mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
        mv.visitInsn(172);
        mv.visitLabel(if_instanceofType_End);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static void addClassProxyHashCodeMethod(ClassWriter cw, String implClassName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : hashCode ()I", (Object[])new Object[0]);
        }
        String desc = "()I";
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, implClassName, LOCAL_BEAN_PROXY_FIELD, LOCAL_BEAN_PROXY_FIELD_TYPE_NAME);
        mv.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I");
        mv.visitInsn(172);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
    }

    private static void addMethod(ClassWriter cw, String internalClassName, boolean isClassProxy, String resolveDesc, java.lang.reflect.Method method) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + method), (Object[])new Object[0]);
        }
        String methodName = method.getName();
        Type[] paramTypes = JITUtils.getTypes(method.getParameterTypes());
        Method m = new Method(methodName, Type.getType(method.getReturnType()), paramTypes);
        Type[] exceptionTypes = JITUtils.getTypes(method.getExceptionTypes());
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        if (isClassProxy) {
            mg.visitVarInsn(25, 0);
            mg.visitFieldInsn(180, internalClassName, LOCAL_BEAN_PROXY_FIELD, LOCAL_BEAN_PROXY_FIELD_TYPE_NAME);
        } else {
            mg.visitVarInsn(25, 0);
        }
        Class<?> declaringClass = method.getDeclaringClass();
        String internalDeclaringClassName = JITUtils.convertClassName(declaringClass.getName());
        mg.visitMethodInsn(184, "com/ibm/ejs/container/EJSContainer", "resolveWrapperProxy", resolveDesc);
        mg.visitTypeInsn(192, internalDeclaringClassName);
        for (int i = 0; i < paramTypes.length; ++i) {
            mg.loadArg(i);
        }
        mg.visitMethodInsn(declaringClass.isInterface() ? 185 : 182, internalDeclaringClassName, method.getName(), m.getDescriptor());
        mg.returnValue();
        mg.endMethod();
    }
}

