/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.diagnostics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.diagnostics.IntrospectionWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class TrDumpWriter
implements IntrospectionWriter {
    private final TraceComponent tc;
    private String ivTitle;
    private final ArrayList<String> ivDumpData = new ArrayList();

    public TrDumpWriter(TraceComponent tc) {
        this.tc = tc;
    }

    private void flush() {
        if (this.ivTitle != null) {
            if (this.ivDumpData.isEmpty()) {
                Tr.dump((TraceComponent)this.tc, (String)this.ivTitle, (Object[])new Object[0]);
            } else {
                Tr.dump((TraceComponent)this.tc, (String)this.ivTitle, (Object[])this.ivDumpData.toArray(new String[this.ivDumpData.size()]));
                this.ivDumpData.clear();
            }
            this.ivTitle = null;
        }
    }

    @Override
    public void begin(String title) {
        this.flush();
        this.ivTitle = title != null ? title : "";
    }

    @Override
    public void end() {
        this.flush();
    }

    @Override
    public void println(String line) {
        this.ivDumpData.add(line);
    }

    @Override
    public void dump(String[] lines) {
        this.ivDumpData.addAll(Arrays.asList(lines));
    }
}

