/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.csi.EJBApplicationMetaData;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.websphere.cpmi.PMModuleCookie;
import com.ibm.websphere.csi.EJBModuleMetaData;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.JCDIHelper;
import com.ibm.ws.ejbcontainer.runtime.EJBApplicationEventListener;
import com.ibm.ws.javaee.dd.ejb.Interceptor;
import com.ibm.ws.metadata.ejb.AutomaticTimerBean;
import com.ibm.ws.metadata.ejb.EJBInterceptorBinding;
import com.ibm.ws.metadata.ejb.InterceptorMethodKind;
import com.ibm.ws.metadata.ejb.ModuleInitData;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataImpl;
import com.ibm.wsspi.ejbcontainer.JITDeploy;
import jakarta.ejb.ApplicationException;
import jakarta.ejb.EJBException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EJBModuleMetaDataImpl
extends MetaDataImpl
implements EJBModuleMetaData {
    private static final TraceComponent tc = Tr.register(EJBModuleMetaDataImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final boolean isJakarta = EJBException.class.getCanonicalName().startsWith("jakarta");
    private static final int RMIC_COMPATIBLE_ALL = -1;
    public ModuleInitData ivInitData;
    public String ivName;
    public String ivLogicalName;
    public String ivAppName;
    public J2EEName ivJ2EEName;
    public int ivModuleVersion;
    private final EJBApplicationMetaData ivEJBApplicationMetaData;
    public boolean ivSfsbFailover;
    public String ivFailoverInstanceId;
    public PMModuleCookie ivPMModuleCookie;
    public boolean ivMetadataComplete = false;
    public boolean ivReadWCCMInterceptors = true;
    public Map<String, ApplicationException> ivApplicationExceptionMap;
    public IdentityHashMap<Class<?>, EnumMap<InterceptorMethodKind, List<Method>>> ivInterceptorsMap;
    public Map<String, List<EJBInterceptorBinding>> ivInterceptorBindingMap;
    public String ivCurrentBackendId = null;
    public String ivDefaultCmpConnectionFactory = null;
    public String ivDefaultDataSource = null;
    public String ivDefaultDataSourceUser = null;
    public String ivDefaultDataSourcePassword = null;
    public Map<String, Interceptor> ivInterceptorMap;
    public boolean ivMBeanRegistered = false;
    public final Map<String, String> ivMessageDestinationBindingMap = new HashMap<String, String>();
    public boolean ivMetaDataDestroyRequired = false;
    public boolean ivUseExtendedSetRollbackOnlyBehavior = false;
    public List<AutomaticTimerBean> ivAutomaticTimerBeans;
    public boolean ivHasNonPersistentAutomaticTimers = false;
    public boolean ivHasPersistentAutomaticTimers = false;
    public Map<String, BeanMetaData> ivBeanMetaDatas = new LinkedHashMap<String, BeanMetaData>();
    private int ivNumFullyInitializedBeans;
    public List<EJBApplicationEventListener> ivApplicationEventListeners;
    public boolean ivStopping;
    public boolean ivEJBInWAR;
    public boolean ivManagedBeansInClient;
    public boolean ivManagedBeansOnly;
    public JCDIHelper ivJCDIHelper;
    public String ivVersionedAppBaseName;
    public String ivVersionedModuleBaseName;
    public boolean ivAllowsCachedTimerData;

    public EJBModuleMetaDataImpl(int slotCnt, EJBApplicationMetaData ejbAMD) {
        super(slotCnt);
        this.ivEJBApplicationMetaData = ejbAMD;
    }

    public Boolean getApplicationExceptionRollback(Throwable t) {
        Class<?> klass = t.getClass();
        ApplicationException ae = this.getApplicationException(klass);
        Boolean rollback = null;
        if (ae != null) {
            rollback = ae.rollback();
        } else if (!ContainerProperties.EE5Compatibility) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("searching for inherited application exception for " + klass.getName()), (Object[])new Object[0]);
            }
            for (Class<?> superClass = klass.getSuperclass(); superClass != Throwable.class; superClass = superClass.getSuperclass()) {
                ae = this.getApplicationException(superClass);
                if (ae == null) continue;
                if (!ae.inherited()) break;
                rollback = ae.rollback();
                break;
            }
        }
        return rollback;
    }

    private ApplicationException getApplicationException(Class<?> klass) {
        ApplicationException result = null;
        if (this.ivApplicationExceptionMap != null) {
            result = this.ivApplicationExceptionMap.get(klass.getName());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && result != null) {
                Tr.debug((TraceComponent)tc, (String)("found application-exception for " + klass.getName() + ", rollback=" + result.rollback() + ", inherited=" + result.inherited()), (Object[])new Object[0]);
            }
        }
        if (result == null) {
            result = klass.getAnnotation(ApplicationException.class);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && result != null) {
                Tr.debug((TraceComponent)tc, (String)("found ApplicationException for " + klass.getName() + ", rollback=" + result.rollback() + ", inherited=" + result.inherited()), (Object[])new Object[0]);
            }
        }
        return result;
    }

    public String getName() {
        return this.ivName;
    }

    @Override
    public int getEJBModuleVersion() {
        return this.ivModuleVersion;
    }

    public J2EEName getJ2EEName() {
        return this.ivJ2EEName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentMetaData[] getComponentMetaDatas() {
        ComponentMetaData[] initializedComponentMetaDatas = null;
        EJBApplicationMetaData eJBApplicationMetaData = this.ivEJBApplicationMetaData;
        synchronized (eJBApplicationMetaData) {
            initializedComponentMetaDatas = new ComponentMetaData[this.ivNumFullyInitializedBeans];
            int i = 0;
            for (BeanMetaData bmd : this.ivBeanMetaDatas.values()) {
                if (!bmd.fullyInitialized) continue;
                initializedComponentMetaDatas[i++] = bmd;
            }
        }
        return initializedComponentMetaDatas;
    }

    public ApplicationMetaData getApplicationMetaData() {
        return this.ivEJBApplicationMetaData.getApplicationMetaData();
    }

    public EJBApplicationMetaData getEJBApplicationMetaData() {
        return this.ivEJBApplicationMetaData;
    }

    public void release() {
    }

    public String toDumpString() {
        String newLine = (String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("line.separator", "\n"));
        StringBuilder sb = new StringBuilder(this.toString());
        String indent = "   ";
        sb.append(newLine + newLine + "--- Dump EJBModuleMetaDataImpl fields ---");
        if (this.ivName != null) {
            sb.append(newLine + indent + "Module name = " + this.ivName);
        } else {
            sb.append(newLine + indent + "Module name = null");
        }
        if (this.ivLogicalName != null) {
            sb.append(newLine + indent + "Module logical name = " + this.ivLogicalName);
        } else {
            sb.append(newLine + indent + "Module logical name = null");
        }
        sb.append(newLine + indent + "Module version = " + this.ivModuleVersion);
        if (this.getApplicationMetaData() != null) {
            sb.append(newLine + indent + "Application metadata = " + this.getApplicationMetaData());
        } else {
            sb.append(newLine + indent + "Application metadata = null");
        }
        sb.append(newLine + indent + "Beans = " + this.ivBeanMetaDatas.keySet());
        if (this.ivApplicationExceptionMap != null) {
            sb.append(newLine + indent + "Application Exception map contents:");
            for (Map.Entry<String, ApplicationException> entry : this.ivApplicationExceptionMap.entrySet()) {
                ApplicationException value = entry.getValue();
                sb.append(newLine + indent + indent + "Exception: " + entry.getKey() + ", rollback = " + value.rollback() + ", inherited = " + value.inherited());
            }
        } else {
            sb.append(newLine + indent + "Application Exception map = null");
        }
        sb.append(newLine + indent + "SFSB failover = " + this.ivSfsbFailover);
        if (this.ivFailoverInstanceId != null) {
            sb.append(newLine + indent + "Failover instance ID = " + this.ivFailoverInstanceId);
        } else {
            sb.append(newLine + indent + "Failover instance ID = null");
        }
        sb.append(newLine + indent + "Fully initialized bean count = " + this.ivNumFullyInitializedBeans);
        sb.append(newLine + indent + "JCDIHelper = " + this.ivJCDIHelper);
        sb.append(newLine + indent + "UseExtendedSetRollbackOnlyBehavior = " + this.ivUseExtendedSetRollbackOnlyBehavior);
        sb.append(newLine + indent + "VersionedBaseName = " + this.ivVersionedAppBaseName + "#" + this.ivVersionedModuleBaseName);
        this.toString(sb, newLine, indent);
        sb.append(newLine + "--- End EJBModuleMetaDataImpl fields ---");
        sb.append(newLine);
        return sb.toString();
    }

    protected void toString(StringBuilder sb, String nl, String indent) {
    }

    public boolean isEJBDeployed() {
        return this.ivModuleVersion < 30 && !this.ivEJBInWAR;
    }

    public int getRMICCompatible() {
        int rmicCompatible;
        int n = rmicCompatible = isJakarta ? -1 : JITDeploy.RMICCompatible;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRMICCompatible : " + rmicCompatible + (isJakarta ? " (jakarta)" : " (javax)")), (Object[])new Object[0]);
        }
        return rmicCompatible;
    }

    public final List<EJBInterceptorBinding> getEJBInterceptorBindings(String ejbName) {
        return this.ivInterceptorBindingMap.get(ejbName);
    }

    public final List<EJBInterceptorBinding> removeEJBInterceptorBindings(String ejbName) {
        return this.ivInterceptorBindingMap.remove(ejbName);
    }

    public void addApplicationEventListener(EJBApplicationEventListener listener) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addApplicationEventListener: " + listener), (Object[])new Object[0]);
        }
        if (this.ivApplicationEventListeners == null) {
            this.ivApplicationEventListeners = new ArrayList<EJBApplicationEventListener>();
        }
        this.ivApplicationEventListeners.add(listener);
    }

    public void addAutomaticTimerBean(AutomaticTimerBean timerBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addAutomaticTimerBean: " + timerBean.getBeanMetaData().j2eeName), (Object[])new Object[0]);
        }
        if (this.ivAutomaticTimerBeans == null) {
            this.ivAutomaticTimerBeans = new ArrayList<AutomaticTimerBean>();
        }
        this.ivHasNonPersistentAutomaticTimers |= timerBean.getNumNonPersistentTimers() > 0;
        this.ivHasPersistentAutomaticTimers |= timerBean.getNumPersistentTimers() > 0;
        this.ivAutomaticTimerBeans.add(timerBean);
    }

    public void freeResourcesAfterAllBeansInitialized(BeanMetaData bmd) {
        boolean freeResources;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("freeResourcesAfterAllBeansInitialized: " + bmd.j2eeName + ", " + (this.ivNumFullyInitializedBeans + 1) + "/" + this.ivBeanMetaDatas.size()), (Object[])new Object[0]);
        }
        ++this.ivNumFullyInitializedBeans;
        boolean bl = freeResources = this.ivNumFullyInitializedBeans == this.ivBeanMetaDatas.size();
        if (freeResources) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("all beans are initialized in module name = " + this.ivName + ", freeing resources no longer needed"), (Object[])new Object[0]);
            }
            this.ivInterceptorMap = null;
            this.ivInterceptorBindingMap = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"freeResourcesAfterAllBeansInitialized");
        }
    }

    @Override
    public void setVersionedModuleBaseName(String appBaseName, String modBaseName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ModuleName = " + this.ivName + ", VersionedBaseName = " + appBaseName + "#" + modBaseName), (Object[])new Object[0]);
        }
        if (this.ivInitData == null) {
            throw new IllegalStateException("ModuleMetaData has finished creation.");
        }
        if (appBaseName == null) {
            throw new IllegalArgumentException("appBaseName is null");
        }
        if (modBaseName == null) {
            throw new IllegalArgumentException("modBaseName is null");
        }
        this.ivEJBApplicationMetaData.validateVersionedModuleBaseName(appBaseName, modBaseName);
        this.ivVersionedAppBaseName = appBaseName;
        this.ivVersionedModuleBaseName = modBaseName;
    }

    public boolean isVersionedModule() {
        return this.ivVersionedModuleBaseName != null;
    }
}

