/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.interceptors;

import com.ibm.ejs.container.LifecycleInterceptorWrapper;
import com.ibm.ejs.container.ManagedBeanOBase;
import com.ibm.ejs.container.interceptors.InterceptorProxy;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.managedobject.ConstructionCallback;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectInvocationContext;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import java.lang.reflect.Method;
import java.util.Map;

public class InterceptorMetaData {
    private static final String CLASS_NAME = InterceptorMetaData.class.getName();
    private static final TraceComponent tc = Tr.register(InterceptorMetaData.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    public final Class<?>[] ivInterceptorClasses;
    public final ManagedObjectFactory<?>[] ivInterceptorFactories;
    public final InterceptorProxy[] ivAroundConstructInterceptors;
    public final InterceptorProxy[] ivPrePassivateInterceptors;
    public final InterceptorProxy[] ivPreDestroyInterceptors;
    public final InterceptorProxy[] ivPostConstructInterceptors;
    public final InterceptorProxy[] ivPostActivateInterceptors;
    public final Method[] ivBeanLifecycleMethods;
    public InjectionTarget[][] ivInterceptorInjectionTargets;

    public InterceptorMetaData(Class<?>[] classes, ManagedObjectFactory<?>[] factories, InterceptorProxy[] aroundConstruct, InterceptorProxy[] postConstruct, InterceptorProxy[] postActivate, InterceptorProxy[] prePassivate, InterceptorProxy[] preDestroy, Method[] beanLifecycleMethods) {
        this.ivAroundConstructInterceptors = aroundConstruct;
        this.ivInterceptorClasses = classes;
        this.ivInterceptorFactories = factories;
        this.ivPostConstructInterceptors = postConstruct;
        this.ivPostActivateInterceptors = postActivate;
        this.ivPrePassivateInterceptors = prePassivate;
        this.ivPreDestroyInterceptors = preDestroy;
        this.ivBeanLifecycleMethods = beanLifecycleMethods;
    }

    public void createInterceptorInstances(InjectionEngine injectionEngine, Object[] interceptors, ManagedObjectContext managedObjectContext, ManagedBeanOBase targetContext) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createInterceptorInstances", (Object[])new Object[0]);
        }
        if (this.ivInterceptorClasses != null) {
            int numberOfInterceptors = this.ivInterceptorClasses.length;
            for (int i = 0; i < numberOfInterceptors; ++i) {
                interceptors[i] = this.ivInterceptorFactories == null || this.ivInterceptorFactories[i] == null ? this.createInterceptorInstanceUsingConstructor(injectionEngine, this.ivInterceptorClasses[i], this.ivInterceptorInjectionTargets[i], targetContext) : this.createInterceptorInstancesUsingMOF(this.ivInterceptorInjectionTargets[i], managedObjectContext, targetContext, this.ivInterceptorFactories[i]);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createInterceptorInstances");
        }
    }

    private Object createInterceptorInstanceUsingConstructor(InjectionEngine injectionEngine, Class<?> interceptorClass, InjectionTarget[] targetsForClass, ManagedBeanOBase targetContext) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createInterceptorInstanceUsingConstructor", (Object[])new Object[0]);
        }
        Object interceptor = interceptorClass.newInstance();
        try {
            if (targetsForClass.length > 0) {
                for (InjectionTarget oneTarget : targetsForClass) {
                    injectionEngine.inject(interceptor, oneTarget, (InjectionTargetContext)targetContext);
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + "createInterceptorInstanceUsingConstructor"), (String)"248", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Injection failure", (Object[])new Object[]{t});
            }
            throw ExceptionUtil.EJBException("Injection failure", t);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createInterceptorInstanceUsingConstructor", interceptor);
        }
        return interceptor;
    }

    public Object createInterceptorInstancesUsingMOF(InjectionTarget[] targetsForClass, ManagedObjectContext managedObjectContext, ManagedBeanOBase targetContext, ManagedObjectFactory<?> interceptorFactory) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createInterceptorInstancesUsingMOF", (Object[])new Object[0]);
        }
        ManagedObjectInvocationContextImpl invocationContext = new ManagedObjectInvocationContextImpl(managedObjectContext);
        ManagedObject managedObject = interceptorFactory.createManagedObject((ManagedObjectInvocationContext)invocationContext);
        Object interceptor = managedObject.getObject();
        try {
            managedObject.inject(targetsForClass, (InjectionTargetContext)targetContext);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + "createInterceptorInstancesUsingMOF"), (String)"284", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Injection failure", (Object[])new Object[]{t});
            }
            throw ExceptionUtil.EJBException("Injection failure", t);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createInterceptorInstancesUsingMOF", (Object)interceptor);
        }
        return interceptor;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Interceptor MetaData:\n");
        if (this.ivInterceptorClasses != null) {
            buffer.append("     Interceptor classes:\n");
            for (Class<?> clazz : this.ivInterceptorClasses) {
                buffer.append("          " + clazz.getName() + "\n");
            }
        } else {
            buffer.append("     Interceptor classes: NONE\n");
        }
        if (this.ivPostConstructInterceptors != null) {
            buffer.append("     PostConstruct interceptor methods:\n");
            for (InterceptorProxy interceptorProxy : this.ivPostConstructInterceptors) {
                buffer.append("          " + interceptorProxy.toString() + "\n");
            }
        } else {
            buffer.append("     PostConstruct interceptor methods: NONE\n");
        }
        if (this.ivPostActivateInterceptors != null) {
            buffer.append("     PostActivate interceptor methods:\n");
            for (InterceptorProxy interceptorProxy : this.ivPostActivateInterceptors) {
                buffer.append("          " + interceptorProxy.toString() + "\n");
            }
        } else {
            buffer.append("     PostActivate interceptor methods: NONE\n");
        }
        if (this.ivPrePassivateInterceptors != null) {
            buffer.append("     PrePassivate interceptor methods:\n");
            for (InterceptorProxy interceptorProxy : this.ivPrePassivateInterceptors) {
                buffer.append("          " + interceptorProxy.toString() + "\n");
            }
        } else {
            buffer.append("     PrePassivate interceptor methods: NONE\n");
        }
        if (this.ivPreDestroyInterceptors != null) {
            buffer.append("     PreDestroy interceptor methods:\n");
            for (InterceptorProxy interceptorProxy : this.ivPreDestroyInterceptors) {
                buffer.append("          " + interceptorProxy.toString() + "\n");
            }
        } else {
            buffer.append("     PreDestroy interceptor methods: NONE\n");
        }
        if (this.ivAroundConstructInterceptors != null) {
            buffer.append("     AroundConstruct interceptor methods:\n");
            for (InterceptorProxy interceptorProxy : this.ivAroundConstructInterceptors) {
                buffer.append("          " + interceptorProxy.toString() + "\n");
            }
        } else {
            buffer.append("     AroundConstruct interceptor methods: NONE\n");
        }
        if (this.ivBeanLifecycleMethods != null) {
            buffer.append("     BeanLifecycle methods:\n");
            for (int i = 0; i < this.ivBeanLifecycleMethods.length; ++i) {
                buffer.append("          ").append(LifecycleInterceptorWrapper.TRACE_NAMES[i]).append(": ").append(this.ivBeanLifecycleMethods[i]).append("\n");
            }
        } else {
            buffer.append("     BeanLifeCycle methods: NONE\n");
        }
        if (this.ivInterceptorInjectionTargets != null) {
            buffer.append("     InjectionTargets for interceptor classes:\n");
            for (int a = 0; a < this.ivInterceptorInjectionTargets.length; ++a) {
                buffer.append("          Interceptor class: " + a + "\n");
                for (int b = 0; b < this.ivInterceptorInjectionTargets[a].length; ++b) {
                    buffer.append("               " + this.ivInterceptorInjectionTargets[a][b] + "\n");
                }
            }
        } else {
            buffer.append("     InjectionTargets for interceptor classes: NONE\n");
        }
        return buffer.toString();
    }

    private static final class ManagedObjectInvocationContextImpl
    implements ManagedObjectInvocationContext {
        private final ManagedObjectContext managedObjectContext;

        private ManagedObjectInvocationContextImpl(ManagedObjectContext managedObjectContext) {
            this.managedObjectContext = managedObjectContext;
        }

        public Object aroundConstruct(ConstructionCallback constructionCallback, Object[] parameters, Map data) throws Exception {
            return constructionCallback.getConstructor().newInstance(parameters);
        }

        public ManagedObjectContext getManagedObjectContext() {
            return this.managedObjectContext;
        }

        public void prePostConstruct(ManagedObject mo) {
        }
    }
}

