/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.TimedObjectWrapper;
import com.ibm.ejs.container.TimerNpImpl;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Date;

public abstract class TimerNpRunnable
implements Runnable {
    private static final String CLASS_NAME = TimerNpRunnable.class.getName();
    private static final TraceComponent tc = Tr.register(TimerNpRunnable.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final long PAUSED = -1L;
    private BeanId ivBeanId;
    private final int ivMethodId;
    private long ivRetries = 0L;
    private final int ivRetryLimit;
    private final long ivRetryInterval;
    protected final TimerNpImpl ivTimer;
    private static volatile boolean serverStopping;
    private static volatile long earliestExpiration;

    public TimerNpRunnable(TimerNpImpl timerNpImpl, int retryLimit, long retryInterval) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init>: " + timerNpImpl), (Object[])new Object[0]);
        }
        this.ivBeanId = timerNpImpl.getIvBeanId();
        this.ivMethodId = timerNpImpl.ivMethodId;
        this.ivTimer = timerNpImpl;
        this.ivRetryLimit = retryLimit;
        this.ivRetryInterval = retryInterval;
    }

    public static void serverStopping() {
        serverStopping = true;
    }

    public static void pause() {
        earliestExpiration = -1L;
    }

    public static void resume() {
        earliestExpiration = System.currentTimeMillis();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.ivTimer.ivTaskId + ", " + this.ivBeanId + ", " + this.ivRetries + ")";
    }

    @Override
    public void run() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("run: " + this.ivTimer.ivTaskId), (Object[])new Object[0]);
        }
        if (serverStopping) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"run: Server shutting down; aborting");
            }
            return;
        }
        long currentExpiration = this.ivTimer.getIvExpiration();
        if (earliestExpiration == -1L) {
            currentExpiration = this.ivTimer.calculateNextExpiration();
            this.ivTimer.scheduleNext();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("run: Timer Service paused; timer rescheduled: " + (currentExpiration == 0L ? "NoMoreTimeouts" : new Date(currentExpiration))));
            }
            return;
        }
        if (currentExpiration < earliestExpiration) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("skipping missed timeouts: " + currentExpiration + " -> " + earliestExpiration), (Object[])new Object[0]);
            }
            while (currentExpiration > 0L && currentExpiration < earliestExpiration) {
                currentExpiration = this.ivTimer.calculateNextExpiration();
            }
            this.ivTimer.scheduleNext();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("run: timer rescheduled: " + (currentExpiration == 0L ? "NoMoreTimeouts" : new Date(currentExpiration))));
            }
            return;
        }
        if (this.ivRetries == 0L) {
            this.ivTimer.calculateNextExpiration();
        }
        this.ivTimer.checkLateTimerThreshold();
        try {
            if (this.ivTimer.isIvDestroyed()) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"Timer has been cancelled; aborting");
                }
                return;
            }
            this.doWork();
            this.ivRetries = 0L;
            this.ivTimer.scheduleNext();
        }
        catch (Throwable ex) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("NP Timer failed : " + ex.getClass().getName() + ":" + ex.getMessage()), (Object[])new Object[]{ex});
            }
            if (this.ivRetryLimit != -1 && this.ivRetries >= (long)this.ivRetryLimit) {
                this.ivTimer.calculateNextExpiration();
                this.ivTimer.scheduleNext();
                this.ivRetries = 0L;
                Tr.warning((TraceComponent)tc, (String)"NP_TIMER_RETRY_LIMIT_REACHED_CNTR0179W", (Object[])new Object[]{this.ivRetryLimit});
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"Timer retry limit has been reached; aborting");
                }
                return;
            }
            ++this.ivRetries;
            if (this.ivRetries == 1L) {
                this.run();
            }
            this.ivTimer.scheduleRetry(this.ivRetryInterval);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("doWork: " + this.ivTimer), (Object[])new Object[0]);
        }
        try {
            this.ivBeanId = this.ivBeanId.getInitializedBeanId();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".doWork"), (String)"247", (Object)this);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("doWork: " + ex));
            }
            throw ExceptionUtil.EJBException(ex);
        }
        EJSHome home = (EJSHome)this.ivBeanId.home;
        TimedObjectWrapper timedObject = home.getTimedObjectWrapper(this.ivBeanId);
        try {
            this.ivTimer.ivTimeoutThread = Thread.currentThread();
            timedObject.invokeCallback(this.ivTimer, this.ivMethodId, false);
        }
        finally {
            this.ivTimer.ivTimeoutThread = null;
            home.putTimedObjectWrapper(timedObject);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doWork");
            }
        }
    }

    public TimerNpImpl getNpTimer() {
        return this.ivTimer;
    }

    public int getMethodId() {
        return this.ivMethodId;
    }

    protected abstract void schedule(long var1);

    protected abstract void scheduleNext(long var1);

    protected abstract void scheduleRetry(long var1);

    protected abstract void cancel();

    static {
        earliestExpiration = 0L;
    }
}

