/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerEJBException;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapper;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.container.LifecycleInterceptorWrapper;
import com.ibm.ejs.container.ManagedBeanOBase;
import com.ibm.ejs.container.ServerAsyncResult;
import com.ibm.ejs.container.UserTransactionEnabledContext;
import com.ibm.ejs.container.UserTransactionWrapper;
import com.ibm.ejs.container.WrapperInterface;
import com.ibm.ejs.container.interceptors.InterceptorProxy;
import com.ibm.ejs.container.interceptors.InvocationContextImpl;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.websphere.ejbcontainer.SessionContextExtension;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.CallbackKind;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.traceinfo.ejbcontainer.TEBeanLifeCycleInfo;
import jakarta.ejb.EJBException;
import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import jakarta.ejb.RemoveException;
import jakarta.ejb.SessionBean;
import jakarta.transaction.UserTransaction;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Map;
import javax.rmi.PortableRemoteObject;
import javax.xml.rpc.handler.MessageContext;

public abstract class SessionBeanO
extends ManagedBeanOBase
implements SessionContextExtension,
UserTransactionEnabledContext {
    private static final TraceComponent tc = Tr.register(SessionBeanO.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.SessionBeanO";
    public static final int DESTROYED = 0;
    public static final int PRE_CREATE = 1;
    public static final int CREATING = 2;
    private static Method messageContextMethod;
    public SessionBean sessionBean;
    protected int currentIsolationLevel = 0;
    public CallbackKind ivCallbackKind;

    public SessionBeanO(EJSContainer c, EJSHome h) {
        super(c, h);
        if (this.home == null) {
            this.ivCallbackKind = CallbackKind.None;
        } else {
            BeanMetaData bmd = this.home.beanMetaData;
            this.ivCallbackKind = bmd.ivCallbackKind;
        }
    }

    @Override
    public void setEnterpriseBean(Object bean) {
        super.setEnterpriseBean(bean);
        if (bean instanceof SessionBean) {
            this.sessionBean = (SessionBean)bean;
        }
    }

    protected void callLifecycleInterceptors(InterceptorProxy[] proxies, int methodId) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        try {
            if (isTraceOn) {
                if (TEBeanLifeCycleInfo.isTraceEnabled()) {
                    TEBeanLifeCycleInfo.traceEJBCallEntry(LifecycleInterceptorWrapper.TRACE_NAMES[methodId]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"callLifecycleInterceptors", (Object[])new Object[0]);
                }
            }
            InvocationContextImpl inv = this.getInvocationContext();
            BeanMetaData bmd = this.home.beanMetaData;
            inv.doLifeCycle(proxies, bmd._moduleMetaData);
        }
        catch (Throwable t) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionBean PostConstruct failure", (Object[])new Object[]{t});
            }
            throw ExceptionUtil.EJBException("session bean lifecycle interceptor failure", t);
        }
        finally {
            if (isTraceOn && TEBeanLifeCycleInfo.isTraceEnabled()) {
                TEBeanLifeCycleInfo.traceEJBCallExit(LifecycleInterceptorWrapper.TRACE_NAMES[methodId]);
            }
        }
    }

    @Override
    public final void invalidate() {
    }

    @Override
    public synchronized UserTransaction getUserTransaction() {
        if (this.state == 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Incorrect state: " + this.getStateName(this.state)), (Object[])new Object[0]);
            }
            throw new IllegalStateException(this.getStateName(this.state));
        }
        return UserTransactionWrapper.INSTANCE;
    }

    @Override
    public Map<String, Object> getContextData() {
        if (this.state == 1 || this.state == 0) {
            IllegalStateException ise = new IllegalStateException("SessionBean: getContextData not allowed from state = " + this.getStateName(this.state));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getContextData: " + ise), (Object[])new Object[0]);
            }
            throw ise;
        }
        return super.getContextData();
    }

    protected void canBeRemoved() throws RemoveException {
        ContainerTx tx = this.container.getCurrentContainerTx();
        if (tx == null) {
            return;
        }
        if (tx.isTransactionGlobal() && tx.ivRemoveBeanO != this) {
            throw new RemoveException("Cannot remove session bean within a transaction.");
        }
    }

    public EJBObject getEJBObject() {
        EJBObject result = null;
        if (this.state == 1 || this.state == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Incorrect state: " + this.getStateName(this.state)), (Object[])new Object[0]);
            }
            throw new IllegalStateException(this.getStateName(this.state));
        }
        try {
            EJSWrapper wrapper = this.container.wrapperManager.getWrapper(this.beanId).getRemoteWrapper();
            Object wrapperRef = this.container.getEJBRuntime().getRemoteReference(wrapper);
            result = (EJBObject)PortableRemoteObject.narrow((Object)wrapperRef, this.home.beanMetaData.remoteInterfaceClass);
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.SessionBeanO.getEJBObject", (String)"204", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getEJBObject() failed", (Object[])new Object[]{ex});
            }
            throw new IllegalStateException("Failed to obtain EJBObject", ex);
        }
        return result;
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        EJBLocalObject result = null;
        if (this.state == 1 || this.state == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Incorrect state: " + this.getStateName(this.state)), (Object[])new Object[0]);
            }
            throw new IllegalStateException(this.getStateName(this.state));
        }
        try {
            result = this.container.wrapperManager.getWrapper(this.beanId).getLocalObject();
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.SessionBeanO.getEJBLocalObject", (String)"236", (Object)this);
            ContainerEJBException cex = new ContainerEJBException("getEJBLocalObject() failed", ex);
            Tr.error((TraceComponent)tc, (String)"CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", (Object[])new Object[]{ex, cex.toString()});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getEJBLocalObject() failed", (Object[])new Object[]{ex});
            }
            throw cex;
        }
        return result;
    }

    @Override
    public Object getBeanInstance() {
        return this.ivEjbInstance;
    }

    @Override
    public Object[] getInterceptors() {
        return this.ivInterceptors;
    }

    public MessageContext getMessageContext() throws IllegalStateException {
        boolean isEndpointMethod = false;
        EJSDeployedSupport context = EJSContainer.getMethodContext();
        if (context instanceof EJSDeployedSupport) {
            EJSDeployedSupport s = context;
            if (s.methodInfo.ivInterface == MethodInterface.SERVICE_ENDPOINT) {
                isEndpointMethod = true;
            }
        }
        if (!isEndpointMethod) {
            IllegalStateException ise = new IllegalStateException("SessionBean: getMessageContext not allowed from Non-WebService Endpoint method");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getMessageContext: " + ise), (Object[])new Object[0]);
            }
            throw ise;
        }
        if (messageContextMethod == null) {
            try {
                messageContextMethod = Class.forName("com.ibm.ws.webservices.engine.MessageContext").getMethod("getCurrentThreadsContext", null);
            }
            catch (SecurityException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.SessionBeanO.getMessageContext", (String)"348", (Object)this);
            }
            catch (NoSuchMethodException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.SessionBeanO.getMessageContext", (String)"354", (Object)this);
            }
            catch (ClassNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.SessionBeanO.getMessageContext", (String)"360", (Object)this);
            }
        }
        MessageContext theMessageContext = null;
        try {
            theMessageContext = (MessageContext)messageContextMethod.invoke(null, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.SessionBeanO.getMessageContext", (String)"372", (Object)this);
        }
        catch (IllegalAccessException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.SessionBeanO.getMessageContext", (String)"378", (Object)this);
        }
        catch (InvocationTargetException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.SessionBeanO.getMessageContext", (String)"384", (Object)this);
        }
        return theMessageContext;
    }

    public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException {
        Object result = null;
        if (this.state == 1 || this.state == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getBusinessObject: Incorrect state: " + this.getStateName(this.state)), (Object[])new Object[0]);
            }
            throw new IllegalStateException(this.getStateName(this.state));
        }
        if (businessInterface == null) {
            throw new IllegalStateException("Requested business interface not found : null");
        }
        try {
            EJSWrapperCommon common = this.container.wrapperManager.getWrapper(this.beanId);
            result = common.getBusinessObject(businessInterface.getName());
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.SessionBeanO.getBusinessObject", (String)"516", (Object)this);
            EJBException ejbex = ExceptionUtil.EJBException("getBusinessObject() failed", ex);
            Tr.error((TraceComponent)tc, (String)"CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", (Object[])new Object[]{ex, ejbex.toString()});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getBusinessObject() failed", (Object[])new Object[]{ex});
            }
            throw ejbex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getBusinessObject : " + result.getClass().getName()), (Object[])new Object[0]);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getInvokedBusinessInterface() throws IllegalStateException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        SessionBeanO sessionBeanO = this;
        synchronized (sessionBeanO) {
            if (this.state == 1 || this.state == 2 || this.state == 0) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Incorrect state: " + this.getStateName(this.state)), (Object[])new Object[0]);
                }
                throw new IllegalStateException(this.getStateName(this.state));
            }
        }
        Class<?> bInterface = null;
        EJSWrapperBase wrapper = null;
        EJSDeployedSupport methodContext = EJSContainer.getMethodContext();
        if (methodContext != null && (wrapper = methodContext.ivWrapper) != null) {
            if (wrapper.ivBusinessInterfaceIndex == -2) {
                Method method = methodContext.methodInfo.ivMethod;
                String methodName = method.getName();
                Class<?>[] methodParams = method.getParameterTypes();
                for (Class<?> curInterface : wrapper.bmd.ivBusinessLocalInterfaceClasses) {
                    try {
                        curInterface.getMethod(methodName, methodParams);
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Method " + methodName + " found on interface " + curInterface), (Object[])new Object[0]);
                        }
                        if (bInterface != null) {
                            throw new IllegalStateException("Ambiguous invoked business interface.");
                        }
                        bInterface = curInterface;
                    }
                    catch (SecurityException ex) {
                        if (!isTraceOn || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Method " + methodName + " not found on interface " + curInterface), (Object[])new Object[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        if (!isTraceOn || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Method " + methodName + " not found on interface " + curInterface), (Object[])new Object[0]);
                    }
                }
            } else if (wrapper.ivInterface == WrapperInterface.BUSINESS_LOCAL) {
                bInterface = wrapper.bmd.ivBusinessLocalInterfaceClasses[wrapper.ivBusinessInterfaceIndex];
            } else if (wrapper.ivInterface == WrapperInterface.BUSINESS_REMOTE || wrapper.ivInterface == WrapperInterface.BUSINESS_RMI_REMOTE) {
                bInterface = wrapper.bmd.ivBusinessRemoteInterfaceClasses[wrapper.ivBusinessInterfaceIndex];
            }
        }
        if (bInterface == null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getInvokedBusinessInterface : IllegalStateException : Not invoked through business interface", (Object[])new Object[0]);
            }
            throw new IllegalStateException("Not invoked through business interface");
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getInvokedBusinessInterface : " + bInterface), (Object[])new Object[0]);
        }
        return bInterface;
    }

    public boolean wasCancelCalled() {
        ServerAsyncResult asyncResult;
        EJSDeployedSupport methodContext = EJSContainer.getMethodContext();
        ServerAsyncResult serverAsyncResult = asyncResult = methodContext == null ? null : methodContext.ivAsyncResult;
        if (asyncResult == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"wasCancelCalled : IllegalStateException : Not invoked from an asynchronous method with results", (Object[])new Object[0]);
            }
            throw new IllegalStateException("Not invoked from an asynchronous method with results");
        }
        boolean result = asyncResult.wasCancelCalled();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("wasCancelCalled : " + result), (Object[])new Object[0]);
        }
        return result;
    }

    @Override
    public int getIsolationLevel() {
        return this.currentIsolationLevel;
    }

    @Override
    public boolean isDestroyed() {
        return this.state == 0;
    }

    @Override
    public void ensurePersistentState(ContainerTx tx) throws RemoteException {
    }

    @Override
    public int getModuleVersion() {
        return this.home.beanMetaData.ivModuleVersion;
    }
}

