/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.context.ExceptionHandlerFactory;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.ExternalContextFactory;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextFactory;
import jakarta.faces.context.PartialViewContextFactory;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.render.RenderKitFactory;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.context.ReleasableFacesContextFactory;
import org.apache.myfaces.context.servlet.FacesContextImpl;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.util.lang.ClassUtils;

public class FacesContextFactoryImpl
extends FacesContextFactory
implements ReleasableFacesContextFactory {
    private static final Logger log = Logger.getLogger(FacesContextFactoryImpl.class.getName());
    private final ExternalContextFactory _externalContextFactory;
    private final ExceptionHandlerFactory _exceptionHandlerFactory;
    private final ApplicationFactory _applicationFactory;
    private final RenderKitFactory _renderKitFactory;
    private final PartialViewContextFactory _partialViewContextFactory;
    private final ThreadLocal<ExternalContext> _firstExternalContextInstance;

    public FacesContextFactoryImpl() {
        ThreadLocal firstExternalContextInstance;
        block5: {
            firstExternalContextInstance = null;
            try {
                Class clazz = ClassUtils.classForName("jakarta.faces.context._MyFacesExternalContextHelper");
                Field externalContextFirstInstance = clazz.getDeclaredField("firstInstance");
                externalContextFirstInstance.setAccessible(true);
                if (firstExternalContextInstance == null) {
                    firstExternalContextInstance = (ThreadLocal)externalContextFirstInstance.get(null);
                }
            }
            catch (SecurityException e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Cannot access field firstInstance from _MyFacesExternalContextHelper ", e);
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.SEVERE)) break block5;
                log.log(Level.SEVERE, "Cannot find field firstInstance from _MyFacesExternalContextHelper ", e);
            }
        }
        this._firstExternalContextInstance = firstExternalContextInstance;
        this._externalContextFactory = (ExternalContextFactory)FactoryFinder.getFactory((String)"jakarta.faces.context.ExternalContextFactory");
        this._exceptionHandlerFactory = (ExceptionHandlerFactory)FactoryFinder.getFactory((String)"jakarta.faces.context.ExceptionHandlerFactory");
        this._applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"jakarta.faces.application.ApplicationFactory");
        this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
        this._partialViewContextFactory = (PartialViewContextFactory)FactoryFinder.getFactory((String)"jakarta.faces.context.PartialViewContextFactory");
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        Assert.notNull(context, "context");
        Assert.notNull(request, "request");
        Assert.notNull(response, "response");
        Assert.notNull(lifecycle, "lifecycle");
        ExternalContext externalContext = this._externalContextFactory.getExternalContext(context, request, response);
        ExternalContext defaultExternalContext = null;
        if (this._firstExternalContextInstance != null && (defaultExternalContext = (ExternalContext)externalContext.getRequestMap().remove("org.apache.myfaces.context.servlet.ServletExternalContextImpl")) != null) {
            this._firstExternalContextInstance.set(defaultExternalContext);
        }
        FacesContextImpl facesContext = new FacesContextImpl(externalContext, defaultExternalContext, this, this._applicationFactory, this._renderKitFactory, this._partialViewContextFactory, lifecycle);
        facesContext.setExceptionHandler(this._exceptionHandlerFactory.getExceptionHandler());
        return facesContext;
    }

    @Override
    public void release() {
        if (this._firstExternalContextInstance != null) {
            this._firstExternalContextInstance.remove();
        }
    }
}

