/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc.v41;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.ConnectionSharing;
import com.ibm.ws.rsadapter.impl.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class WSJdbc41Connection
extends WSJdbcConnection
implements Connection {
    private static final TraceComponent tc = Tr.register(WSJdbc41Connection.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final AtomicBoolean warnedAboutSchemaMatching = new AtomicBoolean();
    private static final AtomicBoolean warnedAboutNetworkTimeoutMatching = new AtomicBoolean();
    private boolean aborted = false;

    public WSJdbc41Connection(WSRdbManagedConnectionImpl mc, Connection conn, Object key, Object currentThreadID) {
        super(mc, conn, key, currentThreadID);
    }

    @Override
    public String getSchema() throws SQLException {
        this.activate();
        try {
            return this.managedConn.getSchema();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc41Connection.getSchema", (String)"62", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (warnedAboutSchemaMatching.compareAndSet(false, true)) {
            Tr.info((TraceComponent)tc, (String)"DEFAULT_MATCH_ORIGINAL", (Object[])new Object[]{"Schema", "connectionSharing"});
        }
        this.activate();
        try {
            if (this.managedConn.getHandleCount() > 1 && !AdapterUtil.match((Object)schema, (Object)this.managedConn.getCurrentSchema())) {
                throw this.createSharingException("setSchema");
            }
            this.managedConn.setSchema(schema);
            if (this.managedConn.connectionSharing == ConnectionSharing.MatchCurrentState) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon((WSConnectionRequestInfoImpl)cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setSchema(schema);
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc41Connection.setSchema", (String)"96", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.activate();
        try {
            return this.managedConn.getNetworkTimeout();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc41Connection.getSchema", (String)"111", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (warnedAboutNetworkTimeoutMatching.compareAndSet(false, true)) {
            Tr.info((TraceComponent)tc, (String)"DEFAULT_MATCH_ORIGINAL", (Object[])new Object[]{"NetworkTimeout", "connectionSharing"});
        }
        this.activate();
        try {
            if (this.managedConn.getHandleCount() > 1 && milliseconds != this.managedConn.getCurrentNetworkTimeout()) {
                throw this.createSharingException("setNetworkTimeout");
            }
            this.managedConn.setNetworkTimeout(executor, milliseconds);
            if (this.managedConn.connectionSharing == ConnectionSharing.MatchCurrentState) {
                WSConnectionRequestInfoImpl cri = (WSConnectionRequestInfoImpl)this.managedConn.getConnectionRequestInfo();
                if (!cri.isCRIChangable()) {
                    cri = WSConnectionRequestInfoImpl.createChangableCRIFromNon((WSConnectionRequestInfoImpl)cri);
                    this.managedConn.setCRI(cri);
                }
                cri.setNetworkTimeout(milliseconds);
            }
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbc41Connection.setNetworkTimeout", (String)"145", (Object)this);
            throw this.proccessSQLException(ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (!this.isClosed()) {
            try {
                this.connImpl.abort(executor);
            }
            catch (IncompatibleClassChangeError e) {
                throw new SQLFeatureNotSupportedException();
            }
            this.setAborted(true);
            this.managedConn.setAborted(true);
            this.fireConnectionErrorEvent(null, false);
        }
    }

    public boolean isAborted() throws SQLFeatureNotSupportedException {
        return this.aborted;
    }

    public void setAborted(boolean aborted) throws SQLFeatureNotSupportedException {
        this.aborted = aborted;
    }

    protected SQLException proccessSQLException(SQLException ex) {
        block5: {
            if (this.managedConn != null && this.managedConn.currentNetworkTimeout != 0) {
                try {
                    if (!this.isClosed() && this.connImpl != null && this.connImpl.isClosed()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Network timeout detected, closing wrapper objects.", (Object[])new Object[0]);
                        }
                        this.close(true);
                    }
                }
                catch (SQLException e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)"Exception ocurred while processing SQLException: ", (Object[])new Object[]{e});
                }
            }
        }
        return super.proccessSQLException(ex);
    }
}

