/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.InvalidAddOperation;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemCollection;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.SibTr;

public class ItemStream
extends AbstractItem {
    private static TraceComponent tc = SibTr.register(ItemStream.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");

    public void addItem(Item item, long lockID, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException, SevereMessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addItem");
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItem");
            }
            throw new InvalidAddOperation("STREAM_NOT_STORED_SIMS0004", new Object[]{item, this});
        }
        if (null != item._getMembership()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItem");
            }
            throw new InvalidAddOperation("STREAM_ADD_CONFLICT_SIMS0005", new Object[]{item, this});
        }
        ic.addItem(item, lockID, transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItem");
        }
    }

    public void addItem(Item item, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException, SevereMessageStoreException {
        long lockId = -2L;
        if (item.getDeliveryDelay() > 0L) {
            lockId = -56789L;
        }
        this.addItem(item, lockId, transaction);
    }

    public void addItemStream(ItemStream itemStream, long lockID, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException, SevereMessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addItemStream");
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItemStream");
            }
            throw new InvalidAddOperation("STREAM_NOT_STORED_SIMS0004", new Object[]{itemStream, this});
        }
        if (null != itemStream._getMembership()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItemStream");
            }
            throw new InvalidAddOperation("STREAM_ADD_CONFLICT_SIMS0005", new Object[]{itemStream, this});
        }
        ic.addItemStream(itemStream, lockID, transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItemStream");
        }
    }

    public void addItemStream(ItemStream itemStream, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException, SevereMessageStoreException {
        this.addItemStream(itemStream, -2L, transaction);
    }

    public void addReferenceStream(ReferenceStream referenceStream, long lockID, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException, SevereMessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addReferenceStream");
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addReferenceStream");
            }
            throw new InvalidAddOperation("STREAM_NOT_STORED_SIMS0004", new Object[]{referenceStream, this});
        }
        if (null != referenceStream._getMembership()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addReferenceStream");
            }
            throw new InvalidAddOperation("STREAM_ADD_CONFLICT_SIMS0005", new Object[]{referenceStream, this});
        }
        ic.addReferenceStream(referenceStream, lockID, transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addReferenceStream");
        }
    }

    public void addReferenceStream(ReferenceStream referenceStream, Transaction transaction) throws ProtocolException, OutOfCacheSpace, StreamIsFull, TransactionException, PersistenceException, SevereMessageStoreException {
        this.addReferenceStream(referenceStream, -2L, transaction);
    }

    public void eventWatermarkBreached() {
    }

    public final Item findFirstMatchingItem(Filter filter) throws MessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItem", (Object)filter);
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItem");
            }
            throw new NotInMessageStore();
        }
        Item item = null;
        if (ic != null) {
            item = (Item)ic.findFirstMatchingItem(filter);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItem", (Object)item);
        }
        return item;
    }

    public final ItemStream findFirstMatchingItemStream(Filter filter) throws MessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream", (Object)filter);
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream");
            }
            throw new NotInMessageStore();
        }
        ItemStream is = null;
        if (ic != null) {
            is = ic.findFirstMatchingItemStream(filter);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingItemStream", (Object)is);
        }
        return is;
    }

    public final ReferenceStream findFirstMatchingReferenceStream(Filter filter) throws MessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatchingReferenceStream", (Object)filter);
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingReferenceStream");
            }
            throw new NotInMessageStore();
        }
        ReferenceStream rs = null;
        if (ic != null) {
            rs = ic.findFirstMatchingReferenceStream(filter);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatchingReferenceStream", (Object)rs);
        }
        return rs;
    }

    public final AbstractItem findById(long itemId) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findById", (Object)itemId);
        }
        AbstractItem item = null;
        ItemCollection ic = (ItemCollection)this._getMembership();
        if (null == ic) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"findById");
            }
            throw new NotInMessageStore();
        }
        item = ic.findById(itemId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findById", (Object)item);
        }
        return item;
    }

    public final Item findOldestItem() throws MessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findOldestItem");
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"findOldestItem");
            }
            throw new NotInMessageStore();
        }
        Item item = null;
        if (ic != null) {
            item = (Item)ic.findOldestItem();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findOldestItem", (Object)item);
        }
        return item;
    }

    public long getByteHighWaterMark() {
        return -1L;
    }

    public long getByteLowWaterMark() {
        return -1L;
    }

    public long getCountHighWaterMark() {
        return -1L;
    }

    public long getCountLowWaterMark() {
        return -1L;
    }

    public final ItemStream getItemStream() throws SevereMessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getItemStream");
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getItemStream");
            }
            throw new NotInMessageStore();
        }
        ItemStream itemStream = null;
        if (null != ic) {
            itemStream = ic.getOwningItemStream();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getItemStream", (Object)itemStream);
        }
        return itemStream;
    }

    @Override
    public long getMaximumTimeInStore() {
        return -2L;
    }

    public final Statistics getStatistics() throws SevereMessageStoreException {
        if (null == (ItemCollection)this._getMembership()) {
            throw new NotInMessageStore();
        }
        ItemCollection ic = (ItemCollection)this._getMembership();
        if (null == ic) {
            throw new NotInMessageStore();
        }
        return ic.getStatistics();
    }

    @Override
    public final boolean isCollection() {
        return true;
    }

    @Override
    public final boolean isItemStream() {
        return true;
    }

    public final boolean isSpilling() throws NotInMessageStore {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isSpilling");
        }
        boolean spilling = false;
        ItemCollection ic = (ItemCollection)this._getMembership();
        if (null == ic) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"isSpilling");
            }
            throw new NotInMessageStore();
        }
        if (null != ic) {
            spilling = ic.isSpilling();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isSpilling", (Object)spilling);
        }
        return spilling;
    }

    public final LockingCursor newLockingItemCursor(Filter filter) throws MessageStoreException {
        return this.newLockingItemCursor(filter, true);
    }

    public final LockingCursor newLockingItemCursor(Filter filter, boolean jumpbackEnabled) throws MessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newLockingItemCursor", (Object)new Object[]{filter, jumpbackEnabled});
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"newLockingItemCursor");
            }
            throw new NotInMessageStore();
        }
        LockingCursor cursor = null;
        if (ic != null) {
            cursor = ic.newLockingItemCursor(filter, jumpbackEnabled);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newLockingItemCursor", (Object)cursor);
        }
        return cursor;
    }

    public final NonLockingCursor newNonLockingItemCursor(Filter filter) throws MessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingItemCursor");
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingItemCursor");
            }
            throw new NotInMessageStore();
        }
        NonLockingCursor cursor = null;
        if (ic != null) {
            cursor = ic.newNonLockingItemCursor(filter);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingItemCursor", (Object)cursor);
        }
        return cursor;
    }

    public final NonLockingCursor newNonLockingItemStreamCursor(Filter filter) throws MessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingItemStreamCursor");
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingItemStreamCursor");
            }
            throw new NotInMessageStore();
        }
        NonLockingCursor cursor = null;
        if (ic != null) {
            cursor = ic.newNonLockingItemStreamCursor(filter);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingItemStreamCursor", (Object)cursor);
        }
        return cursor;
    }

    public final NonLockingCursor newNonLockingReferenceStreamCursor(Filter filter) throws MessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingReferenceStreamCursor");
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingReferenceStreamCursor");
            }
            throw new NotInMessageStore();
        }
        NonLockingCursor cursor = null;
        if (ic != null) {
            cursor = ic.newNonLockingReferenceStreamCursor(filter);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingReferenceStreamCursor", (Object)cursor);
        }
        return cursor;
    }

    public final Item removeFirstMatchingItem(Filter filter, Transaction transaction) throws MessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItem", (Object)new Object[]{filter, transaction});
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItem");
            }
            throw new NotInMessageStore();
        }
        Item item = null;
        if (ic != null) {
            item = (Item)ic.removeFirstMatchingItem(filter, transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItem", (Object)item);
        }
        return item;
    }

    public final ItemStream removeFirstMatchingItemStream(Filter filter, Transaction transaction) throws MessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream", (Object)new Object[]{filter, transaction});
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream");
            }
            throw new NotInMessageStore();
        }
        ItemStream is = null;
        if (ic != null) {
            is = ic.removeFirstMatchingItemStream(filter, transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingItemStream", (Object)is);
        }
        return is;
    }

    public final ReferenceStream removeFirstMatchingReferenceStream(Filter filter, Transaction transaction) throws MessageStoreException {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingReferenceStream", (Object)new Object[]{filter, transaction});
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingReferenceStream");
            }
            throw new NotInMessageStore();
        }
        ReferenceStream rs = null;
        if (ic != null) {
            rs = ic.removeFirstMatchingReferenceStream(filter, transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatchingReferenceStream", (Object)rs);
        }
        return rs;
    }

    public final void setWatermarks(long countLow, long countHigh, long bytesLow, long bytesHigh) throws NotInMessageStore {
        ItemCollection ic;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setWatermarks", (Object)new Object[]{countLow, countHigh, bytesLow, bytesHigh});
        }
        if (null == (ic = (ItemCollection)this._getMembership())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setWatermarks");
            }
            throw new NotInMessageStore();
        }
        ic.setWatermarks(countLow, countHigh, bytesLow, bytesHigh);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setWatermarks");
        }
    }
}

