/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.jmf.JMFList;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSDynamic;
import com.ibm.ws.sib.mfp.jmf.impl.JSEnum;
import com.ibm.ws.sib.mfp.jmf.impl.JSField;
import com.ibm.ws.sib.mfp.jmf.impl.JSListCoder;
import com.ibm.ws.sib.mfp.jmf.impl.JSMessageData;
import com.ibm.ws.sib.mfp.jmf.impl.JSPrimitive;
import com.ibm.ws.sib.mfp.jmf.impl.JSVariant;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.mfp.util.LiteIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class JSListImpl
extends JSMessageData
implements JMFList {
    private static TraceComponent tc = JmfTr.register(JSListImpl.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");
    int offset;
    int length;
    JSField element;

    public JSListImpl(JSField element, int indirect, Object values, boolean boxed) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
        super(JSListImpl.getSize(values));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "<init>", new Object[]{element, indirect, values, boxed});
        }
        this.element = element;
        this.indirect = indirect;
        if (!boxed && this.cacheSize > 0) {
            this.cache = new Object[this.cacheSize];
            Iterator iter = JSListImpl.getIterator(values);
            int i = 0;
            while (iter.hasNext()) {
                Object val = iter.next();
                if (val == MISSING) continue;
                this.setValue(i++, val);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "<init>");
        }
    }

    public JSListImpl(byte[] contents, int offset, JSField element, int indirect) throws JMFMessageCorruptionException {
        super(ArrayUtil.readInt(contents, offset + 4));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "<init>", new Object[]{contents, offset, element, indirect});
        }
        this.contents = contents;
        this.offset = offset + 8;
        this.element = element;
        this.indirect = indirect;
        this.length = ArrayUtil.readInt(contents, offset);
        JSListCoder.evaluateMessageLength(this.length, contents, offset);
        this.length -= 4;
        if (this.cacheSize > this.length) {
            JMFMessageCorruptionException jmce = new JMFMessageCorruptionException("List size " + this.cacheSize + " at offset " + offset + " greater than length " + this.length);
            FFDCFilter.processException((Throwable)jmce, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSListImpl.<init>", (String)"149", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, contents, 0, contents.length});
            throw jmce;
        }
        if (this.cacheSize > 0) {
            this.cache = new Object[this.cacheSize];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "<init>");
        }
    }

    JSListImpl(JSListImpl original) {
        super(original.cacheSize);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "<init>", original);
        }
        this.offset = original.offset;
        this.length = original.length;
        this.element = original.element;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "<init>");
        }
    }

    @Override
    JSField getFieldDef(int index, boolean mustBePresent) {
        return this.element;
    }

    @Override
    boolean assembledForField(int index) {
        return this.contents != null;
    }

    public void checkType(JSField elem, int indir) throws JMFSchemaViolationException {
        if (!this.equivFields(this.element, elem) || indir != this.indirect) {
            throw new JMFSchemaViolationException("Incorrect list element types");
        }
    }

    private boolean equivFields(JSField one, JSField two) {
        if (one instanceof JSDynamic) {
            return two instanceof JSDynamic;
        }
        if (one instanceof JSEnum) {
            return two instanceof JSEnum;
        }
        if (one instanceof JSPrimitive) {
            return two instanceof JSPrimitive && ((JSPrimitive)one).getTypeCode() == ((JSPrimitive)two).getTypeCode();
        }
        if (one instanceof JSVariant) {
            return two instanceof JSVariant && ((JSVariant)one).getBoxed().getID() == ((JSVariant)two).getBoxed().getID();
        }
        return false;
    }

    @Override
    public Object get(int index) {
        try {
            return this.getValue(index);
        }
        catch (JMFUninitializedAccessException jMFUninitializedAccessException) {
        }
        catch (JMFException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSListImpl.get", (String)"215", (Object)this);
        }
        return null;
    }

    @Override
    public int size() {
        return this.cacheSize;
    }

    @Override
    public Object set(int index, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "set", new Object[]{index, value});
        }
        try {
            this.checkIndex(index);
            Object ans = this.getInternal(index);
            if (ans == nullIndicator) {
                ans = null;
            }
            this.setValue(index, value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "set", value);
            }
            return ans;
        }
        catch (JMFException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSListImpl.set", (String)"245", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "set", null);
            }
            return null;
        }
    }

    @Override
    public int getEncodedLength() throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (this.contents == null) {
            this.length = this.computeLengthFromCache();
        }
        return this.length + 8;
    }

    @Override
    int reallocate(int fieldOffset) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "reallocate", new Object[]{this.offset});
        }
        byte[] oldContents = this.contents;
        int oldOffset = this.offset;
        this.contents = new byte[this.length];
        System.arraycopy(oldContents, this.offset, this.contents, 0, this.length);
        this.offset = 0;
        int result = fieldOffset - oldOffset;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "reallocate", result);
        }
        return result;
    }

    @Override
    void reallocated(byte[] newContents, int newOffset) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "reallocated", new Object[]{newContents, newOffset});
        }
        if (this.contents != null) {
            this.contents = newContents;
            this.offset = newOffset + 8;
            this.sharedContents = false;
            if (this.cache != null) {
                for (int i = 0; i < this.cache.length; ++i) {
                    try {
                        Object entry = this.cache[i];
                        if (entry == null || !(entry instanceof JSMessageData)) continue;
                        ((JSMessageData)entry).reallocated(newContents, this.getAbsoluteOffset(i));
                        continue;
                    }
                    catch (JMFUninitializedAccessException jMFUninitializedAccessException) {
                        // empty catch block
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "reallocated");
        }
    }

    abstract int computeLengthFromCache() throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException;

    abstract int encodeOffsetTable(byte[] var1, int var2) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException;

    public int encode(byte[] frame, int offset) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.entry(this, tc, "encode", new Object[]{frame, offset});
        }
        ArrayUtil.writeInt(frame, offset, this.length + 4);
        ArrayUtil.writeInt(frame, offset + 4, this.cacheSize);
        if (this.contents != null) {
            System.arraycopy(this.contents, this.offset, frame, offset + 8, this.length);
            int result = offset + 8 + this.length;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                JmfTr.exit(this, tc, "encode", result);
            }
            return result;
        }
        int next = offset + 8;
        next = this.encodeOffsetTable(frame, next);
        for (int i = 0; i < this.cacheSize; ++i) {
            Object elem = this.cache[i];
            if (elem == null) {
                throw new JMFUninitializedAccessException("List element " + i + "is missing");
            }
            if (elem == nullIndicator) {
                elem = null;
            }
            next = this.element.encodeValue(frame, next, elem, this.indirect, this.primaryMessage);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            JmfTr.exit(this, tc, "encode", next);
        }
        return next;
    }

    static int getSize(Object agg) throws JMFSchemaViolationException {
        if (agg == null) {
            return 0;
        }
        if (agg instanceof Collection) {
            return ((Collection)agg).size();
        }
        if (agg.getClass().isArray()) {
            return Array.getLength(agg);
        }
        throw new JMFSchemaViolationException(agg.getClass().getName());
    }

    static Iterator getIterator(Object agg) throws JMFSchemaViolationException {
        if (agg instanceof Collection) {
            return ((Collection)agg).iterator();
        }
        if (agg.getClass().isArray()) {
            return new LiteIterator(agg);
        }
        throw new JMFSchemaViolationException(agg.getClass().getName());
    }
}

