/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFNativePart;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.impl.JSBoxedListImpl;
import com.ibm.ws.sib.mfp.jmf.impl.JSVaryingList;

class JSBoxManager {
    private JMFNativePart part;
    private int[][] boxed;
    private JSBoxedListImpl[] boxedCache;

    JSBoxManager(JMFNativePart part, int[][] boxed) {
        this.part = part;
        this.boxed = boxed;
        this.reset();
    }

    void reset() {
        this.boxedCache = new JSBoxedListImpl[this.boxed.length];
    }

    void cleanupBoxedCache(int boxedAccessor) {
        for (int i = 0; i < this.boxedCache.length; ++i) {
            if (this.boxed[i][0] != boxedAccessor) continue;
            this.boxedCache[i] = null;
        }
    }

    int getBoxAccessor(int boxedIndex) {
        return this.boxed[boxedIndex][0];
    }

    Object getBoxedlValue(int accessor) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException, JMFUninitializedAccessException {
        JSBoxedListImpl ans = this.boxedCache[accessor];
        if (ans != null) {
            return ans;
        }
        JSVaryingList subAns = (JSVaryingList)this.part.getValue(this.boxed[accessor][0]);
        this.boxedCache[accessor] = ans = JSBoxedListImpl.create(subAns, this.boxed[accessor][1]);
        return ans;
    }

    void setBoxedValue(int accessor, Object val) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException, JMFUninitializedAccessException {
        if (val == this.boxedCache[accessor]) {
            return;
        }
        int boxAccessor = this.boxed[accessor][0];
        JSVaryingList subAns = this.part.isPresent(boxAccessor) ? (JSVaryingList)this.part.getValue(boxAccessor) : (JSVaryingList)this.part.createBoxList(boxAccessor, val);
        this.boxedCache[accessor] = JSBoxedListImpl.create(subAns, this.boxed[accessor][1], val);
    }
}

