/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.impl.SchemaStoreItem;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.Map;

public class SchemaStoreItemStream
extends ItemStream {
    private static TraceComponent tc = SibTr.register(SchemaStoreItemStream.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    Map<Long, Long> schemaIndex = new HashMap<Long, Long>();

    @Override
    public int getStorageStrategy() {
        return 4;
    }

    @Override
    public void eventRestored() throws SevereMessageStoreException {
        super.eventRestored();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventRestored");
        }
        try {
            NonLockingCursor cursor = this.newNonLockingItemCursor(null);
            AbstractItem item = cursor.next();
            while (item != null) {
                if (item instanceof SchemaStoreItem) {
                    this.addToIndex((SchemaStoreItem)item);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("JSchema found in store: " + ((SchemaStoreItem)item).getSchema().getID()));
                    }
                }
                item = cursor.next();
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)((Object)e), (String)"eventRestored", (String)"108", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventRestored");
        }
    }

    @Override
    public void addItem(Item item, Transaction tran) throws OutOfCacheSpace, StreamIsFull, ProtocolException, TransactionException, PersistenceException, SevereMessageStoreException {
        super.addItem(item, tran);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addItem");
        }
        if (item instanceof SchemaStoreItem) {
            this.addToIndex((SchemaStoreItem)item);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("JSchema added to store: " + ((SchemaStoreItem)item).getSchema().getID()));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addItem");
        }
    }

    boolean containsSchema(Long id) {
        return this.schemaIndex.containsKey(id);
    }

    void addSchema(JMFSchema schema, Transaction tran) throws MessageStoreException {
        this.addItem(new SchemaStoreItem(schema), tran);
    }

    JMFSchema findSchema(long schemaId) throws MessageStoreException {
        Long storeId = this.schemaIndex.get(schemaId);
        if (storeId != null) {
            AbstractItem item = this.findById(storeId);
            return ((SchemaStoreItem)item).getSchema();
        }
        throw new MessageStoreException("Schema not found in store: " + schemaId);
    }

    void addToIndex(SchemaStoreItem item) throws NotInMessageStore {
        this.schemaIndex.put(item.getSchema().getLongID(), item.getID());
        item.setStream(this);
    }

    void removeFromIndex(SchemaStoreItem item) {
        this.schemaIndex.remove(item.getSchema().getLongID());
        item.setStream(null);
    }
}

