/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.impl.JsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaIdException;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.List;

abstract class MessageImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static TraceComponent tc = SibTr.register(MessageImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    transient JsMsgObject jmo;

    MessageImpl() {
    }

    void setJmo(JsMsgObject jmo) {
        this.jmo = jmo;
        jmo.setMessage(this);
    }

    final String debugMsg() {
        return this.jmo.debugMsg();
    }

    public final String toVerboseString() {
        this.updateDataFields(7);
        return this.debugMsg();
    }

    void updateDataFields(int why) {
    }

    void clearPartCaches() {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeObject");
        }
        out.defaultWriteObject();
        try {
            List<DataSlice> buffers = this.jmo.encodeFast(null);
            JMFSchema[] schemas = this.jmo.getEncodingSchemas();
            out.writeInt(schemas.length);
            for (int i = 0; i < schemas.length; ++i) {
                out.writeObject(schemas[i].toByteArray());
            }
            out.writeObject(buffers);
        }
        catch (MessageEncodeFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.MessageImpl.writeObject", (String)"msg100", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("serialization failed: " + e));
            }
            NotSerializableException newE = new NotSerializableException();
            newE.initCause(e);
            throw newE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeObject");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readObject");
        }
        in.defaultReadObject();
        try {
            int schemaCount = in.readInt();
            for (int i = 0; i < schemaCount; ++i) {
                byte[] schemaDef = (byte[])in.readObject();
                JMFSchema schema = JMFRegistry.instance.createJMFSchema(schemaDef);
                JMFRegistry.instance.register(schema);
            }
            List buffers = (List)in.readObject();
            JsMsgObject newJmo = new JsMsgObject(null, null, buffers);
            this.setJmo(newJmo);
            if (this instanceof JsMessageImpl) {
                ((JsMessageImpl)this).setApproximateLength(newJmo.getOriginalLength());
                ((JsMessageImpl)this).setFluffedSize(-1);
            }
        }
        catch (MessageDecodeFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.MessageImpl.readObject", (String)"msg200", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("deserialization failed: " + e));
            }
            StreamCorruptedException newE = new StreamCorruptedException();
            newE.initCause(e);
            throw newE;
        }
        catch (JMFSchemaIdException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.MessageImpl.readObject", (String)"msg201", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("deserialization failed: " + e));
            }
            InvalidObjectException newE = new InvalidObjectException(e.getMessage());
            newE.initCause(e);
            throw newE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readObject");
        }
    }
}

