/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.ProducerType;
import com.ibm.ws.sib.mfp.impl.JsMsgPart;
import com.ibm.ws.sib.mfp.impl.MessageImpl;
import com.ibm.ws.sib.mfp.impl.MfpDiagnostics;
import com.ibm.ws.sib.mfp.impl.MfpThreadDataImpl;
import com.ibm.ws.sib.mfp.impl.SchemaManager;
import com.ibm.ws.sib.mfp.impl.SchemaStore;
import com.ibm.ws.sib.mfp.jmf.JMFEncapsulation;
import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.jmf.JMFMessage;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFNativePart;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.impl.JSRegistry;
import com.ibm.ws.sib.mfp.jmf.tools.JSFormatter;
import com.ibm.ws.sib.mfp.schema.JsApiAccess;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.mfp.util.HexUtil;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.util.ArrayList;
import java.util.List;

class JsMsgObject {
    private static TraceComponent tc = SibTr.register(JsMsgObject.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final int IDS_LENGTH = 20;
    private static final int PROLOGUE_LENGTH = 24;
    protected MessageImpl theMessage;
    protected int originalLength;
    private JsMsgPart headerPart;
    private JsMsgPart payloadPart = null;

    JsMsgObject(JMFSchema schema) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JsMsgObject", (Object)schema);
        }
        this.initialize(null, 0, schema, null, 0, 0, null, null, 0, 0, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JsMsgObject");
        }
    }

    JsMsgObject(JMFSchema headerSchema, JMFSchema payloadSchema) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JsMsgObject", (Object)new Object[]{headerSchema, payloadSchema});
        }
        this.initialize(null, 0, headerSchema, null, 0, 0, payloadSchema, null, 0, 0, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JsMsgObject");
        }
    }

    JsMsgObject(JMFSchema schema, byte[] rawMessage, int offset, int length) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JsMsgObject", (Object)new Object[]{schema, rawMessage, offset, length});
        }
        this.initialize(null, 0, schema, rawMessage, offset, length, null, null, 0, 0, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JsMsgObject");
        }
    }

    JsMsgObject(JMFSchema headerSchema, JMFSchema payloadSchema, byte[] rawMessage, int offset, int length) throws MessageDecodeFailedException {
        this(headerSchema, payloadSchema, rawMessage, offset, length, null);
    }

    JsMsgObject(JMFSchema headerSchema, JMFSchema payloadSchema, byte[] rawMessage, int offset, int length, CommsConnection conn) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JsMsgObject", (Object)new Object[]{headerSchema, payloadSchema, rawMessage, offset, length, conn});
        }
        if (rawMessage.length - offset < length || length < 24) {
            String msg = "Invalid message buffer (buffer size=" + rawMessage.length + " offset=" + offset + " length=" + length + "). ";
            msg = rawMessage.length - offset < length ? msg + "Size-offset too small for requested length." : msg + "Length is less than preamble";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)msg);
            }
            throw new MessageDecodeFailedException(msg);
        }
        int hdrLength = 24 + ArrayUtil.readInt(rawMessage, offset + 20);
        if (hdrLength < length) {
            this.initialize(null, 0, headerSchema, rawMessage, offset, hdrLength, payloadSchema, rawMessage, offset + hdrLength, length - hdrLength, conn);
        } else if (payloadSchema == null) {
            this.initialize(null, 0, headerSchema, rawMessage, offset, hdrLength, null, null, 0, 0, conn);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"decode failed: encoded payload missing");
            }
            MessageDecodeFailedException e = new MessageDecodeFailedException();
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.<init>", (String)"jmo350", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, rawMessage, offset, length});
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JsMsgObject");
        }
    }

    JsMsgObject(JMFSchema headerSchema, JMFSchema payloadSchema, List<DataSlice> slices, CommsConnection conn) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JsMsgObject", (Object)new Object[]{headerSchema, payloadSchema, slices, conn});
        }
        if (slices == null || slices.size() < 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception: DataSlice list was null or empty");
            }
            MessageDecodeFailedException e = new MessageDecodeFailedException("A null or empty DataSlice List was passed to the message decode");
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.<init>", (String)"jmo360", (Object)this);
            throw e;
        }
        if (slices.size() < 3) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception: Too few DataSlices for inbound message");
            }
            MessageDecodeFailedException e = new MessageDecodeFailedException("Too few DataSlices for inbound message");
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initialize", (String)"jmo365", (Object)this, (Object[])new Object[]{MfpConstants.DM_SLICES, slices});
            throw e;
        }
        DataSlice prologueSlice = slices.get(0);
        DataSlice headerSlice = slices.get(1);
        DataSlice payloadSlice = slices.get(2);
        this.initialize(prologueSlice.getBytes(), prologueSlice.getOffset(), headerSchema, headerSlice.getBytes(), headerSlice.getOffset(), headerSlice.getLength(), payloadSchema, payloadSlice.getBytes(), payloadSlice.getOffset(), payloadSlice.getLength(), conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JsMsgObject");
        }
    }

    JsMsgObject(JMFSchema headerSchema, JMFSchema payloadSchema, List<?> buffers) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JsMsgObject", (Object)new Object[]{headerSchema, payloadSchema, buffers});
        }
        if (buffers.get(0) instanceof DataSlice) {
            DataSlice prologueSlice = (DataSlice)buffers.get(0);
            DataSlice headerSlice = (DataSlice)buffers.get(1);
            if (buffers.size() > 2) {
                DataSlice payloadSlice = (DataSlice)buffers.get(2);
                this.initialize(prologueSlice.getBytes(), prologueSlice.getOffset(), headerSchema, headerSlice.getBytes(), headerSlice.getOffset(), headerSlice.getLength(), payloadSchema, payloadSlice.getBytes(), payloadSlice.getOffset(), payloadSlice.getLength(), null);
            } else {
                this.initialize(prologueSlice.getBytes(), prologueSlice.getOffset(), headerSchema, headerSlice.getBytes(), headerSlice.getOffset(), headerSlice.getLength(), null, null, 0, 0, null);
            }
        } else {
            byte[] rawHeader = (byte[])buffers.get(0);
            if (buffers.size() > 1) {
                byte[] rawPayload = (byte[])buffers.get(1);
                this.initialize(null, 0, headerSchema, rawHeader, 0, rawHeader.length, payloadSchema, rawPayload, 0, rawPayload.length, null);
            } else {
                this.initialize(null, 0, headerSchema, rawHeader, 0, rawHeader.length, null, null, 0, 0, null);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JsMsgObject");
        }
    }

    private void initialize(byte[] prologue, int prologueOffset, JMFSchema headerSchema, byte[] rawHeader, int hdrOffset, int hdrLength, JMFSchema payloadSchema, byte[] rawPayload, int payOffset, int payLength, CommsConnection conn) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialize", (Object)new Object[]{prologue, prologueOffset, headerSchema, rawHeader, hdrOffset, hdrLength, payloadSchema, rawPayload, payOffset, payLength, conn});
        }
        if (rawHeader != null) {
            int pOffset;
            byte[] pBuffer;
            boolean separatePrologue;
            boolean bl = separatePrologue = prologue != null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Decoding message from byte buffer(s)");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String outP = null;
                if (separatePrologue) {
                    outP = SibTr.formatBytes((byte[])prologue, (int)prologueOffset, (int)24);
                }
                String out0 = SibTr.formatBytes((byte[])rawHeader, (int)hdrOffset, (int)hdrLength);
                String out1 = null;
                if (rawPayload != null) {
                    out1 = SibTr.formatBytes((byte[])rawPayload, (int)payOffset, (int)payLength, (int)MfpDiagnostics.getDiagnosticDataLimitInt());
                }
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"buffers: ", (Object)new Object[]{outP, out0, out1});
            }
            if (rawHeader.length - hdrOffset < hdrLength || hdrLength < 24) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message buffer size too small: " + rawHeader.length));
                }
                throw new MessageDecodeFailedException("Invalid message buffer (buffer size too small)");
            }
            if (separatePrologue) {
                pBuffer = prologue;
                pOffset = prologueOffset;
            } else {
                pBuffer = rawHeader;
                pOffset = hdrOffset;
            }
            short jmfVer1 = ArrayUtil.readShort(pBuffer, pOffset);
            long encId1 = ArrayUtil.readLong(pBuffer, pOffset += 2);
            short jmfVer2 = ArrayUtil.readShort(pBuffer, pOffset += 8);
            long encId2 = ArrayUtil.readLong(pBuffer, pOffset += 2);
            int realHdrLength = ArrayUtil.readInt(pBuffer, pOffset += 8);
            pOffset += 4;
            if (!separatePrologue) {
                hdrOffset = pOffset;
            }
            this.originalLength = 24 + realHdrLength + payLength;
            this.headerPart = new JsMsgPart(this.initializePart(headerSchema, jmfVer1, encId1, rawHeader, hdrOffset, realHdrLength, conn));
            try {
                if (payLength > 0) {
                    this.payloadPart = new JsMsgPart(this.initializePart(payloadSchema, jmfVer2, encId2, rawPayload, payOffset, payLength, conn));
                }
            }
            catch (MessageDecodeFailedException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Decoded JMF Message Header", (Object)this.debugHeaderPart());
                }
                throw e;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Decoded JMF Message", (Object)this.debugMsg());
            }
        } else if (headerSchema != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Creating new empty header message: Schema=" + this.debugSchema(headerSchema)));
            }
            this.headerPart = new JsMsgPart(JMFRegistry.instance.newMessage(headerSchema));
            if (payloadSchema != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Creating new empty payload: Schema=" + this.debugSchema(payloadSchema)));
                }
                this.payloadPart = new JsMsgPart(JMFRegistry.instance.newMessage(payloadSchema));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialize");
        }
    }

    private JMFNativePart initializePart(JMFSchema schema, short jmfVer, long encId, byte[] rawMessage, int offset, int length, CommsConnection conn) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initializePart", (Object)new Object[]{jmfVer, this.debugId(encId), rawMessage, offset, length, conn});
        }
        JMFMessage jmfPart = null;
        try {
            if (schema == null) {
                schema = JMFRegistry.instance.retrieve(encId);
            }
            if (conn != null) {
                long[] unknownSchemata = JMFRegistry.instance.checkSchemata(jmfVer, rawMessage, offset);
                byte[] schemataRequest = null;
                int requestOffset = 0;
                if (schema == null) {
                    schemataRequest = new byte[(unknownSchemata.length + 1) * 8];
                    ArrayUtil.writeLong(schemataRequest, requestOffset, encId);
                    requestOffset += 8;
                } else if (unknownSchemata.length > 0) {
                    schemataRequest = new byte[unknownSchemata.length * 8];
                }
                for (int i = 0; i < unknownSchemata.length; ++i) {
                    ArrayUtil.writeLong(schemataRequest, requestOffset, unknownSchemata[i]);
                    requestOffset += 8;
                }
                if (schemataRequest != null) {
                    byte[] newSchemata = null;
                    try {
                        newSchemata = conn.requestMFPSchemata(schemataRequest);
                    }
                    catch (SIConnectionDroppedException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initializePart", (String)"jmo400", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, rawMessage, offset, length});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("decode failed: " + e));
                        }
                        throw new MessageDecodeFailedException(e);
                    }
                    catch (SIConnectionLostException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initializePart", (String)"jmo402", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, rawMessage, offset, length});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("decode failed: " + e));
                        }
                        throw new MessageDecodeFailedException(e);
                    }
                    catch (SIConnectionUnavailableException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initializePart", (String)"jmo403", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, rawMessage, offset, length});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("decode failed: " + e));
                        }
                        throw new MessageDecodeFailedException(e);
                    }
                    catch (SIErrorException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initialize", (String)"jmo404", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, rawMessage, offset, length});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("decode failed: " + e));
                        }
                        throw new MessageDecodeFailedException(e);
                    }
                    if (newSchemata != null) {
                        SchemaManager.receiveSchemas(conn, newSchemata);
                    }
                    if (schema == null) {
                        schema = JMFRegistry.instance.retrieve(encId);
                    }
                }
                if (schema == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unable to retrieve message schema " + this.debugId(encId)));
                    }
                    MessageDecodeFailedException e = new MessageDecodeFailedException("No schema registered for schema id " + this.debugId(encId));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initializePart", (String)"jmo425", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, rawMessage, offset, length});
                    throw e;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Decoding: JMF version=" + jmfVer + " encoding schema=" + this.debugId(encId) + " access schema=" + this.debugId(schema.getID())));
            }
            jmfPart = JMFRegistry.instance.decode(schema, jmfVer, encId, rawMessage, offset, length);
        }
        catch (JMFException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.initializePart", (String)"jmo450", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, rawMessage, offset, length});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("decode failed: " + e));
            }
            throw new MessageDecodeFailedException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initializePart");
        }
        return jmfPart;
    }

    void setMessage(MessageImpl msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMessage", (Object)msg);
        }
        this.theMessage = msg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSlice encodeSinglePartMessage(Object conn) throws MessageEncodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encodeSinglePartMessage");
        }
        if (this.payloadPart != null) {
            MessageEncodeFailedException mefe = new MessageEncodeFailedException("Invalid call to encodeSinglePartMessage");
            FFDCFilter.processException((Throwable)mefe, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encodeSinglePartMessage", (String)"jmo530", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
            throw mefe;
        }
        if (conn != null && !(conn instanceof CommsConnection)) {
            throw new MessageEncodeFailedException("Incorrect connection object: " + conn.getClass());
        }
        byte[] buffer = null;
        try {
            MessageImpl messageImpl = this.theMessage;
            synchronized (messageImpl) {
                this.theMessage.updateDataFields(2);
                this.ensureReceiverHasSchemata((CommsConnection)conn);
                Object object = this.getPartLockArtefact(this.headerPart);
                synchronized (object) {
                    buffer = new byte[24 + ((JMFMessage)this.headerPart.jmfPart).getEncodedLength()];
                    int offset = this.encodeIds(buffer, 0);
                    this.encodePartToBuffer(this.headerPart, true, buffer, offset);
                }
            }
        }
        catch (MessageEncodeFailedException e1) {
            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encodeSinglePartMessage", (String)"jmo500", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, null, this.theMessage});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("encodeSinglePartMessage failed: " + e1));
            }
            throw e1;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encodeSinglePartMessage", (String)"jmo520", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("encodeSinglePartMessage failed: " + e));
            }
            throw new MessageEncodeFailedException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Encoded JMF Message", (Object)this.debugMsg());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"buffers: ", (Object)SibTr.formatBytes((byte[])buffer, (int)0, (int)buffer.length));
        }
        DataSlice slice = new DataSlice(buffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encodeSinglePartMessage", (Object)slice);
        }
        return slice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DataSlice> encodeFast(Object conn) throws MessageEncodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encodeFast");
        }
        if (conn != null && !(conn instanceof CommsConnection)) {
            throw new MessageEncodeFailedException("Incorrect connection object: " + conn.getClass());
        }
        ArrayList<DataSlice> messageSlices = new ArrayList<DataSlice>(3);
        DataSlice slice0 = null;
        DataSlice slice1 = null;
        DataSlice slice2 = null;
        try {
            this.ensureReceiverHasSchemata((CommsConnection)conn);
            byte[] buff0 = new byte[24];
            int offset = 0;
            offset += this.encodeIds(buff0, 0);
            slice0 = new DataSlice(buff0, 0, buff0.length);
            MessageImpl messageImpl = this.theMessage;
            synchronized (messageImpl) {
                this.theMessage.updateDataFields(2);
                slice1 = this.encodeHeaderPartToSlice(this.headerPart);
                ArrayUtil.writeInt(buff0, offset, slice1.getLength());
                messageSlices.add(slice0);
                messageSlices.add(slice1);
                if (this.payloadPart != null) {
                    slice2 = this.encodePayloadPartToSlice(this.payloadPart, (CommsConnection)conn);
                    messageSlices.add(slice2);
                }
            }
        }
        catch (MessageEncodeFailedException e1) {
            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encodeFast", (String)"jmo560", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, null, this.theMessage});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("encodeFast failed: " + e1));
            }
            throw e1;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encodeFast", (String)"jmo570", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("encodeFast failed: " + e));
            }
            throw new MessageEncodeFailedException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Encoded JMF Message", (Object)this.debugMsg());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message DataSlices: ", (Object)SibTr.formatSlices(messageSlices, (int)MfpDiagnostics.getDiagnosticDataLimitInt()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encodeFast");
        }
        return messageSlices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DataSlice> flatten(Object store, byte[] nameBytes) throws MessageEncodeFailedException {
        long[] encodeIds;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"flatten", (Object)new Object[]{store, nameBytes});
        }
        ArrayList<DataSlice> messageSlices = new ArrayList<DataSlice>(3);
        if (store != null) {
            if (!(store instanceof MessageStore)) {
                throw new IllegalArgumentException("store is not a MessageStore instance");
            }
            JMFSchema[] encodeSchemas = this.getEncodingSchemas();
            SchemaStore.saveSchemas((MessageStore)store, encodeSchemas);
            encodeIds = new long[encodeSchemas.length];
            for (int i = 0; i < encodeSchemas.length; ++i) {
                encodeIds[i] = encodeSchemas[i].getID();
            }
        } else {
            encodeIds = new long[]{};
        }
        int bufferLength = 0;
        bufferLength += 4;
        bufferLength += nameBytes.length;
        bufferLength += 4;
        bufferLength += encodeIds.length * 8;
        bufferLength += 20;
        byte[] buff0 = new byte[bufferLength += 4];
        int offset = 0;
        ArrayUtil.writeInt(buff0, offset, nameBytes.length);
        ArrayUtil.writeBytes(buff0, offset += 4, nameBytes);
        ArrayUtil.writeInt(buff0, offset += nameBytes.length, encodeIds.length);
        offset += 4;
        for (int i = 0; i < encodeIds.length; ++i) {
            ArrayUtil.writeLong(buff0, offset, encodeIds[i]);
            offset += 8;
        }
        offset += this.encodeIds(buff0, offset);
        DataSlice slice0 = new DataSlice(buff0, 0, bufferLength);
        try {
            MessageImpl messageImpl = this.theMessage;
            synchronized (messageImpl) {
                this.theMessage.updateDataFields(1);
                DataSlice slice1 = null;
                DataSlice slice2 = null;
                slice1 = this.encodeHeaderPartToSlice(this.headerPart);
                ArrayUtil.writeInt(buff0, offset, slice1.getLength());
                messageSlices.add(slice0);
                messageSlices.add(slice1);
                if (this.payloadPart != null) {
                    slice2 = this.encodePayloadPartToSlice(this.payloadPart, null);
                    messageSlices.add(slice2);
                }
            }
        }
        catch (MessageEncodeFailedException e1) {
            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.flatten", (String)"jmo580", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, null, this.theMessage});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("flatten failed: " + e1));
            }
            throw e1;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.flatten", (String)"jmo590", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("flatten failed: " + e));
            }
            throw new MessageEncodeFailedException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Flattened JMF Message", (Object)this.debugMsg());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message DataSlices: ", (Object)SibTr.formatSlices(messageSlices, (int)MfpDiagnostics.getDiagnosticDataLimitInt()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"flatten");
        }
        return messageSlices;
    }

    private final int encodeIds(byte[] buffer, int offset) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encodeIds");
        }
        int idOffset = offset;
        ArrayUtil.writeShort(buffer, idOffset, ((JMFMessage)this.headerPart.jmfPart).getJMFEncodingVersion());
        ArrayUtil.writeLong(buffer, idOffset += 2, this.headerPart.jmfPart.getEncodingSchema().getID());
        idOffset += 8;
        if (this.payloadPart != null) {
            ArrayUtil.writeShort(buffer, idOffset, ((JMFMessage)this.payloadPart.jmfPart).getJMFEncodingVersion());
            ArrayUtil.writeLong(buffer, idOffset += 2, this.payloadPart.jmfPart.getEncodingSchema().getID());
            idOffset += 8;
        } else {
            ArrayUtil.writeShort(buffer, idOffset, (short)0);
            ArrayUtil.writeLong(buffer, idOffset += 2, 0L);
            idOffset += 8;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encodeIds", (Object)(idOffset - offset));
        }
        return idOffset - offset;
    }

    private final int encodePartToBuffer(JsMsgPart jsPart, boolean header, byte[] buffer, int offset) throws MessageEncodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encodePartToBuffer", (Object)new Object[]{jsPart, header, buffer, offset});
        }
        JMFMessage msg = (JMFMessage)jsPart.jmfPart;
        int length = 0;
        int newOffset = offset;
        try {
            length = msg.getEncodedLength();
            if (header) {
                ArrayUtil.writeInt(buffer, offset, length);
                newOffset += 4;
            }
            msg.toByteArray(buffer, newOffset, length);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encodePartToBuffer", (String)"jmo600", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, msg, this.theMessage}, new Object[]{MfpConstants.DM_BUFFER, buffer, offset, length + 4}});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("encodePartToBuffer encode failed: " + e));
            }
            throw new MessageEncodeFailedException(e);
        }
        length += newOffset - offset;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encodePartToBuffer", (Object)length);
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataSlice encodeHeaderPartToSlice(JsMsgPart jsPart) throws MessageEncodeFailedException {
        DataSlice slice;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encodeHeaderPartToSlice", (Object)jsPart);
        }
        if ((slice = ((JMFMessage)jsPart.jmfPart).getAssembledContent()) == null) {
            byte[] buff;
            Object object = this.getPartLockArtefact(jsPart);
            synchronized (object) {
                buff = this.encodePart(jsPart);
            }
            slice = new DataSlice(buff, 0, buff.length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encodeHeaderPartToSlice", (Object)slice);
        }
        return slice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataSlice encodePayloadPartToSlice(JsMsgPart jsPart, CommsConnection conn) throws MessageEncodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encodePayloadPartToSlice", (Object)new Object[]{jsPart, conn});
        }
        boolean beans = false;
        DataSlice slice = null;
        if (((JsMessage)((Object)this.theMessage)).getProducerType() != ProducerType.API || this.payloadPart.getField(0) == null || !((String)this.payloadPart.getField(0)).startsWith("Bean:")) {
            slice = ((JMFMessage)jsPart.jmfPart).getAssembledContent();
        } else {
            beans = true;
        }
        if (slice == null) {
            try {
                Object object = this.getPartLockArtefact(jsPart);
                synchronized (object) {
                    if (beans) {
                        if (conn != null) {
                            MfpThreadDataImpl.setPartnerLevel(conn.getMetaData().getProtocolVersion());
                        }
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"unassembling Beans message");
                            }
                            ((JMFNativePart)jsPart.getField(1)).unassemble();
                        }
                        catch (JMFException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encodePayloadPartToSlice", (String)"jmo620", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, jsPart.jmfPart, this.theMessage});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("encodePayloadPartToSlice unassemble failed: " + e));
                            }
                            throw new MessageEncodeFailedException(e);
                        }
                    }
                    byte[] buff = this.encodePart(jsPart);
                    slice = new DataSlice(buff, 0, buff.length);
                }
            }
            finally {
                MfpThreadDataImpl.clearPartnerLevel();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encodePayloadPartToSlice", (Object)slice);
        }
        return slice;
    }

    private final byte[] encodePart(JsMsgPart jsPart) throws MessageEncodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encodePart", (Object)jsPart);
        }
        JMFMessage msg = (JMFMessage)jsPart.jmfPart;
        byte[] buffer = null;
        int length = 0;
        try {
            length = msg.getEncodedLength();
            buffer = msg.toByteArray(length);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.encodePart", (String)"jmo630", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, msg, this.theMessage}, new Object[]{MfpConstants.DM_BUFFER, buffer, 0, length}});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("encode failed: " + e));
            }
            throw new MessageEncodeFailedException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encodePart", (Object)length);
        }
        return buffer;
    }

    JMFSchema[] getEncodingSchemas() throws MessageEncodeFailedException {
        JMFSchema[] result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getEncodingSchemas");
        }
        try {
            JMFSchema[] result1 = ((JMFMessage)this.headerPart.jmfPart).getSchemata();
            JMFSchema[] result2 = null;
            int resultSize = result1.length;
            if (this.payloadPart != null) {
                result2 = ((JMFMessage)this.payloadPart.jmfPart).getSchemata();
                resultSize += result2.length;
            }
            result = new JMFSchema[resultSize];
            System.arraycopy(result1, 0, result, 0, result1.length);
            if (this.payloadPart != null) {
                System.arraycopy(result2, 0, result, result1.length, result2.length);
            }
        }
        catch (JMFException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.getEncodingSchemas", (String)"jmo700", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("getEncodingSchemas failed: " + e));
            }
            throw new MessageEncodeFailedException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getEncodingSchemas");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsMsgObject getCopy() throws MessageCopyFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCopy");
        }
        JsMsgObject newJmo = null;
        try {
            MessageImpl messageImpl = this.theMessage;
            synchronized (messageImpl) {
                this.theMessage.updateDataFields(6);
                this.theMessage.clearPartCaches();
                newJmo = new JsMsgObject(null);
                newJmo.headerPart = new JsMsgPart(((JMFMessage)this.headerPart.jmfPart).copy());
                newJmo.payloadPart = new JsMsgPart(((JMFMessage)this.payloadPart.jmfPart).copy());
            }
        }
        catch (MessageDecodeFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.getCopy", (String)"jmo800", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("copy failed: " + e));
            }
            throw new MessageCopyFailedException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCopy", (Object)newJmo);
        }
        return newJmo;
    }

    JsMsgObject transcribeToJmf() throws MessageCopyFailedException {
        JsMsgObject newJmo;
        Object originalPayloadObject;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"transcribeToJmf");
        }
        JMFEncapsulation originalApiEncap = null;
        JMFEncapsulation originalPayloadDataPart = null;
        if (this.headerPart.getIntField(10) == 1) {
            JsMsgPart originalApiPart = this.getPart(9, JsApiAccess.schema);
            if (originalApiPart.jmfPart instanceof JMFEncapsulation) {
                JMFNativePart originalNativeApiPart = originalApiPart.jmfPart;
                originalApiEncap = (JMFEncapsulation)((Object)originalNativeApiPart);
            }
        }
        if (this.payloadPart != null && this.payloadPart.getIntField(4) == 1 && (originalPayloadObject = this.payloadPart.getField(1)) instanceof JMFEncapsulation) {
            originalPayloadDataPart = (JMFEncapsulation)originalPayloadObject;
        }
        if (originalApiEncap == null && originalPayloadDataPart == null) {
            newJmo = this;
        } else {
            newJmo = this.getCopy();
            if (originalApiEncap != null) {
                JMFNativePart newNativeApiPart = JSRegistry.instance.newNativePart(JsApiAccess.schema);
                try {
                    originalApiEncap.transcribe(newNativeApiPart, true);
                    ((JMFMessage)newJmo.headerPart.jmfPart).unassemble();
                    newJmo.setField(9, newNativeApiPart);
                }
                catch (JMFSchemaViolationException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo880", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("transcribe headers failed: " + e));
                    }
                    throw new MessageCopyFailedException(e);
                }
                catch (JMFModelNotImplementedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo881", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("transcribe headers failed: " + e));
                    }
                    throw new MessageCopyFailedException(e);
                }
                catch (JMFUninitializedAccessException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo882", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("transcribe headers failed: " + e));
                    }
                    throw new MessageCopyFailedException(e);
                }
                catch (JMFMessageCorruptionException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo883", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("transcribe headers failed: " + e));
                    }
                    throw new MessageCopyFailedException(e);
                }
            }
            if (originalPayloadDataPart != null) {
                JMFSchema schema = originalPayloadDataPart.getNativePart().getEncodingSchema();
                JMFNativePart newNativePayloadPart = JSRegistry.instance.newNativePart(schema);
                try {
                    originalPayloadDataPart.transcribe(newNativePayloadPart, true);
                    ((JMFMessage)newJmo.getPayloadPart().jmfPart).unassemble();
                    newJmo.getPayloadPart().setField(1, newNativePayloadPart);
                }
                catch (JMFSchemaViolationException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo890", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("transcribe payload failed: " + e));
                    }
                    throw new MessageCopyFailedException(e);
                }
                catch (JMFModelNotImplementedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo891", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("transcribe payload failed: " + e));
                    }
                    throw new MessageCopyFailedException(e);
                }
                catch (JMFUninitializedAccessException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo892", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("transcribe payload failed: " + e));
                    }
                    throw new MessageCopyFailedException(e);
                }
                catch (JMFMessageCorruptionException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.transcribeToJmf", (String)"jmo893", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_MESSAGE, this.headerPart.jmfPart, this.theMessage}, new Object[]{MfpConstants.DM_MESSAGE, this.payloadPart.jmfPart, this.theMessage}});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("transcribe payload failed: " + e));
                    }
                    throw new MessageCopyFailedException(e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"transcribeToJmf", (Object)newJmo);
        }
        return newJmo;
    }

    int getOriginalLength() {
        return this.originalLength;
    }

    final JsMsgPart getHeaderPart() {
        return this.headerPart;
    }

    final JsMsgPart getPayloadPart() {
        return this.payloadPart;
    }

    private Object getPartLockArtefact(JsMsgPart part) {
        return ((JMFMessage)part.jmfPart).getMessageLockArtefact();
    }

    private final void ensureReceiverHasSchemata(CommsConnection conn) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ensureReceiverHasSchemata", (Object)conn);
        }
        if (conn != null) {
            SchemaManager.sendSchemas(conn, ((JMFMessage)this.headerPart.jmfPart).getSchemata());
            if (this.payloadPart != null) {
                SchemaManager.sendSchemas(conn, ((JMFMessage)this.payloadPart.jmfPart).getSchemata());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ensureReceiverHasSchemata");
        }
    }

    void setField(int accessor, Object value) {
        this.headerPart.setField(accessor, value);
    }

    Object getField(int accessor) {
        return this.headerPart.getField(accessor);
    }

    void setIntField(int accessor, int value) {
        this.headerPart.setIntField(accessor, value);
    }

    int getIntField(int accessor) {
        return this.headerPart.getIntField(accessor);
    }

    void setLongField(int accessor, long value) {
        this.headerPart.setLongField(accessor, value);
    }

    long getLongField(int accessor) {
        return this.headerPart.getLongField(accessor);
    }

    void setBooleanField(int accessor, boolean value) {
        this.headerPart.setBooleanField(accessor, value);
    }

    boolean getBooleanField(int accessor) {
        return this.headerPart.getBooleanField(accessor);
    }

    void setChoiceField(int accessor, int variant) {
        this.headerPart.setChoiceField(accessor, variant);
    }

    int getChoiceField(int accessor) {
        return this.headerPart.getChoiceField(accessor);
    }

    void setPart(int accessor, JMFSchema schema) {
        this.headerPart.setPart(accessor, schema);
    }

    JsMsgPart getPart(int accessor, JMFSchema schema) {
        JsMsgPart part = this.headerPart.getPart(accessor, schema);
        if (part == null) {
            MessageDecodeFailedException e = new MessageDecodeFailedException();
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMsgObject.getPart", (String)"jmo900", (Object)this, (Object[])new Object[]{MfpConstants.DM_MESSAGE, this.headerPart, this.theMessage});
        }
        return part;
    }

    final String debugMsg() {
        StringBuffer result = new StringBuffer(JSFormatter.format((JMFMessage)this.headerPart.jmfPart));
        if (this.payloadPart != null) {
            result.append(JSFormatter.formatWithoutPayloadData((JMFMessage)this.payloadPart.jmfPart));
        }
        return result.toString();
    }

    final String debugHeaderPart() {
        return JSFormatter.format((JMFMessage)this.headerPart.jmfPart);
    }

    final String debugSchema(JMFSchema schema) {
        if (schema != null) {
            return schema.getName() + "(" + this.debugId(schema.getID()) + ")";
        }
        return "<null>";
    }

    final String debugId(long id) {
        byte[] buf = new byte[8];
        ArrayUtil.writeLong(buf, 0, id);
        return HexUtil.toString(buf);
    }
}

