/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.mfp.JsJmsMessageFactory;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageRestoreFailedException;
import com.ibm.ws.sib.mfp.MessageType;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.impl.JsJmsMessageFactoryImpl;
import com.ibm.ws.sib.mfp.impl.JsMessageFactory;
import com.ibm.ws.sib.mfp.impl.JsMessageImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.SchemaManager;
import com.ibm.ws.sib.mfp.impl.SchemaStore;
import com.ibm.ws.sib.mfp.impl.WebJsMessageFactoryImpl;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.schema.JsHdrAccess;
import com.ibm.ws.sib.mfp.schema.JsPayloadAccess;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class JsMessageFactoryImpl
extends JsMessageFactory {
    private static TraceComponent tc = SibTr.register(JsMessageFactoryImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static JsJmsMessageFactoryImpl jmsFactory;

    private static JsJmsMessageFactoryImpl getJmsFactory() {
        if (jmsFactory == null) {
            try {
                jmsFactory = (JsJmsMessageFactoryImpl)JsJmsMessageFactory.getInstance();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"<clinit>", (String)"116");
            }
        }
        return jmsFactory;
    }

    @Override
    public JsMessage createInboundJsMessage(byte[] rawMessage, int offset, int length) throws MessageDecodeFailedException {
        return this.createInboundJsMessage(rawMessage, offset, length, null);
    }

    @Override
    public JsMessage createInboundJsMessage(byte[] rawMessage, int offset, int length, Object conn) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createInboundJsMessage", (Object)new Object[]{rawMessage, offset, length});
        }
        CommsConnection commsConnection = null;
        if (conn != null) {
            if (conn instanceof CommsConnection) {
                commsConnection = (CommsConnection)conn;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Invalid comms connection");
                }
                ClassCastException e = new ClassCastException();
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMessageFactoryImpl.createInboundJsMessage", (String)"168", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, rawMessage, offset, length, conn});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Start of buffer: ", (Object)SibTr.formatBytes((byte[])rawMessage, (int)0, (int)256));
        }
        JsMsgObject jmo = new JsMsgObject(JsHdrAccess.schema, JsPayloadAccess.schema, rawMessage, offset, length, commsConnection);
        JsMessage message = this.createSpecialisedMessage(jmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createInboundJsMessage", (Object)message);
        }
        return message;
    }

    @Override
    public JsMessage createInboundJsMessage(List<DataSlice> slices) throws MessageDecodeFailedException {
        return this.createInboundJsMessage(slices, null);
    }

    @Override
    public JsMessage createInboundJsMessage(List<DataSlice> slices, Object conn) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createInboundJsMessage", slices);
        }
        CommsConnection commsConnection = null;
        if (conn != null) {
            if (conn instanceof CommsConnection) {
                commsConnection = (CommsConnection)conn;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Invalid comms connection");
                }
                ClassCastException e = new ClassCastException();
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMessageFactoryImpl.createInboundJsMessage", (String)"254", (Object)this, (Object[])new Object[]{MfpConstants.DM_SLICES, slices, conn});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (slices.size() > 1) {
                SibTr.debug((TraceComponent)tc, (String)"Slice0: ", (Object)SibTr.formatSlice((DataSlice)slices.get(0)));
            } else {
                SibTr.debug((TraceComponent)tc, (String)"Start of only slice: ", (Object)SibTr.formatBytes((byte[])slices.get(0).getBytes(), (int)slices.get(0).getOffset(), (int)256));
            }
        }
        JsMsgObject jmo = new JsMsgObject((JMFSchema)JsHdrAccess.schema, JsPayloadAccess.schema, slices, commsConnection);
        JsMessage message = this.createSpecialisedMessage(jmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createInboundJsMessage", (Object)message);
        }
        return message;
    }

    @Override
    public JsMessage createInboundWebMessage(String data) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createInboundWebMessage", (Object)data);
        }
        JsMessage message = WebJsMessageFactoryImpl.createInboundWebMessage(data);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createInboundWebMessage", (Object)message);
        }
        return message;
    }

    @Override
    public JsMessage restoreJsMessage(List<DataSlice> slices, Object store) throws MessageRestoreFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restoreJsMessage", slices);
        }
        JsMessage newMsg = null;
        if (slices == null || slices.size() < 1) {
            String exString = nls.getFormattedMessage("NO_DATASLICES_IN_LIST_CWSIF0002", null, "A null or empty DataSlice List was passed to the message restore");
            MessageRestoreFailedException e = new MessageRestoreFailedException(exString);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMessageFactoryImpl.restore", (String)"373");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Exception: DataSlice list was null or empty");
            }
            throw e;
        }
        if (slices.size() == 1) {
            newMsg = this.restoreJsMessage(slices.get(0).getBytes(), store);
        } else {
            String className;
            DataSlice slice0 = slices.get(0);
            byte[] buffer = slice0.getBytes();
            int offset = slice0.getOffset();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Slice0: ", (Object)SibTr.formatSlice((DataSlice)slice0));
            }
            int temp = ArrayUtil.readInt(buffer, offset);
            offset += 4;
            try {
                className = JsMessageFactoryImpl.getClassName(buffer, offset, temp);
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMessageFactoryImpl.restoreJsMessage", (String)"484", (Object)this, (Object[])new Object[]{new Object[]{MfpConstants.DM_BUFFER, buffer, slice0.getOffset(), slice0.getLength()}, new Object[]{MfpConstants.DM_BUFFER, buffer, 0, buffer.length}});
                throw new MessageRestoreFailedException(e);
            }
            offset += temp;
            offset = JsMessageFactoryImpl.ensureSchemasAvailable(buffer, offset, store);
            DataSlice newSlice0 = new DataSlice(buffer, offset, slice0.getLength() - offset);
            slices.set(0, newSlice0);
            try {
                JsMsgObject newJmo = new JsMsgObject(JsHdrAccess.schema, JsPayloadAccess.schema, slices);
                Class<?> msgClass = Class.forName(className);
                newMsg = (JsMessage)msgClass.newInstance();
                ((JsMessageImpl)newMsg).setJmo(newJmo);
                ((JsMessageImpl)newMsg).setApproximateLength(newJmo.getOriginalLength());
            }
            catch (ClassNotFoundException e1) {
                FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.mfp.impl.JsMessageFactoryImpl.restore", (String)"446");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Exception " + e1.toString() + " finding class " + className));
                }
                throw new MessageRestoreFailedException(e1);
            }
            catch (MessageDecodeFailedException e2) {
                throw new MessageRestoreFailedException(e2);
            }
            catch (Exception e3) {
                FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.sib.mfp.impl.JsMessageFactoryImpl.restore", (String)"457");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Exception " + e3.toString() + " instantiating class " + className));
                }
                throw new MessageRestoreFailedException(e3);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreJsMessage");
        }
        return newMsg;
    }

    private final JsMessage restoreJsMessage(byte[] buffer, Object store) throws MessageRestoreFailedException {
        String className;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restoreJsMessage", (Object)buffer);
        }
        JsMessage newMsg = null;
        int offset = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Start of buffer: ", (Object)SibTr.formatBytes((byte[])buffer, (int)0, (int)256));
        }
        int temp = ArrayUtil.readInt(buffer, offset);
        offset += 4;
        try {
            className = JsMessageFactoryImpl.getClassName(buffer, offset, temp);
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsMessageFactoryImpl.restoreJsMessage", (String)"573", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, buffer, 0, buffer.length});
            throw new MessageRestoreFailedException(e);
        }
        offset += temp;
        offset = JsMessageFactoryImpl.ensureSchemasAvailable(buffer, offset, store);
        try {
            JsMsgObject newJmo = new JsMsgObject(JsHdrAccess.schema, JsPayloadAccess.schema, buffer, offset, buffer.length - offset);
            Class<?> msgClass = Class.forName(className);
            newMsg = (JsMessage)msgClass.newInstance();
            ((JsMessageImpl)newMsg).setJmo(newJmo);
            ((JsMessageImpl)newMsg).setApproximateLength(newJmo.getOriginalLength());
        }
        catch (ClassNotFoundException e1) {
            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.mfp.impl.JsMessageFactoryImpl.restore", (String)"534");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Exception " + e1.toString() + " finding class " + className));
            }
            throw new MessageRestoreFailedException(e1);
        }
        catch (MessageDecodeFailedException e2) {
            throw new MessageRestoreFailedException(e2);
        }
        catch (Exception e3) {
            FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.sib.mfp.impl.JsMessageFactoryImpl.restore", (String)"545");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Exception " + e3.toString() + " instantiating class " + className));
            }
            throw new MessageRestoreFailedException(e3);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreJsMessage");
        }
        return newMsg;
    }

    private static final String getClassName(byte[] buffer, int offset, int length) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getClassName", (Object)new Object[]{offset, length});
        }
        if (length == 0) {
            throw new IllegalArgumentException("Invalid buffer: classname length = 0");
        }
        String className = new String(buffer, offset, length, StandardCharsets.UTF_8);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getClassName", (Object)className);
        }
        return className;
    }

    private static final int ensureSchemasAvailable(byte[] buffer, int offset, Object store) throws MessageRestoreFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ensureSchemasAvailable", (Object)new Object[]{offset, store});
        }
        int temp = ArrayUtil.readInt(buffer, offset);
        offset += 4;
        long[] decodeIds = new long[temp];
        for (int i = 0; i < temp; ++i) {
            decodeIds[i] = ArrayUtil.readLong(buffer, offset);
            offset += 8;
        }
        if (store != null && decodeIds.length > 0) {
            if (!(store instanceof MessageStore)) {
                throw new IllegalArgumentException("store is not a MessageStore instance");
            }
            SchemaStore.loadSchemas((MessageStore)store, decodeIds);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ensureSchemasAvailable", (Object)offset);
        }
        return offset;
    }

    private final JsMessage createSpecialisedMessage(JsMsgObject jmo) {
        JsMessage message = null;
        if (jmo.getChoiceField(10) == 1) {
            if (jmo.getField(6).equals(MessageType.JMS.toByte())) {
                message = JsMessageFactoryImpl.getJmsFactory().createInboundJmsMessage(jmo, ((Byte)jmo.getField(7)).intValue());
            }
        } else {
            message = new JsMessageImpl(jmo);
        }
        return message;
    }

    static {
        SchemaManager.ensureInitialized();
    }
}

