/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.CompHandshake;
import com.ibm.ws.sib.mfp.impl.SchemaManager;
import com.ibm.ws.sib.utils.ras.SibTr;

public class CompHandshakeImpl
implements CompHandshake {
    private static TraceComponent tc = SibTr.register(CompHandshakeImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");

    @Override
    public boolean compStartHandshake(CommsConnection conn, int version) {
        try {
            SchemaManager.openLink(conn);
            return true;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"compStartHandshake", (String)"67", (Object)this);
            return false;
        }
    }

    @Override
    public boolean compData(CommsConnection conn, int version, byte[] data) {
        try {
            SchemaManager.receiveSchemas(conn, data);
            return true;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"compData", (String)"82", (Object)this);
            return false;
        }
    }

    @Override
    public byte[] compHandshakeData(CommsConnection conn, int version, byte[] data) {
        try {
            return SchemaManager.receiveHandshake(conn, data);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"compData", (String)"96", (Object)this);
            return null;
        }
    }

    @Override
    public void compClose(CommsConnection conn) {
        SchemaManager.closeLink(conn);
    }

    @Override
    public byte[] compRequest(CommsConnection conn, int productVersion, int packetId, byte[] data) {
        if (packetId == 110) {
            return SchemaManager.getEncodedSchemataByEncodedIDs(data);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Invalid packetId");
        }
        SIErrorException e = new SIErrorException();
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.CompHandshakeImpl.compRequest", (String)"123", (Object)this);
        throw e;
    }
}

