/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.war.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.cache.ZipCachingProperties;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ZipUtils {
    private static final TraceComponent tc = Tr.register(ZipUtils.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.war.internal.resources.Messages", (String)"com.ibm.ws.app.manager.war.internal.ZipUtils");
    public static final int RETRY_COUNT;
    public static final long RETRY_AMOUNT = 50L;
    public static final int RETRY_LIMIT = 1000;
    public static final boolean IS_EAR = true;
    public static final boolean IS_NOT_EAR = false;
    private static final String WAR_EXTENSION = ".war";
    static final long serialVersionUID = -3965276295612179432L;

    @Trivial
    public static File deleteWithRetry(File file) {
        String filePath;
        String methodName = "deleteWithRetry";
        if (tc.isDebugEnabled()) {
            filePath = file.getAbsolutePath();
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Recursively delete [ " + filePath + " ]"), (Object[])new Object[0]);
        } else {
            filePath = null;
        }
        File firstFailure = ZipUtils.delete(file);
        if (firstFailure == null) {
            if (filePath != null) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Successful first delete [ " + filePath + " ]"), (Object[])new Object[0]);
            }
            return null;
        }
        if (filePath != null) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Failed first delete [ " + filePath + " ]: Sleep up to 50 ms and retry"), (Object[])new Object[0]);
        }
        File secondFailure = firstFailure;
        for (int tryNo = 0; secondFailure != null && tryNo < RETRY_COUNT; ++tryNo) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.app.manager.war.internal.ZipUtils", (String)"140", null, (Object[])new Object[]{file});
            }
            secondFailure = ZipUtils.delete(file);
        }
        if (secondFailure == null) {
            if (filePath != null) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Successful first delete [ " + filePath + " ]"), (Object[])new Object[0]);
            }
            return null;
        }
        if (filePath != null) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Failed second delete [ " + filePath + " ]"), (Object[])new Object[0]);
        }
        return secondFailure;
    }

    @Trivial
    public static File delete(File file) {
        String methodName = "delete";
        String filePath = tc.isDebugEnabled() ? file.getAbsolutePath() : null;
        if (file.isDirectory()) {
            if (filePath != null) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Delete directory [ " + filePath + " ]"), (Object[])new Object[0]);
            }
            File firstFailure = null;
            File[] subFiles = file.listFiles();
            if (subFiles != null) {
                for (File subFile : subFiles) {
                    File nextFailure = ZipUtils.delete(subFile);
                    if (nextFailure == null || firstFailure != null) continue;
                    firstFailure = nextFailure;
                }
            }
            if (firstFailure != null) {
                if (filePath != null) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + ": Cannot delete [ " + filePath + " ] Child [ " + firstFailure.getAbsolutePath() + " ] could not be deleted."), (Object[])new Object[0]);
                }
                return firstFailure;
            }
        } else if (filePath != null) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Delete simple file [ " + filePath + " ]"), (Object[])new Object[0]);
        }
        if (!file.delete()) {
            if (filePath != null) {
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Failed to delete [ " + filePath + " ]"), (Object[])new Object[0]);
            }
            return file;
        }
        if (filePath != null) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Deleted [ " + filePath + " ]"), (Object[])new Object[0]);
        }
        return null;
    }

    public static void unzip(File source, File target, boolean isEar, long lastModified) throws IOException {
        byte[] transferBuffer = new byte[16384];
        ZipUtils.unzip(source, target, isEar, lastModified, transferBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public static void unzip(File source, File target, boolean isEar, long lastModified, byte[] transferBuffer) throws IOException {
        String methodName = "unzip";
        String sourcePath = source.getAbsolutePath();
        String targetPath = target.getAbsolutePath();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Source [ " + sourcePath + " ] Size [ " + source.length() + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Target [ " + targetPath + " ]"), (Object[])new Object[0]);
        }
        if (!source.exists()) {
            throw new IOException("Source [ " + sourcePath + " ] does not exist");
        }
        if (!source.isFile()) {
            throw new IOException("Source [ " + sourcePath + " ] is not a simple file");
        }
        if (!target.exists()) {
            throw new IOException("Target [ " + targetPath + " ] does not exist");
        }
        if (!target.isDirectory()) {
            throw new IOException("Target [ " + targetPath + " ] is not a directory");
        }
        ArrayList<Object[]> warData = isEar ? new ArrayList<Object[]>() : null;
        try (ZipFile sourceZip = new ZipFile(source);){
            Enumeration<? extends ZipEntry> sourceEntries = sourceZip.entries();
            while (sourceEntries.hasMoreElements()) {
                long entryModified;
                Object[] nextWarData;
                String targetFileName;
                ZipEntry sourceEntry = sourceEntries.nextElement();
                String sourceEntryName = sourceEntry.getName();
                if (ZipUtils.reachesOut(sourceEntryName)) {
                    Tr.error((TraceComponent)tc, (String)"error.file.outside.archive", (Object[])new Object[]{sourceEntryName, sourcePath});
                    continue;
                }
                if (isEar && !sourceEntry.isDirectory() && sourceEntryName.endsWith(WAR_EXTENSION)) {
                    int tmpNo = 0;
                    while (sourceZip.getEntry(targetFileName = sourceEntryName + ".tmp" + tmpNo) != null) {
                        ++tmpNo;
                    }
                    nextWarData = new Object[]{sourceEntryName, targetFileName, null};
                } else {
                    targetFileName = sourceEntryName;
                    nextWarData = null;
                }
                File targetFile = new File(target, targetFileName);
                if (sourceEntry.isDirectory()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + ": Directory [ " + sourceEntryName + " ]"), (Object[])new Object[0]);
                    }
                    if (!targetFile.exists() && !targetFile.mkdirs()) {
                        throw new IOException("Failed to create directory [ + " + targetFile.getAbsolutePath() + " ]");
                    }
                } else {
                    File targetParent;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + ": Simple file [ " + sourceEntryName + " ] [ " + sourceEntry.getSize() + " ]"), (Object[])new Object[0]);
                    }
                    if (!(targetParent = targetFile.getParentFile()).mkdirs() && !targetParent.exists()) {
                        throw new IOException("Failed to create directory [ " + targetParent.getAbsolutePath() + " ]");
                    }
                    ZipUtils.transfer(sourceZip, sourceEntry, targetFile, transferBuffer);
                }
                if ((entryModified = sourceEntry.getTime()) == -1L) {
                    entryModified = lastModified;
                }
                targetFile.setLastModified(entryModified);
                if (nextWarData == null) continue;
                nextWarData[2] = entryModified;
                warData.add(nextWarData);
            }
        }
        if (isEar) {
            for (Object[] nextWarData : warData) {
                String unpackedWarName = (String)nextWarData[0];
                String packedWarName = (String)nextWarData[1];
                long warLastModified = (Long)nextWarData[2];
                File unpackedWarFile = new File(target, unpackedWarName);
                if (!unpackedWarFile.exists() && !unpackedWarFile.mkdirs()) {
                    throw new IOException("Failed to create [ " + unpackedWarFile.getAbsolutePath() + " ]");
                }
                File packedWarFile = new File(target, packedWarName);
                ZipUtils.unzip(packedWarFile, unpackedWarFile, false, warLastModified, transferBuffer);
                if (packedWarFile.delete() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(methodName + ": Failed to delete temporary WAR [ " + packedWarFile.getAbsolutePath() + " ]"), (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": Set last modified [ " + lastModified + " ]"), (Object[])new Object[0]);
        }
        target.setLastModified(lastModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private static void transfer(ZipFile sourceZip, ZipEntry sourceEntry, File targetFile, byte[] transferBuffer) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int lastRead;
            inputStream = sourceZip.getInputStream(sourceEntry);
            outputStream = new FileOutputStream(targetFile);
            while ((lastRead = inputStream.read(transferBuffer)) != -1) {
                outputStream.write(transferBuffer, 0, lastRead);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private static boolean reachesOut(String entryPath) {
        if (!entryPath.contains("..")) {
            return false;
        }
        String normalizedPath = PathUtils.normalizeUnixStylePath((String)entryPath);
        return PathUtils.isNormalizedPathAbsolute((String)normalizedPath);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        if (ZipCachingProperties.ZIP_CACHE_REAPER_MAX_PENDING == 0) {
            RETRY_COUNT = 1;
        } else {
            long totalAmount = ZipCachingProperties.ZIP_CACHE_REAPER_SLOW_PEND_MAX * 2L;
            if (totalAmount <= 0L) {
                RETRY_COUNT = 1;
            } else {
                if (totalAmount > 1000L) {
                    totalAmount = 1000L;
                }
                int retryCount = (int)(totalAmount / 50L);
                if (totalAmount % 50L > 0L) {
                    ++retryCount;
                }
                RETRY_COUNT = retryCount;
            }
        }
    }
}

