/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.soap;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAPOperationSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAPOperation soapOperation = (SOAPOperation)extension;
        if (soapOperation != null) {
            String tagName = DOMUtils.getQualifiedValue((String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)"operation", (Definition)def);
            pw.print("      <" + tagName);
            DOMUtils.printAttribute((String)"soapAction", (String)soapOperation.getSoapActionURI(), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"style", (String)soapOperation.getStyle(), (PrintWriter)pw);
            Boolean required = soapOperation.getRequired();
            if (required != null) {
                DOMUtils.printQualifiedAttribute((QName)Constants.Q_ATTR_REQUIRED, (String)required.toString(), (Definition)def, (PrintWriter)pw);
            }
            pw.println("/>");
        }
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAPOperation soapOperation = (SOAPOperation)extReg.createExtension(parentType, elementType);
        String soapActionURI = DOMUtils.getAttribute((Element)el, (String)"soapAction");
        String style = DOMUtils.getAttribute((Element)el, (String)"style");
        String requiredStr = DOMUtils.getAttributeNS((Element)el, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"required");
        if (soapActionURI != null) {
            soapOperation.setSoapActionURI(soapActionURI);
        }
        if (style != null) {
            soapOperation.setStyle(style);
        }
        if (requiredStr != null) {
            soapOperation.setRequired(new Boolean(requiredStr));
        }
        return soapOperation;
    }
}

