/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.net.URI;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.util.Encode;

public abstract class BaseHttpRequest
implements HttpRequest {
    protected MultivaluedMap<String, String> formParameters;
    protected MultivaluedMap<String, String> decodedFormParameters;
    protected ResteasyUriInfo uri;

    protected BaseHttpRequest(ResteasyUriInfo uri) {
        this.uri = uri;
    }

    @Override
    public ResteasyUriInfo getUri() {
        return this.uri;
    }

    @Override
    public boolean formParametersRead() {
        return this.formParameters != null || this.decodedFormParameters != null;
    }

    @Override
    public MultivaluedMap<String, String> getFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        if (this.decodedFormParameters != null) {
            this.formParameters = Encode.encode(this.decodedFormParameters);
            return this.formParameters;
        }
        MediaType mt = this.getHttpHeaders().getMediaType();
        if (MediaType.valueOf((String)"application/x-www-form-urlencoded").isCompatible(mt)) {
            try {
                this.formParameters = FormUrlEncodedProvider.parseForm(this.getInputStream(), (String)mt.getParameters().get("charset"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException(Messages.MESSAGES.requestMediaTypeNotUrlencoded());
        }
        return this.formParameters;
    }

    @Override
    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = Encode.decode(this.getFormParameters());
        return this.decodedFormParameters;
    }

    @Override
    public boolean isInitial() {
        return true;
    }

    @Override
    public void setRequestUri(URI requestUri) throws IllegalStateException {
        this.uri.setRequestUri(requestUri);
    }

    @Override
    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        this.uri.setUri(baseUri, requestUri);
    }
}

