/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import com.ibm.websphere.jaxrs20.multipart.IAttachment;
import com.ibm.websphere.jaxrs20.multipart.IMultipartBody;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.resteasy.plugins.providers.multipart.IAttachmentImpl;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartReader;
import org.jboss.resteasy.plugins.providers.multipart.MultipartWriter;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.util.Types;

@Provider
@Consumes(value={"multipart/related", "multipart/mixed", "multipart/alternative", "multipart/form-data"})
@Produces(value={"multipart/related", "multipart/mixed", "multipart/alternative", "multipart/form-data"})
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class IBMMultipartListProvider
implements MessageBodyReader<List<Object>>,
MessageBodyWriter<List<Object>> {
    private static final Set<Class<?>> MULTIPART_CLASSES;
    private static final Set<String> MULTIPART_SUBTYPES;
    @Context
    Providers providers;
    private LibertyMultipartWriter writer = new LibertyMultipartWriter();
    static final long serialVersionUID = -8577416456937747736L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public boolean isReadable(Class<?> clazz, Type type, Annotation[] anns, MediaType mt) {
        return this.isSupported(clazz, type, anns, mt);
    }

    public boolean isWriteable(Class<?> clazz, Type type, Annotation[] anns, MediaType mt) {
        return this.isSupported(clazz, type, anns, mt);
    }

    private boolean isSupported(Class<?> clazz, Type type, Annotation[] anns, MediaType mt) {
        return this.mediaTypeSupported(mt) && !Types.isGenericTypeInstanceOf(EntityPart.class, type) && (MULTIPART_CLASSES.contains(clazz) || Collection.class.isAssignableFrom(clazz));
    }

    private boolean mediaTypeSupported(MediaType mt) {
        return "multipart".equals(mt.getType()) && MULTIPART_SUBTYPES.contains(mt.getSubtype());
    }

    public List<Object> readFrom(Class<List<Object>> clazz, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream entityStream) throws IOException, WebApplicationException {
        MultipartReader reader = new MultipartReader();
        reader.workers = this.providers;
        Object multiInput = reader.readFrom((Class)MultipartInput.class, genericType, anns, mt, (MultivaluedMap)headers, entityStream);
        if (Collection.class.isAssignableFrom(clazz)) {
            if (genericType instanceof ParameterizedType && ((ParameterizedType)genericType).getActualTypeArguments()[0].getTypeName().equals(IAttachment.class.getName())) {
                ArrayList<Object> attachments = new ArrayList<Object>();
                for (InputPart inputPart : multiInput.getParts()) {
                    attachments.add(new IAttachmentImpl(inputPart));
                }
                return attachments;
            }
            if (genericType instanceof ParameterizedType && ((ParameterizedType)genericType).getActualTypeArguments()[0].getTypeName().equals(String.class.getName())) {
                ArrayList<Object> parts = new ArrayList<Object>();
                for (InputPart inputPart : multiInput.getParts()) {
                    parts.add(inputPart.getBodyAsString());
                }
                return parts;
            }
        }
        String genericTypeStr = genericType == null ? "null" : genericType.getTypeName();
        throw new InternalServerErrorException("Unexpected multipart type: " + clazz.getName() + " / " + genericTypeStr);
    }

    public void writeTo(List<Object> entities, Class<?> clazz, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream outputStream) throws IOException, WebApplicationException {
        MultipartOutput outputObj = new MultipartOutput();
        for (Object entity : entities) {
            if (entity instanceof IAttachment) {
                Object content;
                boolean java2SecurityEnabled;
                final IAttachment attachment = (IAttachment)entity;
                boolean bl = java2SecurityEnabled = System.getSecurityManager() != null;
                if (java2SecurityEnabled) {
                    try {
                        content = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                            static final long serialVersionUID = -785119853563966271L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public Object run() throws Exception {
                                return attachment.getDataHandler().getContent();
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.multipart.IBMMultipartListProvider$1", 1.class, null, null);
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw new RuntimeException(pae);
                    }
                } else {
                    content = attachment.getDataHandler().getContent();
                }
                OutputPart part = outputObj.addPart(content, content.getClass(), null, attachment.getContentType(), ((IAttachmentImpl)attachment).getFileName());
                attachment.getHeaders().entrySet().stream().forEach(entry -> part.getHeaders().put((Object)((String)entry.getKey()), (Object)((List)entry.getValue())));
                continue;
            }
            throw new WebApplicationException("Unexpected entity instance: " + entity.getClass().getName());
        }
        this.writer.init();
        this.writer.writeTo(outputObj, clazz, genericType, anns, mt, headers, outputStream);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.multipart.IBMMultipartListProvider", IBMMultipartListProvider.class, null, null);
        MULTIPART_CLASSES = new HashSet();
        MULTIPART_SUBTYPES = new HashSet<String>();
        MULTIPART_CLASSES.add(IMultipartBody.class);
        MULTIPART_CLASSES.add(IAttachment.class);
        MULTIPART_SUBTYPES.add("form-data");
        MULTIPART_SUBTYPES.add("mixed");
        MULTIPART_SUBTYPES.add("related");
        MULTIPART_SUBTYPES.add("alternative");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    class LibertyMultipartWriter
    extends MultipartWriter {
        static final long serialVersionUID = 8821719229802376555L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        LibertyMultipartWriter() {
        }

        void init() {
            this.workers = IBMMultipartListProvider.this.providers;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.multipart.IBMMultipartListProvider$LibertyMultipartWriter", LibertyMultipartWriter.class, null, null);
        }
    }
}

