/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.plugins.providers.multipart.HeaderFlushedAsyncOutputStream;
import org.jboss.resteasy.plugins.providers.multipart.HeaderFlushedOutputStream;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.util.DelegatingOutputStream;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class AbstractMultipartWriter {
    protected static final byte[] DOUBLE_DASH_BYTES;
    protected static final byte[] LINE_SEPARATOR_BYTES;
    protected static final byte[] COLON_SPACE_BYTES;
    @Context
    protected Providers workers;
    static final long serialVersionUID = -6113953855125567482L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Deprecated
    protected void write(MultipartOutput multipartOutput, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        this.write(multipartOutput, mediaType, httpHeaders, entityStream, null);
    }

    protected void write(MultipartOutput multipartOutput, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream, Annotation[] annotations) throws IOException {
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (boundary == null) {
            boundary = multipartOutput.getBoundary();
        }
        httpHeaders.putSingle((Object)"Content-Type", (Object)(mediaType + "; boundary=" + multipartOutput.getBoundary()));
        byte[] boundaryBytes = ("--" + boundary).getBytes(StandardCharsets.US_ASCII);
        this.writeParts(multipartOutput, entityStream, boundaryBytes, annotations);
        entityStream.write(boundaryBytes);
        entityStream.write(DOUBLE_DASH_BYTES);
    }

    @Deprecated
    protected void writeParts(MultipartOutput multipartOutput, OutputStream entityStream, byte[] boundaryBytes) throws IOException {
        this.writeParts(multipartOutput, entityStream, boundaryBytes, null);
    }

    protected void writeParts(MultipartOutput multipartOutput, OutputStream entityStream, byte[] boundaryBytes, Annotation[] annotations) throws IOException {
        for (OutputPart part : multipartOutput.getParts()) {
            MultivaluedMapImpl<String, Object> headers = new MultivaluedMapImpl<String, Object>();
            this.writePart(entityStream, boundaryBytes, part, headers, annotations);
        }
    }

    @Deprecated
    protected void writePart(OutputStream entityStream, byte[] boundaryBytes, OutputPart part, MultivaluedMap<String, Object> headers) throws IOException {
        this.writePart(entityStream, boundaryBytes, part, headers, null);
    }

    protected void writePart(OutputStream entityStream, byte[] boundaryBytes, OutputPart part, MultivaluedMap<String, Object> headers, Annotation[] annotations) throws IOException {
        entityStream.write(boundaryBytes);
        entityStream.write(LINE_SEPARATOR_BYTES);
        headers.putAll(part.getHeaders());
        headers.putSingle((Object)"Content-Type", (Object)part.getMediaType());
        Object entity = part.getEntity();
        Class<?> entityType = part.getType();
        Type entityGenericType = part.getGenericType();
        MessageBodyWriter writer = this.workers.getMessageBodyWriter(entityType, entityGenericType, annotations, part.getMediaType());
        LogMessages.LOGGER.debugf("MessageBodyWriter: %s", writer.getClass().getName());
        DelegatingOutputStream partStream = new DelegatingOutputStream(entityStream){
            static final long serialVersionUID = 4757112781792016415L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void close() {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.multipart.AbstractMultipartWriter$1", 1.class, null, null);
            }
        };
        HeaderFlushedOutputStream headerFlushedOutputStream = new HeaderFlushedOutputStream(headers, partStream);
        writer.writeTo(entity, entityType, entityGenericType, annotations, part.getMediaType(), headers, (OutputStream)headerFlushedOutputStream);
        headerFlushedOutputStream.flushHeaders();
        entityStream.write(LINE_SEPARATOR_BYTES);
    }

    @Deprecated
    protected CompletionStage<Void> asyncWrite(MultipartOutput multipartOutput, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        return this.asyncWrite(multipartOutput, mediaType, httpHeaders, entityStream, null);
    }

    protected CompletionStage<Void> asyncWrite(MultipartOutput multipartOutput, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream, Annotation[] annotations) {
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (boundary == null) {
            boundary = multipartOutput.getBoundary();
        }
        httpHeaders.putSingle((Object)"Content-Type", (Object)(mediaType + "; boundary=" + multipartOutput.getBoundary()));
        byte[] boundaryBytes = ("--" + boundary).getBytes(StandardCharsets.US_ASCII);
        return this.asyncWriteParts(multipartOutput, entityStream, boundaryBytes, annotations).thenCompose(v -> entityStream.asyncWrite(boundaryBytes)).thenCompose(v -> entityStream.asyncWrite(DOUBLE_DASH_BYTES));
    }

    @Deprecated
    protected CompletionStage<Void> asyncWriteParts(MultipartOutput multipartOutput, AsyncOutputStream entityStream, byte[] boundaryBytes) {
        return this.asyncWriteParts(multipartOutput, entityStream, boundaryBytes, null);
    }

    protected CompletionStage<Void> asyncWriteParts(MultipartOutput multipartOutput, AsyncOutputStream entityStream, byte[] boundaryBytes, Annotation[] annotations) {
        CompletionStage<Object> ret = CompletableFuture.completedFuture(null);
        for (OutputPart part : multipartOutput.getParts()) {
            MultivaluedMapImpl headers = new MultivaluedMapImpl();
            ret = ret.thenCompose(v -> this.asyncWritePart(entityStream, boundaryBytes, part, headers, annotations));
        }
        return ret;
    }

    @Deprecated
    protected CompletionStage<Void> asyncWritePart(AsyncOutputStream entityStream, byte[] boundaryBytes, OutputPart part, MultivaluedMap<String, Object> headers) {
        return this.asyncWritePart(entityStream, boundaryBytes, part, headers, null);
    }

    protected CompletionStage<Void> asyncWritePart(AsyncOutputStream entityStream, byte[] boundaryBytes, OutputPart part, MultivaluedMap<String, Object> headers, Annotation[] annotations) {
        Function<Void, CompletionStage> writeFunction;
        headers.putAll(part.getHeaders());
        headers.putSingle((Object)"Content-Type", (Object)part.getMediaType());
        Object entity = part.getEntity();
        Class<?> entityType = part.getType();
        Type entityGenericType = part.getGenericType();
        MessageBodyWriter writer = this.workers.getMessageBodyWriter(entityType, entityGenericType, annotations, part.getMediaType());
        LogMessages.LOGGER.debugf("MessageBodyWriter: %s", writer.getClass().getName());
        if (writer instanceof AsyncMessageBodyWriter) {
            writeFunction = unused -> ((AsyncMessageBodyWriter)writer).asyncWriteTo(entity, entityType, entityGenericType, annotations, part.getMediaType(), headers, new HeaderFlushedAsyncOutputStream(headers, entityStream));
        } else {
            LogMessages.LOGGER.debugf("MessageBodyWriter %s is not asynchronous.", writer.getClass().getName());
            writeFunction = unused -> {
                try {
                    writer.writeTo(entity, entityType, entityGenericType, annotations, part.getMediaType(), headers, (OutputStream)new HeaderFlushedAsyncOutputStream(headers, entityStream));
                    return CompletableFuture.completedFuture(null);
                }
                catch (IOException e) {
                    return ProviderHelper.completedException(e);
                }
            };
        }
        return entityStream.asyncWrite(boundaryBytes).thenCompose(v -> entityStream.asyncWrite(LINE_SEPARATOR_BYTES)).thenCompose(writeFunction).thenCompose(v -> entityStream.asyncWrite(LINE_SEPARATOR_BYTES));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.multipart.AbstractMultipartWriter", AbstractMultipartWriter.class, null, null);
        DOUBLE_DASH_BYTES = "--".getBytes(StandardCharsets.US_ASCII);
        LINE_SEPARATOR_BYTES = "\r\n".getBytes(StandardCharsets.US_ASCII);
        COLON_SPACE_BYTES = ": ".getBytes(StandardCharsets.US_ASCII);
    }
}

