/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.threading.CompletionStageExecutor;
import io.openliberty.restfulWS.client.internal.AsyncClientExecutorHelper;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class AsyncClientExecutorService
implements ExecutorService {
    private final ExecutorService delegate;
    static final long serialVersionUID = 674894281780567339L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AsyncClientExecutorService(ExecutorService delegate) {
        this.delegate = delegate;
    }

    private <T> Collection<? extends Callable<T>> wrapTasks(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(AsyncClientExecutorHelper::wrap).collect(Collectors.toList());
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(AsyncClientExecutorHelper.wrap(command));
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(AsyncClientExecutorHelper.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(AsyncClientExecutorHelper.wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(AsyncClientExecutorHelper.wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapTasks(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapTasks(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrapTasks(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrapTasks(tasks), timeout, unit);
    }

    ExecutorService getDelegate() {
        ExecutorService delegate = this.delegate;
        if (delegate == null) {
            throw Messages.MESSAGES.executorShutdown();
        }
        return delegate;
    }

    public <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        ExecutorService executor = this.getDelegate();
        if (executor instanceof CompletionStageExecutor) {
            return ((CompletionStageExecutor)executor).supplyAsync(AsyncClientExecutorHelper.wrap(supplier));
        }
        return CompletableFuture.supplyAsync(supplier, this);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS.client.AsyncClientExecutorService", AsyncClientExecutorService.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
    }
}

