/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.org.jboss.resteasy.common.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
class OsgiFacade {
    private static final boolean isSecurityManagerPresent;
    private static final Map<Integer, Tuple<?>> tupleMap;
    private static final AtomicInteger counter;
    static final long serialVersionUID = -2582714269383039685L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    OsgiFacade() {
    }

    static Optional<OsgiFacade> instance() {
        try {
            Class.forName("org.osgi.framework.Bundle");
            return Optional.of(new OsgiFacade());
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    <T> Optional<ServiceReference<T>> getServiceRef(Class<T> serviceClass) {
        BundleContext ctx = this.getBundleContext();
        if (ctx == null) {
            return Optional.empty();
        }
        if (isSecurityManagerPresent) {
            try {
                return Optional.ofNullable(AccessController.doPrivileged(() -> ctx.getServiceReference(serviceClass)));
            }
            catch (PrivilegedActionException e) {
                return Optional.empty();
            }
        }
        return Optional.ofNullable(ctx.getServiceReference(serviceClass));
    }

    <T> T getService(Object serviceRef, Class<T> serviceClass) {
        return serviceClass.cast(this.getService(this.getBundleContext(), (ServiceReference)serviceRef));
    }

    void ungetService(Object o) {
        if (o instanceof ServiceReference) {
            this.getBundleContext().ungetService((ServiceReference)o);
        }
    }

    <T> Integer invoke(Class<T> service, Consumer<T> consumer) {
        BundleContext ctx = this.getBundleContext();
        Tuple tuple = new Tuple(ctx, this.getServiceRefs(service, ctx).orElse(Collections.emptyList()));
        tuple.serviceRefs.stream().map(sr -> this.getService(tuple.bundleCtx, (ServiceReference)sr)).forEach(consumer);
        Integer key = counter.incrementAndGet();
        tupleMap.put(key, tuple);
        return key;
    }

    <T> void invoke(Integer key, Class<T> clz, Consumer<T> consumer) {
        Tuple<?> tuple = tupleMap.remove(key);
        tuple.serviceRefs.stream().map(sr -> this.getService(tuple.bundleCtx, (ServiceReference)sr)).forEach(consumer);
    }

    private BundleContext getBundleContext() {
        if (isSecurityManagerPresent) {
            return AccessController.doPrivileged(() -> {
                Bundle b = FrameworkUtil.getBundle(this.getClass());
                return b == null ? null : b.getBundleContext();
            });
        }
        Bundle b = FrameworkUtil.getBundle(this.getClass());
        return b == null ? null : b.getBundleContext();
    }

    private <T> Optional<List<ServiceReference<T>>> getServiceRefs(Class<T> serviceClass, BundleContext ctx) {
        if (ctx == null) {
            return Optional.empty();
        }
        try {
            ServiceReference[] serviceRefs = isSecurityManagerPresent ? AccessController.doPrivileged(() -> ctx.getServiceReferences(serviceClass.getName(), null)) : ctx.getServiceReferences(serviceClass.getName(), null);
            return Optional.ofNullable(serviceRefs == null ? null : Arrays.asList(serviceRefs));
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T getService(BundleContext ctx, ServiceReference<T> ref) {
        if (isSecurityManagerPresent) {
            return (T)AccessController.doPrivileged(() -> ctx.getService(ref));
        }
        return (T)ctx.getService(ref);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.org.jboss.resteasy.common.client.OsgiFacade", OsgiFacade.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
        isSecurityManagerPresent = null != System.getSecurityManager();
        tupleMap = new ConcurrentHashMap();
        counter = new AtomicInteger(0);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    class Tuple<T> {
        final BundleContext bundleCtx;
        final List<ServiceReference<T>> serviceRefs;
        static final long serialVersionUID = -8553027430673975362L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        Tuple(BundleContext bundleCtx, List<ServiceReference<T>> serviceRefs) {
            this.bundleCtx = bundleCtx;
            this.serviceRefs = serviceRefs;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.org.jboss.resteasy.common.client.OsgiFacade$Tuple", Tuple.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
        }
    }
}

