/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.intfc.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.intfc.WSSecurityService;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSSecurityServiceImpl
implements WSSecurityService {
    private static final TraceComponent tc = Tr.register(WSSecurityServiceImpl.class, null, null);
    static final String KEY_SECURITY_SERVICE = "securityService";
    private final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    static final long serialVersionUID = 6891994471518399277L;

    protected void setSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.setReference(reference);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
    }

    protected void activate(ComponentContext cc) {
        this.securityServiceRef.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.securityServiceRef.deactivate(cc);
    }

    public boolean isSecurityEnabled() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public com.ibm.websphere.security.UserRegistry getUserRegistry(String realmName) throws WSSecurityException {
        String METHOD = "getUserRegistry";
        com.ibm.websphere.security.UserRegistry userRegistry = this.getActiveUserRegistry();
        if (userRegistry != null) {
            try {
                if (realmName != null && !realmName.equals(userRegistry.getRealm())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getUserRegistry Supplied realm not valid: " + realmName), (Object[])new Object[0]);
                    }
                    userRegistry = null;
                }
            }
            catch (RemoteException remoteException) {
                void e;
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.security.intfc.internal.WSSecurityServiceImpl", (String)"77", (Object)this, (Object[])new Object[]{realmName});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getUserRegistry Internal error getting current registry realm", (Object[])new Object[]{e});
                }
                throw new WSSecurityException("Internal error getting realm", (Throwable)e);
            }
        }
        return userRegistry;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getInboundTrustedRealms(String realmName) throws WSSecurityException {
        String METHOD = "getInboundTrustedRealms";
        ArrayList<String> trustedRealmList = new ArrayList<String>();
        com.ibm.websphere.security.UserRegistry userRegistry = this.getActiveUserRegistry();
        if (userRegistry != null) {
            try {
                if (realmName != null && !realmName.equals(userRegistry.getRealm())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getInboundTrustedRealms Supplied realm not valid: " + realmName), (Object[])new Object[0]);
                    }
                } else {
                    trustedRealmList.add(userRegistry.getRealm());
                }
            }
            catch (RemoteException remoteException) {
                void e;
                FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.security.intfc.internal.WSSecurityServiceImpl", (String)"102", (Object)this, (Object[])new Object[]{realmName});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getInboundTrustedRealms Internal error getting current registry realm", (Object[])new Object[]{e});
                }
                throw new WSSecurityException("Internal error getting realm", (Throwable)e);
            }
        }
        return trustedRealmList;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isRealmInboundTrusted(String inboundRealm, String localRealm) {
        boolean trusted;
        block9: {
            String METHOD = "isRealmInboundTrusted";
            if (inboundRealm == null) {
                return false;
            }
            trusted = true;
            try {
                com.ibm.websphere.security.UserRegistry userRegistry = this.getActiveUserRegistry();
                if (userRegistry != null) {
                    if (localRealm != null && !localRealm.equals(userRegistry.getRealm())) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("isRealmInboundTrusted Local realm not valid: " + localRealm), (Object[])new Object[0]);
                        }
                        trusted = false;
                    } else if (!inboundRealm.equals(userRegistry.getRealm())) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"isRealmInboundTrusted Inbound realm not trusted", (Object[])new Object[0]);
                        }
                        trusted = false;
                    }
                }
            }
            catch (Exception userRegistry) {
                void e;
                FFDCFilter.processException((Throwable)userRegistry, (String)"com.ibm.ws.security.intfc.internal.WSSecurityServiceImpl", (String)"141", (Object)this, (Object[])new Object[]{inboundRealm, localRealm});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)"isRealmInboundTrusted Internal error", (Object[])new Object[]{e});
            }
        }
        return trusted;
    }

    /*
     * WARNING - void declaration
     */
    private com.ibm.websphere.security.UserRegistry getActiveUserRegistry() throws WSSecurityException {
        String METHOD = "getActiveUserRegistry";
        com.ibm.websphere.security.UserRegistry activeUserRegistry = null;
        try {
            SecurityService ss;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getActiveUserRegistry securityServiceRef " + this.securityServiceRef), (Object[])new Object[0]);
            }
            if ((ss = (SecurityService)this.securityServiceRef.getService()) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getActiveUserRegistry No SecurityService, returning null", (Object[])new Object[0]);
                }
            } else {
                UserRegistryService urs = ss.getUserRegistryService();
                if (urs == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"getActiveUserRegistry No UserRegistryService, returning null", (Object[])new Object[0]);
                    }
                } else if (urs.isUserRegistryConfigured()) {
                    UserRegistry userRegistry = urs.getUserRegistry();
                    activeUserRegistry = urs.getExternalUserRegistry(userRegistry);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getActiveUserRegistry Security enabled but no registry configured", (Object[])new Object[0]);
                }
            }
        }
        catch (RegistryException ss) {
            void e;
            FFDCFilter.processException((Throwable)ss, (String)"com.ibm.ws.security.intfc.internal.WSSecurityServiceImpl", (String)"187", (Object)this, (Object[])new Object[0]);
            String msg = "getActiveUserRegistry failed due to an internal error: " + e.getMessage();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[]{e});
            }
            throw new WSSecurityException(msg, (Throwable)e);
        }
        catch (IllegalStateException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.intfc.internal.WSSecurityServiceImpl", (String)"193", (Object)this, (Object[])new Object[0]);
            String msg = "getActiveUserRegistry failed due to an internal error: " + e.getMessage();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[]{e});
            }
            throw new WSSecurityException(msg, (Throwable)e);
        }
        return activeUserRegistry;
    }
}

