/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.AnnotatedEndpoint;
import com.ibm.ws.wsoc.external.SessionExt;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EndpointManager {
    private static final TraceComponent tc = Tr.register(EndpointManager.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    private final ConcurrentHashMap<String, ServerEndpointConfig> serverEndpointConfigMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends Object>, AnnotatedEndpoint> annotatedEndpointMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, ArrayList<Session>> endpointSessionMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ArrayList<Session>> httpSessionMap = new ConcurrentHashMap();
    private static final Comparator<String[]> COMPARATOR = new Comparator<String[]>(){
        static final long serialVersionUID = -7163493055544483069L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public int compare(String[] endpoint1Parts, String[] endpoint2Parts) {
            for (int i = 1; i < endpoint1Parts.length; ++i) {
                boolean var2;
                boolean var1 = endpoint1Parts[i].startsWith("{") && endpoint1Parts[i].endsWith("}");
                boolean bl = var2 = endpoint2Parts[i].startsWith("{") && endpoint2Parts[i].endsWith("}");
                if (var1 != var2) {
                    return var1 ? 1 : -1;
                }
                int compare = endpoint1Parts[i].compareTo(endpoint2Parts[i]);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.EndpointManager$1", 1.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
        }
    };
    static final long serialVersionUID = 1285622753007574981L;

    public EndpointManager() {
        this.serverEndpointConfigMap.clear();
    }

    public void clear() {
        this.serverEndpointConfigMap.clear();
        this.annotatedEndpointMap.clear();
    }

    public synchronized void addSession(Endpoint ep, SessionExt sess) {
        ArrayList<Object> sa;
        Class<?> cl = ep.getClass();
        if (cl.equals(AnnotatedEndpoint.class)) {
            AnnotatedEndpoint ae = (AnnotatedEndpoint)ep;
            cl = ae.getServerEndpointClass();
        }
        if ((sa = this.endpointSessionMap.get(cl)) == null) {
            sa = new ArrayList();
        }
        sa.add(sess);
        this.endpointSessionMap.put(cl, sa);
        String id = sess.getSessionImpl().getHttpSessionID();
        if (id != null) {
            ArrayList<Object> http_sa = this.httpSessionMap.get(id);
            if (http_sa == null) {
                http_sa = new ArrayList();
            }
            http_sa.add(sess);
            this.httpSessionMap.put(id, http_sa);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("added session of: " + sess + " id=" + id + "  to endpoint class of: " + cl + " using list of: " + sa + " in endpointmanager of: " + this), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("[add] httpSessionMap count: " + this.httpSessionMap.size() + " in endpointmanager of: " + this), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("[add] active websocket session count: " + sa.size() + " in endpointmanager of: " + this), (Object[])new Object[0]);
        }
    }

    public synchronized void closeAllOpenSessions() {
        CloseReason cr = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Application shutting down.");
        Set<Map.Entry<Class<?>, ArrayList<Session>>> s = this.endpointSessionMap.entrySet();
        for (Map.Entry<Class<?>, ArrayList<Session>> e : s) {
            ArrayList<Session> sessions = e.getValue();
            while (!sessions.isEmpty()) {
                Session sess = sessions.remove(0);
                SessionExt ext = (SessionExt)sess;
                ext.getSessionImpl().closeBecauseAppStopping(cr);
            }
        }
    }

    public synchronized void removeSession(Endpoint ep, SessionExt sess) {
        ArrayList<Session> sa;
        String id;
        Class<?> cl = ep.getClass();
        if (cl.equals(AnnotatedEndpoint.class)) {
            AnnotatedEndpoint ae = (AnnotatedEndpoint)ep;
            cl = ae.getServerEndpointClass();
        }
        if ((id = sess.getSessionImpl().getHttpSessionID()) != null) {
            this.httpSessionMap.remove(id);
        }
        if ((sa = this.endpointSessionMap.get(cl)) == null) {
            return;
        }
        sa.remove(sess);
        this.endpointSessionMap.put(cl, sa);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removed session of: " + sess.getId() + " from endpoint class of: " + cl.getName() + " in endpointmanager of: " + this), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("[remove] httpSessionMap count: " + this.httpSessionMap.size() + " in endpointmanager of: " + this), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("[remove] active websocket session count: " + sa.size() + " in endpointmanager of: " + this), (Object[])new Object[0]);
        }
    }

    public synchronized Set<Session> getOpenSessions(Endpoint ep) {
        ArrayList<Session> sa;
        Class<?> cl = ep.getClass();
        if (cl.equals(AnnotatedEndpoint.class)) {
            AnnotatedEndpoint ae = (AnnotatedEndpoint)ep;
            cl = ae.getServerEndpointClass();
        }
        if ((sa = this.endpointSessionMap.get(cl)) == null) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getOpenSessions is using set of: " + sa.hashCode()), (Object[])new Object[0]);
        }
        HashSet<Session> set = new HashSet<Session>();
        set.addAll(sa);
        return set;
    }

    public void httpSessionExpired(String httpSessionID) {
        ArrayList<Session> sessionList;
        if (httpSessionID != null && (sessionList = this.httpSessionMap.remove(httpSessionID)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sessionList count: " + sessionList.size() + " for sessionId: " + httpSessionID), (Object[])new Object[0]);
            }
            for (Session session : sessionList) {
                ((SessionExt)session).getSessionImpl().markHttpSessionInvalid();
                if (!session.isSecure() || session.getUserPrincipal() == null) continue;
                CloseReason cr = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "Secure HTTP Session Closed");
                ((SessionExt)session).getSessionImpl().close(cr, true);
            }
            Set<Map.Entry<Class<?>, ArrayList<Session>>> s = this.endpointSessionMap.entrySet();
            Iterator<Map.Entry<Class<?>, ArrayList<Session>>> i = s.iterator();
            Class<?> endPointKey = null;
            block1: while (i.hasNext()) {
                Map.Entry<Class<?>, ArrayList<Session>> e = i.next();
                for (Session session : sessionList) {
                    if (!e.getValue().contains(session)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("endPointKey key found: " + endPointKey + " in endpointmanager of: " + this), (Object[])new Object[0]);
                    }
                    endPointKey = e.getKey();
                    continue block1;
                }
            }
            if (endPointKey != null) {
                ArrayList<Session> http_sa = this.endpointSessionMap.get(endPointKey);
                for (Session session : sessionList) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("removing session from http_sa: " + session), (Object[])new Object[0]);
                    }
                    http_sa.remove(session);
                }
                this.endpointSessionMap.put(endPointKey, http_sa);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("removed expired session of: " + httpSessionID + "  from endpoint class of: " + endPointKey.getName() + " with list " + http_sa + " in endpointmanager of: " + this), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("[expire] httpSessionMap count: " + this.httpSessionMap.size() + " in endpointmanager of: " + this), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("[expire] active websocket session count: " + http_sa.size() + " in endpointmanager of: " + this), (Object[])new Object[0]);
                }
            }
        }
    }

    public void addAnnotatedEndpoint(AnnotatedEndpoint annotatedEP) {
        if (annotatedEP != null) {
            this.annotatedEndpointMap.put(annotatedEP.getServerEndpointClass(), annotatedEP);
        }
    }

    public AnnotatedEndpoint getAnnotatedEndpoint(Class<? extends Object> aep) {
        if (aep != null) {
            return this.annotatedEndpointMap.get(aep);
        }
        return null;
    }

    public void addServerEndpointConfig(ServerEndpointConfig serverEndpointConfig) {
        String path = serverEndpointConfig.getPath();
        if (path != null) {
            Tr.info((TraceComponent)tc, (String)"adding.endpoint", (Object[])new Object[]{path});
            this.serverEndpointConfigMap.put(path, serverEndpointConfig);
        }
    }

    public boolean isURIExists(String path) {
        return ((ConcurrentHashMap.KeySetView)this.serverEndpointConfigMap.keySet()).contains(path);
    }

    public ServerEndpointConfig getServerEndpointConfig(String path) {
        String matchedURI = null;
        ServerEndpointConfig config = null;
        if (((ConcurrentHashMap.KeySetView)this.serverEndpointConfigMap.keySet()).contains(path)) {
            matchedURI = path;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found a exact URI match of: " + matchedURI), (Object[])new Object[0]);
            }
        } else {
            matchedURI = this.getMatchingURI(path);
        }
        if (matchedURI != null) {
            config = this.serverEndpointConfigMap.get(matchedURI);
        }
        return config;
    }

    private synchronized String getMatchingURI(String incomingURI) {
        String[] incomingURIParts = incomingURI.split("/");
        ArrayList<Object> tockenizedEndpoints = new ArrayList<Object>();
        for (String endpointURI : this.serverEndpointConfigMap.keySet()) {
            if (incomingURIParts.length != endpointURI.split("/").length) continue;
            tockenizedEndpoints.add(endpointURI.split("/"));
        }
        for (int i = 1; i < incomingURIParts.length; ++i) {
            ArrayList<String[]> matchedURIs = new ArrayList<String[]>();
            for (int j = 0; j < tockenizedEndpoints.size(); ++j) {
                String[] tockens = (String[])tockenizedEndpoints.get(j);
                if (incomingURIParts[i].equals(tockens[i])) {
                    matchedURIs.add((String[])tockenizedEndpoints.get(j));
                }
                if (!tockens[i].startsWith("{") || !tockens[i].endsWith("}")) continue;
                matchedURIs.add((String[])tockenizedEndpoints.get(j));
            }
            tockenizedEndpoints.clear();
            tockenizedEndpoints.addAll(matchedURIs);
        }
        if (tockenizedEndpoints.size() > 1) {
            Collections.sort(tockenizedEndpoints, COMPARATOR);
        }
        String[] tockenizedEndpoint = null;
        if (!tockenizedEndpoints.isEmpty()) {
            tockenizedEndpoint = (String[])tockenizedEndpoints.get(0);
        }
        if (tockenizedEndpoint != null) {
            return this.unTockenizeEp(tockenizedEndpoint);
        }
        return null;
    }

    private String unTockenizeEp(String[] tockenizedEp) {
        String delimiter = "/";
        StringBuffer buffer = new StringBuffer();
        for (String part : tockenizedEp) {
            if (part.isEmpty()) continue;
            buffer.append(delimiter + part);
        }
        return buffer.toString();
    }

    public void httpSessionIdChanged(String newSessionId, String oldSessionId) {
        ArrayList<Session> sessionList = this.httpSessionMap.remove(oldSessionId);
        if (sessionList != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("changing key of httpSessionMap from " + oldSessionId + " to " + newSessionId + " within " + this), (Object[])new Object[0]);
            }
            this.httpSessionMap.put(newSessionId, sessionList);
        }
    }
}

