/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.PolicyException;

public class PolicyVerificationOutInterceptor
extends AbstractPolicyInterceptor {
    public static final PolicyVerificationOutInterceptor INSTANCE = new PolicyVerificationOutInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyVerificationOutInterceptor.class);

    public PolicyVerificationOutInterceptor() {
        super("post-stream");
    }

    @Override
    protected void handle(Message message) {
        boolean isFineEnabled = LOG.isLoggable(Level.FINE);
        if (MessageUtils.isPartialResponse((Message)message)) {
            if (isFineEnabled) {
                LOG.fine("Not verifying policies on outbound partial response.");
            }
            return;
        }
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (null == aim) {
            if (isFineEnabled) {
                LOG.fine("AssertionInfoMap is null.");
            }
            return;
        }
        this.getTransportAssertions(message);
        EffectivePolicy policy = (EffectivePolicy)message.get(EffectivePolicy.class);
        if (policy == null) {
            if (isFineEnabled) {
                LOG.fine("EffectivePolicy is null.");
            }
            return;
        }
        try {
            aim.checkEffectivePolicy(policy.getPolicy());
        }
        catch (PolicyException e) {
            if (isFineEnabled) {
                LOG.fine("An exception was thrown when verifying that the effective policy for this request was satisfied.  However, this exception will not result in a fault.  The exception raised is: " + e.toString());
            }
            return;
        }
        if (isFineEnabled) {
            LOG.fine("Verified policies for outbound message.");
        }
    }
}

