/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.apache.cxf.transport.http.osgi.HttpConduitConfigApplier;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
class ConfigAdminHttpConduitConfigurer
implements ManagedServiceFactory,
HTTPConduitConfigurer {
    public static final String FACTORY_PID = "org.apache.cxf.http.conduits";
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigAdminHttpConduitConfigurer.class);
    Map<String, PidInfo> props;
    CopyOnWriteArrayList<PidInfo> sorted;
    static final long serialVersionUID = -2181650433047129364L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    ConfigAdminHttpConduitConfigurer() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "<init>", new Object[0]);
        }
        this.props = new ConcurrentHashMap<String, PidInfo>(4, 0.75f, 2);
        this.sorted = new CopyOnWriteArrayList();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "getName", new Object[0]);
        }
        String string = FACTORY_PID;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "getName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "updated", new Object[]{pid, properties});
        }
        if (pid == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "updated");
            }
            return;
        }
        this.deleted(pid);
        String url = (String)properties.get("url");
        String name = (String)properties.get("name");
        Matcher matcher = url == null ? null : Pattern.compile(url).matcher("");
        String p = (String)properties.get("order");
        int order = 50;
        if (p != null) {
            order = Integer.parseInt(p);
        }
        PidInfo info = new PidInfo(properties, matcher, order);
        this.props.put(pid, info);
        if (url != null) {
            this.props.put(url, info);
        }
        if (name != null) {
            this.props.put(name, info);
        }
        if (matcher != null) {
            LOG.finest("Matcher is not null, add to sorted list");
            this.addToSortedInfos(info);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "updated");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private synchronized void addToSortedInfos(PidInfo pi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "addToSortedInfos", new Object[]{pi});
        }
        int size = this.sorted.size();
        for (int x = 0; x < size; ++x) {
            PidInfo p = this.sorted.get(x);
            if (pi.compareTo(p) >= 0) continue;
            this.sorted.add(x, pi);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "addToSortedInfos");
            }
            return;
        }
        this.sorted.add(pi);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "addToSortedInfos");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private synchronized void removeFromSortedInfos(PidInfo pi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "removeFromSortedInfos", new Object[]{pi});
        }
        this.sorted.remove(pi);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "removeFromSortedInfos");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void deleted(String pid) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "deleted", new Object[]{pid});
        }
        PidInfo info = this.props.remove(pid);
        if (info == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "deleted");
            }
            return;
        }
        this.removeFromSortedInfos(info);
        Dictionary<String, String> d = info.getProps();
        if (d != null) {
            String url = d.get("url");
            String name = d.get("name");
            if (url != null) {
                this.props.remove(url);
            }
            if (name != null) {
                this.props.remove(name);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "deleted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void configure(String name, String address, HTTPConduit c) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "configure", new Object[]{name, address, c});
        }
        PidInfo byName = null;
        PidInfo byAddress = null;
        if (name != null) {
            byName = this.props.get(name);
        }
        if (address != null && (byAddress = this.props.get(address)) == byName) {
            byAddress = null;
        }
        HttpConduitConfigApplier applier = new HttpConduitConfigApplier();
        for (PidInfo info : this.sorted) {
            Matcher m;
            if (info.getMatcher() == null || info == byName || info == byAddress) continue;
            Matcher matcher = m = info.getMatcher();
            synchronized (matcher) {
                m.reset(address);
                if (m.matches()) {
                    applier.apply(info.getProps(), c, address);
                }
            }
        }
        if (byAddress != null) {
            applier.apply(byAddress.getProps(), c, address);
        }
        if (byName != null) {
            applier.apply(byName.getProps(), c, address);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer", "configure");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class PidInfo
    implements Comparable<PidInfo> {
        final Dictionary<String, String> props;
        final Matcher matcher;
        final int order;
        static final long serialVersionUID = 3289004021268604553L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        PidInfo(Dictionary<String, String> p, Matcher m, int o) {
            this.matcher = m;
            this.props = p;
            this.order = o;
        }

        public Dictionary<String, String> getProps() {
            return this.props;
        }

        public Matcher getMatcher() {
            return this.matcher;
        }

        @Override
        public int compareTo(PidInfo o) {
            if (this.order < o.order) {
                return -1;
            }
            if (this.order > o.order) {
                return 1;
            }
            if (this.matcher != null) {
                if (o.matcher == null) {
                    return -1;
                }
                return this.matcher.pattern().toString().compareTo(o.matcher.pattern().toString());
            }
            return 0;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer$PidInfo", PidInfo.class, null, null);
        }
    }
}

