/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry20.internal.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.microprofile.telemetry.internal.common.AgentDetection;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoInternal;
import io.openliberty.microprofile.telemetry.internal.common.rest.AbstractTelemetryContainerFilter;
import io.openliberty.microprofile.telemetry.internal.common.rest.RestRouteCache;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryAccessor;
import io.openliberty.microprofile.telemetry20.logging.internal.semconv.SemcovConstantsAccessor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@Provider
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TelemetryContainerFilter
extends AbstractTelemetryContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final ServiceCaller<SemcovConstantsAccessor> semcovConstantsAccessorCaller;
    private static final AttributeKey<String> SEMCOV_HTTP_ROUTE;
    private static final String INSTRUMENTATION_NAME = "io.openliberty.microprofile.telemetry";
    private static final String REST_RESOURCE_CLASS = "rest.resource.class";
    private static final String REST_RESOURCE_METHOD = "rest.resource.method";
    private static final String SPAN_CONTEXT = "otel.span.server.context";
    private static final String SPAN_PARENT_CONTEXT = "otel.span.server.parentContext";
    private static final HttpServerAttributesGetterImpl HTTP_SERVER_ATTRIBUTES_GETTER;
    private static final RestRouteCache ROUTE_CACHE;
    private Instrumenter<ContainerRequestContext, ContainerResponseContext> instrumenter;
    private volatile boolean lazyCreate = false;
    private final AtomicReference<Instrumenter<ContainerRequestContext, ContainerResponseContext>> lazyInstrumenter = new AtomicReference();
    @jakarta.ws.rs.core.Context
    private ResourceInfo resourceInfo;
    static final long serialVersionUID = 1540876542174997365L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TelemetryContainerFilter() {
        if (!CheckpointPhase.getPhase().restored()) {
            this.lazyCreate = true;
        } else {
            this.instrumenter = this.createInstrumenter();
        }
    }

    private Instrumenter<ContainerRequestContext, ContainerResponseContext> getInstrumenter() {
        if (this.instrumenter != null) {
            return this.instrumenter;
        }
        if (this.lazyCreate) {
            this.instrumenter = this.lazyInstrumenter.updateAndGet(i -> {
                if (i == null) {
                    return this.createInstrumenter();
                }
                return i;
            });
            this.lazyCreate = false;
        }
        return this.instrumenter;
    }

    private Instrumenter<ContainerRequestContext, ContainerResponseContext> createInstrumenter() {
        OpenTelemetryInfoInternal openTelemetry = OpenTelemetryAccessor.getOpenTelemetryInfo();
        if (openTelemetry.isEnabled() && !AgentDetection.isAgentActive()) {
            InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry.getOpenTelemetry(), (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpServerAttributesGetter)HTTP_SERVER_ATTRIBUTES_GETTER));
            Instrumenter result = builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)HTTP_SERVER_ATTRIBUTES_GETTER)).addAttributesExtractor(HttpServerAttributesExtractor.create((HttpServerAttributesGetter)HTTP_SERVER_ATTRIBUTES_GETTER)).buildServerInstrumenter((TextMapGetter)new ContainerRequestContextTextMapGetter());
            return result;
        }
        return null;
    }

    public boolean isEnabled() {
        if (!CheckpointPhase.getPhase().restored()) {
            return true;
        }
        return this.getInstrumenter() != null;
    }

    public void filter(ContainerRequestContext request) {
        Instrumenter<ContainerRequestContext, ContainerResponseContext> currentInstrumenter = this.getInstrumenter();
        if (currentInstrumenter == null) {
            return;
        }
        Context parentContext = Context.current();
        if (currentInstrumenter.shouldStart(parentContext, (Object)request)) {
            request.setProperty(REST_RESOURCE_CLASS, (Object)this.resourceInfo.getResourceClass());
            request.setProperty(REST_RESOURCE_METHOD, (Object)this.resourceInfo.getResourceMethod());
            Context spanContext = currentInstrumenter.start(parentContext, (Object)request);
            Scope scope = spanContext.makeCurrent();
            request.setProperty(SPAN_CONTEXT, (Object)spanContext);
            request.setProperty(SPAN_PARENT_CONTEXT, (Object)parentContext);
            request.setProperty("otel.span.server.scope", (Object)scope);
        } else {
            Method resourceMethod;
            Class resourceClass;
            String route;
            Span currentSpan = Span.current();
            if (currentSpan != null && (route = TelemetryContainerFilter.getRoute(request, resourceClass = this.resourceInfo.getResourceClass(), resourceMethod = this.resourceInfo.getResourceMethod())) != null) {
                currentSpan.setAttribute(SEMCOV_HTTP_ROUTE, (Object)route);
                currentSpan.updateName(request.getMethod() + " " + route);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        Instrumenter<ContainerRequestContext, ContainerResponseContext> currentInstrumenter = this.getInstrumenter();
        if (currentInstrumenter == null) {
            return;
        }
        Context spanContext = (Context)request.getProperty(SPAN_CONTEXT);
        if (spanContext == null) {
            return;
        }
        try {
            currentInstrumenter.end(spanContext, (Object)request, (Object)response, null);
        }
        finally {
            request.removeProperty(REST_RESOURCE_CLASS);
            request.removeProperty(REST_RESOURCE_METHOD);
            request.removeProperty(SPAN_CONTEXT);
            request.removeProperty(SPAN_PARENT_CONTEXT);
        }
    }

    private static String getRoute(ContainerRequestContext request, Class<?> resourceClass, Method resourceMethod) {
        int checkResourceSize;
        String route = ROUTE_CACHE.getRoute(resourceClass, resourceMethod);
        if (route == null && (checkResourceSize = request.getUriInfo().getMatchedResources().size()) == 1) {
            String contextRoot = request.getUriInfo().getBaseUri().getPath();
            UriBuilder template = UriBuilder.fromPath((String)contextRoot);
            if (resourceClass.isAnnotationPresent(Path.class)) {
                template.path(resourceClass);
            }
            if (resourceMethod.isAnnotationPresent(Path.class)) {
                template.path(resourceMethod);
            }
            route = template.toTemplate();
            ROUTE_CACHE.putRoute(resourceClass, resourceMethod, route);
        }
        return route;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry20.internal.rest.TelemetryContainerFilter", TelemetryContainerFilter.class, (String)"TELEMETRY", null);
        semcovConstantsAccessorCaller = new ServiceCaller(TelemetryContainerFilter.class, SemcovConstantsAccessor.class);
        SEMCOV_HTTP_ROUTE = (AttributeKey)semcovConstantsAccessorCaller.run(SemcovConstantsAccessor::httpRoute).get();
        HTTP_SERVER_ATTRIBUTES_GETTER = new HttpServerAttributesGetterImpl();
        ROUTE_CACHE = new RestRouteCache();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class HttpServerAttributesGetterImpl
    implements HttpServerAttributesGetter<ContainerRequestContext, ContainerResponseContext> {
        static final long serialVersionUID = -112189768085779699L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private HttpServerAttributesGetterImpl() {
        }

        public String getHttpRoute(ContainerRequestContext request) {
            Class resourceClass = (Class)request.getProperty(TelemetryContainerFilter.REST_RESOURCE_CLASS);
            Method resourceMethod = (Method)request.getProperty(TelemetryContainerFilter.REST_RESOURCE_METHOD);
            return TelemetryContainerFilter.getRoute(request, resourceClass, resourceMethod);
        }

        public String getHttpRequestMethod(ContainerRequestContext request) {
            return request.getMethod();
        }

        public String getUrlPath(ContainerRequestContext request) {
            URI requestUri = request.getUriInfo().getRequestUri();
            String path = requestUri.getPath();
            return path;
        }

        public String getUrlQuery(ContainerRequestContext request) {
            URI requestUri = request.getUriInfo().getRequestUri();
            return requestUri.getQuery();
        }

        public String getUrlScheme(ContainerRequestContext request) {
            return request.getUriInfo().getRequestUri().getScheme();
        }

        public Integer getHttpResponseStatusCode(ContainerRequestContext request, ContainerResponseContext response, Throwable error) {
            return response.getStatus();
        }

        public List<String> getHttpRequestHeader(ContainerRequestContext request, String name) {
            return (List)request.getHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        public List<String> getHttpResponseHeader(ContainerRequestContext request, ContainerResponseContext response, String name) {
            return (List)response.getStringHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry20.internal.rest.TelemetryContainerFilter$HttpServerAttributesGetterImpl", HttpServerAttributesGetterImpl.class, (String)"TELEMETRY", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ContainerRequestContextTextMapGetter
    implements TextMapGetter<ContainerRequestContext> {
        static final long serialVersionUID = -5647806578199306283L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ContainerRequestContextTextMapGetter() {
        }

        public Iterable<String> keys(ContainerRequestContext carrier) {
            return carrier.getHeaders().keySet();
        }

        public String get(ContainerRequestContext carrier, String key) {
            if (carrier == null) {
                return null;
            }
            return (String)((List)carrier.getHeaders().getOrDefault((Object)key, Collections.singletonList(null))).get(0);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry20.internal.rest.TelemetryContainerFilter$ContainerRequestContextTextMapGetter", ContainerRequestContextTextMapGetter.class, (String)"TELEMETRY", null);
        }
    }
}

