/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.token;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.config.MetadataUtils;
import io.openliberty.security.oidcclientcore.config.OidcMetadataService;
import io.openliberty.security.oidcclientcore.exceptions.OidcClientConfigurationException;
import io.openliberty.security.oidcclientcore.exceptions.OidcDiscoveryException;
import io.openliberty.security.oidcclientcore.exceptions.TokenRequestException;
import io.openliberty.security.oidcclientcore.token.TokenRequestor;
import io.openliberty.security.oidcclientcore.token.TokenResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JakartaOidcTokenRequest {
    public static final TraceComponent tc = Tr.register(JakartaOidcTokenRequest.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    public static final String AUTH_RESULT_CUSTOM_PROP_TOKEN_RESPONSE = "TOKEN_RESPONSE";
    private final OidcClientConfig oidcClientConfig;
    private final HttpServletRequest request;
    static final long serialVersionUID = -35852638158989553L;

    public JakartaOidcTokenRequest(OidcClientConfig oidcClientConfig, HttpServletRequest request) {
        this.oidcClientConfig = oidcClientConfig;
        this.request = request;
    }

    public ProviderAuthenticationResult sendRequest() throws TokenRequestException {
        TokenResponse tokenEndpointResponse = this.sendTokenRequest();
        this.verifyTokenResponseContainsRequiredParameters(tokenEndpointResponse);
        return this.createAuthenticationResultFromTokenResponse(tokenEndpointResponse);
    }

    public ProviderAuthenticationResult sendTokenRefreshRequest(String refreshToken) throws TokenRequestException {
        TokenResponse tokenEndpointResponse = this.sendTokenRequestForRefresh(refreshToken);
        return this.createAuthenticationResultFromTokenResponse(tokenEndpointResponse);
    }

    TokenResponse sendTokenRequest() throws TokenRequestException {
        String tokenEndpoint = this.getTokenEndpoint();
        String authzCode = this.request.getParameter("code");
        return this.sendTokenRequestForCode(tokenEndpoint, authzCode);
    }

    /*
     * WARNING - void declaration
     */
    TokenResponse sendTokenRequestForRefresh(String refreshToken) throws TokenRequestException {
        String tokenEndpoint = this.getTokenEndpoint();
        TokenRequestor.Builder tokenRequestBuilder = this.createTokenRequestorBuilderForGeneralRequest(tokenEndpoint, null);
        tokenRequestBuilder.grantType("refresh_token");
        tokenRequestBuilder.refreshToken(refreshToken);
        TokenRequestor tokenRequestor = tokenRequestBuilder.build();
        try {
            return tokenRequestor.requestTokens();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.security.oidcclientcore.token.JakartaOidcTokenRequest", (String)"81", (Object)this, (Object[])new Object[]{refreshToken});
            throw new TokenRequestException(this.oidcClientConfig.getClientId(), e.toString(), (Throwable)e);
        }
    }

    @FFDCIgnore(value={OidcClientConfigurationException.class})
    String getTokenEndpoint() throws TokenRequestException {
        String tokenEndpoint = null;
        try {
            tokenEndpoint = MetadataUtils.getTokenEndpoint(this.oidcClientConfig);
        }
        catch (OidcClientConfigurationException | OidcDiscoveryException e) {
            throw new TokenRequestException(this.oidcClientConfig.getClientId(), e.getMessage());
        }
        return tokenEndpoint;
    }

    /*
     * WARNING - void declaration
     */
    TokenResponse sendTokenRequestForCode(String tokenEndpoint, String authzCode) throws TokenRequestException {
        TokenRequestor.Builder tokenRequestBuilder = this.createTokenRequestorBuilderForGeneralRequest(tokenEndpoint, authzCode);
        tokenRequestBuilder.grantType("authorization_code");
        TokenRequestor tokenRequestor = tokenRequestBuilder.build();
        try {
            return tokenRequestor.requestTokens();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.security.oidcclientcore.token.JakartaOidcTokenRequest", (String)"103", (Object)this, (Object[])new Object[]{tokenEndpoint, authzCode});
            throw new TokenRequestException(this.oidcClientConfig.getClientId(), e.toString(), (Throwable)e);
        }
    }

    TokenRequestor.Builder createTokenRequestorBuilderForGeneralRequest(String tokenEndpoint, String authzCode) throws TokenRequestException {
        String clientId = this.oidcClientConfig.getClientId();
        String clientSecret = null;
        ProtectedString clientSecretProtectedString = this.oidcClientConfig.getClientSecret();
        if (clientSecretProtectedString != null) {
            clientSecret = new String(clientSecretProtectedString.getChars());
        }
        TokenRequestor.Builder tokenRequestBuilder = this.createTokenRequestorBuilder(tokenEndpoint, clientId, clientSecret, authzCode);
        tokenRequestBuilder.sslSocketFactory(OidcMetadataService.getSSLSocketFactory());
        return tokenRequestBuilder;
    }

    TokenRequestor.Builder createTokenRequestorBuilder(String tokenEndpoint, String clientId, @Sensitive String clientSecret, String authzCode) {
        return new TokenRequestor.Builder(tokenEndpoint, clientId, clientSecret, this.oidcClientConfig.getRedirectURI(), authzCode);
    }

    void verifyTokenResponseContainsRequiredParameters(TokenResponse tokenEndpointResponse) throws TokenRequestException {
        Map<String, String> responseMap = tokenEndpointResponse.asMap();
        ArrayList<String> missingParameters = new ArrayList<String>();
        List<String> requiredParameters = Arrays.asList("access_token", "token_type", "id_token");
        for (String requiredParameter : requiredParameters) {
            if (responseMap.containsKey(requiredParameter)) continue;
            missingParameters.add(requiredParameter);
        }
        if (!missingParameters.isEmpty()) {
            String nlsMessage = Tr.formatMessage((TraceComponent)tc, (String)"TOKEN_RESPONSE_MISSING_PARAMETER", (Object[])new Object[]{missingParameters});
            throw new TokenRequestException(this.oidcClientConfig.getClientId(), nlsMessage);
        }
    }

    ProviderAuthenticationResult createAuthenticationResultFromTokenResponse(TokenResponse tokenEndpointResponse) {
        Hashtable<String, TokenResponse> customProperties = new Hashtable<String, TokenResponse>();
        customProperties.put(AUTH_RESULT_CUSTOM_PROP_TOKEN_RESPONSE, tokenEndpointResponse);
        return new ProviderAuthenticationResult(AuthResult.SUCCESS, 200, null, new Subject(), customProperties, null);
    }
}

