/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics50.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics50.SharedMetricRegistries;
import io.openliberty.microprofile.metrics50.helper.Util;
import io.openliberty.smallrye.metrics.adapters.SRMetricRegistryAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationStateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class ApplicationListener50
implements ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(ApplicationListener50.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    private SharedMetricRegistries sharedMetricRegistry;
    public static Map<String, String> contextRoot_Map = new HashMap<String, String>();
    static final long serialVersionUID = -5544468856812256696L;

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        Set<String> scopeNamesSet = this.sharedMetricRegistry.getMetricRegistryScopeNames();
        if (!scopeNamesSet.contains("vendor")) {
            scopeNamesSet.add("vendor");
        } else if (!scopeNamesSet.contains("application")) {
            scopeNamesSet.add("application");
        } else if (!scopeNamesSet.contains("base")) {
            scopeNamesSet.add("base");
        }
        MetricRegistry[] registryArray = new MetricRegistry[scopeNamesSet.size()];
        int i = 0;
        for (String scope : scopeNamesSet) {
            registryArray[i] = this.sharedMetricRegistry.getOrCreate(scope);
            ++i;
        }
        for (MetricRegistry registry : registryArray) {
            if (!Util.SR_LEGACY_METRIC_REGISTRY_CLASS.isInstance(registry)) continue;
            try {
                Object cast = Util.SR_LEGACY_METRIC_REGISTRY_CLASS.cast(registry);
                SRMetricRegistryAdapter metricRegistry = new SRMetricRegistryAdapter(cast);
                metricRegistry.unRegisterApplicationMetrics(appInfo.getDeploymentName());
            }
            catch (ClassCastException cast) {
                FFDCFilter.processException((Throwable)cast, (String)"io.openliberty.microprofile.metrics50.internal.ApplicationListener50", (String)"87", (Object)this, (Object[])new Object[]{appInfo});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Incompatible Metric Registries. Coud not cast " + registry + " to " + Util.SR_LEGACY_METRIC_REGISTRY_CLASS), (Object[])new Object[0]);
            }
        }
    }

    @Reference
    public void getSharedMetricRegistries(SharedMetricRegistries sharedMetricRegistry) {
        this.sharedMetricRegistry = sharedMetricRegistry;
    }
}

