/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.MpConfigProperties;
import com.ibm.ws.security.mp.jwt.MpConfigProxyService;
import jakarta.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(property={"service.vendor=IBM"})
public class MpConfigUtil {
    private static TraceComponent tc = Tr.register(MpConfigUtil.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    private static MpConfigProxyService mpConfigProxyService = null;
    static final long serialVersionUID = 4958410408324519744L;

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    protected void setMpConfigProxyService(MpConfigProxyService proxyService) {
        if (mpConfigProxyService == null) {
            mpConfigProxyService = proxyService;
        } else if (proxyService != null && mpConfigProxyService.getVersion().compareTo(proxyService.getVersion()) < 0) {
            mpConfigProxyService = proxyService;
        }
    }

    protected void unsetMpConfigProxyService(MpConfigProxyService proxyService) {
        mpConfigProxyService = null;
    }

    public MpConfigProperties getMpConfig(HttpServletRequest req) {
        if (mpConfigProxyService != null) {
            return mpConfigProxyService.getConfigProperties(this.getApplicationClassloader(req));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"MP JWT feature is not enabled.", (Object[])new Object[0]);
        }
        return new MpConfigProperties();
    }

    protected ClassLoader getApplicationClassloader(HttpServletRequest req) {
        return req != null ? req.getServletContext().getClassLoader() : null;
    }
}

