/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.TriggerService;
import com.ibm.ws.concurrent.ext.ConcurrencyExtensionProvider;
import com.ibm.ws.concurrent.internal.ManagedScheduledExecutorServiceImpl;
import com.ibm.ws.container.service.metadata.ApplicationMetaDataListener;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import java.security.AccessController;
import java.util.Collection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={ConcurrencyService.class, ApplicationMetaDataListener.class})
public class ConcurrencyService
implements ApplicationMetaDataListener {
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private static final TraceComponent tc = Tr.register(ConcurrencyService.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    @Reference(policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.OPTIONAL, target="(id=unbound)")
    ConcurrencyExtensionProvider extensionProvider;
    @Reference
    TriggerService triggerSvc;
    static final long serialVersionUID = 7371066504582542360L;

    @Trivial
    public void applicationMetaDataCreated(MetaDataEvent<ApplicationMetaData> event) throws MetaDataException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("applicationMetaDataCreated: " + ((ApplicationMetaData)event.getMetaData()).getJ2EEName()), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public void applicationMetaDataDestroyed(MetaDataEvent<ApplicationMetaData> event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("applicationMetaDataDestroyed: " + ((ApplicationMetaData)event.getMetaData()).getJ2EEName()), (Object[])new Object[0]);
        }
        BundleContext bc = priv.getBundleContext(FrameworkUtil.getBundle(this.getClass()));
        try {
            Collection refs = priv.getServiceReferences(bc, ManagedScheduledExecutorService.class, "(service.factoryPid=com.ibm.ws.concurrent.managedScheduledExecutorService)");
            for (ServiceReference ref : refs) {
                ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)priv.getService(bc, ref);
                if (!(executor instanceof ManagedScheduledExecutorServiceImpl)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("purge futures list for " + executor), (Object[])new Object[0]);
                }
                ((ManagedScheduledExecutorServiceImpl)executor).purgeFutures();
            }
        }
        catch (InvalidSyntaxException refs) {
            void x;
            FFDCFilter.processException((Throwable)refs, (String)"com.ibm.ws.concurrent.internal.ConcurrencyService", (String)"78", (Object)this, (Object[])new Object[]{event});
            throw new RuntimeException((Throwable)x);
        }
    }
}

