/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.cookies;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import java.util.Date;
import java.util.Map;

public class CookieUtils {
    private static final TraceComponent tc = Tr.register(CookieUtils.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final String TSPECIALS = "\"()<>@,;:\\/[]?={} \t";
    private static final String longAgo = "; Expires=Thu, 01-Dec-94 16:00:00 GMT";
    private static final String longAgoRFC1123 = "; Expires=Thu, 01 Dec 1994 16:00:00 GMT";
    private static boolean skipCookiePathQuotes = false;
    private static boolean isEE11 = HttpDispatcher.isEE11();

    private CookieUtils() {
    }

    public static String toString(HttpCookie cookie, HeaderKeys hdr, boolean isv0CookieDateRFC1123, boolean skipPathQuotes) {
        skipCookiePathQuotes = skipPathQuotes;
        return CookieUtils.toString(cookie, hdr, isv0CookieDateRFC1123);
    }

    public static String toString(HttpCookie cookie, HeaderKeys hdr, boolean isv0CookieDateRFC1123) {
        if (null == cookie) {
            throw new NullPointerException("Null cookie input");
        }
        if (null == hdr) {
            throw new NullPointerException("Null header input");
        }
        try {
            if (0 == cookie.getVersion()) {
                if (HttpHeaderKeys.HDR_COOKIE.equals(hdr)) {
                    return CookieUtils.convertV0Cookie(cookie);
                }
                if (HttpHeaderKeys.HDR_SET_COOKIE.equals(hdr)) {
                    return CookieUtils.convertV0SetCookie(cookie, isv0CookieDateRFC1123);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Invalid header: " + hdr), (Object[])new Object[0]);
                }
            } else if (1 == cookie.getVersion()) {
                if (HttpHeaderKeys.HDR_COOKIE.equals(hdr)) {
                    return CookieUtils.convertV1Cookie(cookie);
                }
                if (HttpHeaderKeys.HDR_COOKIE2.equals(hdr)) {
                    return CookieUtils.convertV1Cookie2(cookie);
                }
                if (HttpHeaderKeys.HDR_SET_COOKIE.equals(hdr)) {
                    return CookieUtils.convertV1SetCookie(cookie);
                }
                if (HttpHeaderKeys.HDR_SET_COOKIE2.equals(hdr)) {
                    return CookieUtils.convertV1SetCookie2(cookie);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Invalid header: " + hdr), (Object[])new Object[0]);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Invalid Cookie version: " + cookie.getVersion()), (Object[])new Object[0]);
            }
            return CookieUtils.convertV0Cookie(cookie);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CookieUtils.class.getName() + ".toString"), (String)"1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception while converting the cookie; " + cookie), (Object[])new Object[0]);
            }
            return null;
        }
    }

    private static boolean needsQuote(String value) {
        if (null == value) {
            return true;
        }
        int len = value.length();
        if (0 == len) {
            return true;
        }
        if ('\"' == value.charAt(0)) {
            return '\"' != value.charAt(len - 1);
        }
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && TSPECIALS.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    private static void maybeQuote(StringBuilder buff, String value) {
        if (null == value || 0 == value.length()) {
            buff.append("\"\"");
        } else if (CookieUtils.needsQuote(value)) {
            buff.append('\"');
            buff.append(value);
            buff.append('\"');
        } else {
            buff.append(value);
        }
    }

    private static String convertV0Cookie(HttpCookie cookie) {
        StringBuilder buffer = new StringBuilder(40);
        buffer.append(cookie.getName());
        String value = cookie.getValue();
        if (null != value && 0 != value.length()) {
            buffer.append('=');
            buffer.append(value);
        } else {
            buffer.append("=\"\"");
        }
        value = cookie.getPath();
        if (null != value && 0 != value.length()) {
            buffer.append("; $Path=");
            buffer.append(value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created v0 Cookie: [" + buffer.toString() + "]"), (Object[])new Object[0]);
        }
        return buffer.toString();
    }

    private static String convertV1Cookie(HttpCookie cookie) {
        StringBuilder buffer = new StringBuilder(40);
        buffer.append(cookie.getName());
        buffer.append('=');
        CookieUtils.maybeQuote(buffer, cookie.getValue());
        buffer.append("; $Version=1");
        String value = cookie.getPath();
        if (null != value && 0 != value.length()) {
            buffer.append("; $Path=");
            if (!skipCookiePathQuotes) {
                CookieUtils.maybeQuote(buffer, value);
            } else {
                buffer.append(value);
            }
        }
        if (null != (value = cookie.getDomain()) && 0 != value.length()) {
            buffer.append("; $Domain=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created v1 Cookie: [" + buffer.toString() + "]"), (Object[])new Object[0]);
        }
        return buffer.toString();
    }

    private static String convertV1Cookie2(HttpCookie cookie) {
        StringBuilder buffer = new StringBuilder(40);
        buffer.append(cookie.getName());
        buffer.append('=');
        CookieUtils.maybeQuote(buffer, cookie.getValue());
        buffer.append("; $Version=1");
        String value = cookie.getPath();
        if (null != value && 0 != value.length()) {
            buffer.append("; $Path=");
            if (!skipCookiePathQuotes) {
                CookieUtils.maybeQuote(buffer, value);
            } else {
                buffer.append(value);
            }
        }
        if (null != (value = cookie.getDomain()) && 0 != value.length()) {
            buffer.append("; $Domain=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created v1 Cookie2: [" + buffer.toString() + "]"), (Object[])new Object[0]);
        }
        return buffer.toString();
    }

    private static String convertV0SetCookie(HttpCookie cookie, boolean isRFC1123DateEnabled) {
        String expireDateFormat;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Cookie Name: " + cookie.getName()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Cookie MaxAge: " + cookie.getMaxAge()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("RFC1123 Date Enabled (4 digit year): " + isRFC1123DateEnabled), (Object[])new Object[0]);
        }
        StringBuilder buffer = new StringBuilder(40);
        buffer.append(cookie.getName());
        String value = cookie.getValue();
        if (null != value && 0 != value.length()) {
            buffer.append('=');
            buffer.append(value);
        } else {
            buffer.append("=\"\"");
        }
        String comment = cookie.getComment();
        if (null != comment && 0 != comment.length()) {
            buffer.append("; Comment=");
            CookieUtils.maybeQuote(buffer, comment);
        }
        int expires = cookie.getMaxAge();
        String string = expireDateFormat = isRFC1123DateEnabled ? longAgoRFC1123 : longAgo;
        if (-1 < expires) {
            if (0 == expires) {
                if (HttpDispatcher.isEE11() || !HttpDispatcher.useEE10Cookies()) {
                    buffer.append(expireDateFormat);
                } else if (HttpDispatcher.useEE10Cookies()) {
                    buffer.append("; Max-Age=0" + expireDateFormat);
                }
            } else {
                buffer.append("; Expires=");
                if (!isRFC1123DateEnabled) {
                    buffer.append(HttpDispatcher.getDateFormatter().getRFC2109Time(new Date(HttpDispatcher.getApproxTime() + (long)expires * 1000L)));
                } else {
                    buffer.append(HttpDispatcher.getDateFormatter().getRFC1123Time(new Date(HttpDispatcher.getApproxTime() + (long)expires * 1000L)));
                }
            }
        } else if (cookie.isDiscard()) {
            buffer.append(expireDateFormat);
        }
        value = cookie.getPath();
        if (null != value && 0 != value.length()) {
            buffer.append("; Path=");
            buffer.append(value);
        }
        if (null != (value = cookie.getDomain()) && 0 != value.length()) {
            buffer.append("; Domain=");
            buffer.append(value);
        }
        if (cookie.isSecure()) {
            buffer.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            buffer.append("; HttpOnly");
        }
        if (null != (value = cookie.getAttribute("samesite")) && 0 != value.length()) {
            buffer.append("; SameSite=");
            buffer.append(value);
        }
        if (null != (value = cookie.getAttribute("partitioned")) && !value.equalsIgnoreCase("false")) {
            buffer.append("; Partitioned");
        }
        CookieUtils.setAttributes(cookie, buffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created v0 Set-Cookie: [" + GenericUtils.nullOutPasswords(buffer.toString(), (byte)38) + "]"), (Object[])new Object[0]);
        }
        return buffer.toString();
    }

    private static String convertV1SetCookie(HttpCookie cookie) {
        int maxAge;
        StringBuilder buffer = new StringBuilder(40);
        buffer.append(cookie.getName());
        buffer.append('=');
        CookieUtils.maybeQuote(buffer, cookie.getValue());
        buffer.append("; Version=1");
        String value = cookie.getComment();
        if (null != value && 0 != value.length()) {
            buffer.append("; Comment=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (null != (value = cookie.getDomain()) && 0 != value.length()) {
            buffer.append("; Domain=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (-1 < (maxAge = cookie.getMaxAge())) {
            buffer.append("; Max-Age=");
            buffer.append(maxAge);
        } else if (cookie.isDiscard()) {
            buffer.append("; Max-Age=0");
        }
        value = cookie.getPath();
        if (null != value && 0 != value.length()) {
            buffer.append("; Path=");
            if (!skipCookiePathQuotes) {
                CookieUtils.maybeQuote(buffer, value);
            } else {
                buffer.append(value);
            }
        }
        if (cookie.isSecure()) {
            buffer.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            buffer.append("; HttpOnly");
        }
        if (null != (value = cookie.getAttribute("samesite")) && 0 != value.length()) {
            buffer.append("; SameSite=");
            buffer.append(value);
        }
        if (null != (value = cookie.getAttribute("partitioned")) && !value.equalsIgnoreCase("false")) {
            buffer.append("; Partitioned");
        }
        CookieUtils.setAttributes(cookie, buffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created v1 Set-Cookie: [" + buffer.toString() + "]"), (Object[])new Object[0]);
        }
        return buffer.toString();
    }

    private static String convertV1SetCookie2(HttpCookie cookie) {
        int maxAge;
        StringBuilder buffer = new StringBuilder(40);
        buffer.append(cookie.getName());
        buffer.append('=');
        CookieUtils.maybeQuote(buffer, cookie.getValue());
        buffer.append("; Version=1");
        String value = cookie.getComment();
        if (null != value && 0 != value.length()) {
            buffer.append("; Comment=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (null != (value = cookie.getDomain()) && 0 != value.length()) {
            buffer.append("; Domain=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (-1 < (maxAge = cookie.getMaxAge())) {
            buffer.append("; Max-Age=");
            buffer.append(maxAge);
        }
        if (null != (value = cookie.getPath()) && 0 != value.length()) {
            buffer.append("; Path=");
            if (!skipCookiePathQuotes) {
                CookieUtils.maybeQuote(buffer, value);
            } else {
                buffer.append(value);
            }
        }
        if (null != (value = cookie.getAttribute("commenturl")) && 0 != value.length()) {
            buffer.append("; CommentURL=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (null != (value = cookie.getAttribute("port")) && 0 != value.length()) {
            buffer.append("; Port=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (cookie.isDiscard()) {
            buffer.append("; Discard");
        }
        if (cookie.isSecure()) {
            buffer.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            buffer.append("; HttpOnly");
        }
        if (null != (value = cookie.getAttribute("samesite")) && 0 != value.length()) {
            buffer.append("; SameSite=");
            buffer.append(value);
        }
        if (null != (value = cookie.getAttribute("partitioned")) && !value.equalsIgnoreCase("false")) {
            buffer.append("; Partitioned");
        }
        CookieUtils.setAttributes(cookie, buffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created v1 Set-Cookie2: [" + buffer.toString() + "]"), (Object[])new Object[0]);
        }
        return buffer.toString();
    }

    private static void setAttributes(HttpCookie cookie, StringBuilder buffer) {
        Map<String, String> cookieAttrs = cookie.getAttributes();
        if (cookieAttrs != null) {
            for (Map.Entry<String, String> entry : cookieAttrs.entrySet()) {
                String key = entry.getKey();
                if (key.equals("samesite") || key.equals("port") || key.equals("commenturl") || key.equals("partitioned")) continue;
                String value = entry.getValue();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setAttribute (" + key + " , " + value + ")"), (Object[])new Object[0]);
                }
                if (isEE11) {
                    if (CookieUtils.hasReservedCharacters(key)) {
                        String message = Tr.formatMessage((TraceComponent)tc, (String)"cookie.attribute.name.invalid", (Object[])new Object[]{key});
                        Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
                        throw new IllegalArgumentException(message);
                    }
                    if (value == null || value.trim().equalsIgnoreCase("null")) continue;
                    if (value.isEmpty() || value.contentEquals("=")) {
                        buffer.append("; " + key);
                        continue;
                    }
                    buffer.append("; " + key + "=" + value);
                    continue;
                }
                buffer.append("; " + key + "=");
                buffer.append(value);
            }
        }
    }

    private static boolean hasReservedCharacters(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && TSPECIALS.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }
}

