/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.internal.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.internal.HttpTrailersImpl;
import com.ibm.wsspi.channelfw.objectpool.TwoTierObjectPool;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;

public class HttpObjectFactory {
    private static final TraceComponent tc = Tr.register(HttpObjectFactory.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final int SIZE_THREAD = 50;
    private static final int SIZE_MAIN = 50;
    private final TwoTierObjectPool reqPool = new TwoTierObjectPool(50, 50);
    private final TwoTierObjectPool respPool = new TwoTierObjectPool(50, 50);
    private final TwoTierObjectPool hdrPool = new TwoTierObjectPool(50, 50);

    public HttpObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("New HTTP object factory created: " + this), (Object[])new Object[0]);
        }
    }

    public HttpRequestMessageImpl getRequest() {
        HttpRequestMessageImpl req = (HttpRequestMessageImpl)this.reqPool.get();
        if (null == req) {
            req = new HttpRequestMessageImpl();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRequest(): " + req), (Object[])new Object[0]);
        }
        return req;
    }

    public HttpRequestMessageImpl getRequest(HttpInboundServiceContext hsc) {
        HttpRequestMessageImpl req = this.getRequest();
        req.init(hsc);
        return req;
    }

    public HttpRequestMessageImpl getRequest(HttpOutboundServiceContext hsc) {
        HttpRequestMessageImpl req = this.getRequest();
        req.init(hsc);
        return req;
    }

    public void releaseRequest(HttpRequestMessageImpl request) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("releaseRequest: " + request), (Object[])new Object[0]);
        }
        this.reqPool.put((Object)request);
    }

    public HttpResponseMessageImpl getResponse() {
        HttpResponseMessageImpl resp = (HttpResponseMessageImpl)this.respPool.get();
        if (null == resp) {
            resp = new HttpResponseMessageImpl();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getResponse(): " + resp), (Object[])new Object[0]);
        }
        return resp;
    }

    public HttpResponseMessageImpl getResponse(HttpInboundServiceContext hsc) {
        HttpResponseMessageImpl resp = this.getResponse();
        resp.init(hsc);
        return resp;
    }

    public HttpResponseMessageImpl getResponse(HttpOutboundServiceContext hsc) {
        HttpResponseMessageImpl resp = this.getResponse();
        resp.init(hsc);
        return resp;
    }

    public void releaseResponse(HttpResponseMessageImpl response) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("releaseResponse: " + response), (Object[])new Object[0]);
        }
        this.respPool.put((Object)response);
    }

    public HttpTrailersImpl getTrailers() {
        Object o = this.hdrPool.get();
        HttpTrailersImpl hdrs = null == o ? new HttpTrailersImpl() : (HttpTrailersImpl)o;
        hdrs.setFactory(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTrailers: " + hdrs), (Object[])new Object[0]);
        }
        return hdrs;
    }

    public void releaseTrailers(HttpTrailersImpl h) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("releaseTrailers: " + h), (Object[])new Object[0]);
        }
        this.hdrPool.put((Object)h);
    }
}

