/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.ot;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import io.openliberty.microprofile.rest.client40.internal.OsgiServices;
import io.openliberty.restfulWS.client.AsyncClientExecutorService;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.jboss.logging.Logger;
import org.jboss.resteasy.cdi.CdiInjectorFactory;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.URLConnectionClientEngineBuilder;
import org.jboss.resteasy.client.jaxrs.internal.LocalResteasyProviderFactory;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientBuilderImpl;
import org.jboss.resteasy.concurrent.ContextualExecutorService;
import org.jboss.resteasy.concurrent.ContextualExecutors;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.microprofile.client.ConfigurationWrapper;
import org.jboss.resteasy.microprofile.client.DefaultMediaTypeFilter;
import org.jboss.resteasy.microprofile.client.DefaultResponseExceptionMapper;
import org.jboss.resteasy.microprofile.client.ExceptionMapping;
import org.jboss.resteasy.microprofile.client.MethodInjectionFilter;
import org.jboss.resteasy.microprofile.client.RestClientBuilderImpl;
import org.jboss.resteasy.microprofile.client.RestClientListeners;
import org.jboss.resteasy.microprofile.client.RestClientProxy;
import org.jboss.resteasy.microprofile.client.async.AsyncInterceptorRxInvokerProvider;
import org.jboss.resteasy.microprofile.client.async.AsyncInvocationInterceptorThreadContext;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProviders;
import org.jboss.resteasy.microprofile.client.header.ClientHeadersRequestFilter;
import org.jboss.resteasy.microprofile.client.impl.MpClient;
import org.jboss.resteasy.microprofile.client.impl.MpClientBuilderImpl;
import org.jboss.resteasy.microprofile.client.ot.InterceptorInvoker;
import org.jboss.resteasy.microprofile.client.ot.LibertyProxyInvocationHandler;
import org.jboss.resteasy.microprofile.client.publisher.MpPublisherMessageBodyReader;
import org.jboss.resteasy.specimpl.ResteasyUriBuilderImpl;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ResteasyUriBuilder;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class LibertyRestClientBuilderImpl
implements RestClientBuilder {
    private static final String RESTEASY_PROPERTY_PREFIX = "resteasy.";
    private static final String DEFAULT_MAPPER_PROP = "microprofile.rest.client.disable.default.mapper";
    private static final Logger LOGGER;
    private static final DefaultMediaTypeFilter DEFAULT_MEDIA_TYPE_FILTER;
    private static final Collection<Method> IGNORED_METHODS;
    public static final MethodInjectionFilter METHOD_INJECTION_FILTER;
    public static final ClientHeadersRequestFilter HEADERS_REQUEST_FILTER;
    private static final Class<?> FT_ANNO_CLASS;
    static ResteasyProviderFactory PROVIDER_FACTORY;
    private final MultivaluedMap<String, Object> headers;
    private final MpClientBuilderImpl builderDelegate;
    private final ConfigurationWrapper configurationWrapper;
    private Config config;
    private ContextualExecutorService executorService;
    private URI baseURI;
    private Long connectTimeout;
    private TimeUnit connectTimeoutUnit;
    private Long readTimeout;
    private TimeUnit readTimeoutUnit;
    private String proxyHost;
    private Integer proxyPort = null;
    private SSLContext sslContext;
    private KeyStore trustStore;
    private KeyStore keyStore;
    private String keystorePassword;
    private HostnameVerifier hostnameVerifier;
    private Boolean useURLConnection;
    private boolean followRedirect;
    private QueryParamStyle queryParamStyle = null;
    private final Set<Object> localProviderInstances = new HashSet<Object>();
    private final Collection<AsyncInvocationInterceptorFactory> invocationInterceptorFactories = new ArrayList<AsyncInvocationInterceptorFactory>();
    private final BeanManager beanManager;
    static final long serialVersionUID = 7308302159369807342L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void setProviderFactory(ResteasyProviderFactory providerFactory) {
        PROVIDER_FACTORY = providerFactory;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private static Class<?> getFTAnnotationClass() {
        try {
            return AccessController.doPrivileged(() -> Class.forName("com.ibm.ws.microprofile.faulttolerance.cdi.FaultTolerance"));
        }
        catch (PrivilegedActionException pae) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Exception checking for MP Fault Tolerance class - expected if FT feature isnot enabled", (Throwable)pae);
            }
            return null;
        }
    }

    public LibertyRestClientBuilderImpl() {
        this.builderDelegate = new MpClientBuilderImpl();
        if (PROVIDER_FACTORY != null) {
            LocalResteasyProviderFactory localProviderFactory = new LocalResteasyProviderFactory(PROVIDER_FACTORY);
            if (ResteasyProviderFactory.peekInstance() != null) {
                localProviderFactory.initializeClientProviders(ResteasyProviderFactory.getInstance());
            }
            this.builderDelegate.providerFactory((ResteasyProviderFactory)localProviderFactory);
        }
        this.beanManager = LibertyRestClientBuilderImpl.getBeanManager();
        if (this.beanManager != null) {
            this.builderDelegate.getProviderFactory().setInjectorFactory((InjectorFactory)new CdiInjectorFactory(this.beanManager));
        }
        this.configurationWrapper = new ConfigurationWrapper(this.builderDelegate.getConfiguration());
        try {
            this.config = ConfigProvider.getConfig();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.headers = new Headers();
    }

    public Configuration getConfigurationWrapper() {
        return this.configurationWrapper;
    }

    public RestClientBuilder followRedirects(boolean followRedirect) {
        this.followRedirect = followRedirect;
        return this;
    }

    public boolean isFollowRedirects() {
        return this.followRedirect;
    }

    public RestClientBuilder queryParamStyle(QueryParamStyle queryParamStyle) {
        this.queryParamStyle = queryParamStyle;
        return this;
    }

    public RestClientBuilder header(String name, Object value) {
        this.headers.add((Object)Objects.requireNonNull(name, "A header name is required."), Objects.requireNonNull(value, "Value for header is required."));
        return this;
    }

    public RestClientBuilder proxyAddress(String host, int port) {
        if (host == null) {
            throw new IllegalArgumentException("proxyHost must not be null");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port number");
        }
        this.proxyHost = host;
        this.proxyPort = port;
        return this;
    }

    public RestClientBuilder baseUrl(URL url) {
        try {
            this.baseURI = url.toURI();
            return this;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public RestClientBuilder baseUri(URI uri) {
        this.baseURI = uri;
        return this;
    }

    public RestClientBuilder connectTimeout(long l, TimeUnit timeUnit) {
        this.connectTimeout = l;
        this.connectTimeoutUnit = timeUnit;
        return this;
    }

    public RestClientBuilder readTimeout(long time, TimeUnit timeUnit) {
        this.readTimeout = time;
        this.readTimeoutUnit = timeUnit;
        return this;
    }

    public RestClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public RestClientBuilder trustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public RestClientBuilder keyStore(KeyStore keyStore, String keystorePassword) {
        this.keyStore = keyStore;
        this.keystorePassword = keystorePassword;
        return this;
    }

    public RestClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public RestClientBuilder executorService(ExecutorService executor) {
        if (executor == null) {
            throw new IllegalArgumentException("ExecutorService must not be null");
        }
        this.executorService = ContextualExecutors.wrap((ExecutorService)executor);
        return this;
    }

    public <T> T build(Class<T> aClass, ClientHttpEngine httpEngine) throws IllegalStateException, RestClientDefinitionException {
        ResteasyClientBuilderImpl resteasyClientBuilder;
        RegisterProvider[] providers;
        Collection listeners = System.getSecurityManager() == null ? RestClientListeners.get() : AccessController.doPrivileged(() -> RestClientListeners.get());
        listeners.forEach(listener -> listener.onNewClient(aClass, (RestClientBuilder)this));
        this.verifyInterface(aClass);
        if (this.baseURI == null) {
            throw new IllegalStateException("Neither baseUri nor baseUrl was specified");
        }
        for (RegisterProvider provider : providers = (RegisterProvider[])aClass.getAnnotationsByType(RegisterProvider.class)) {
            this.register(provider.value(), provider.priority());
        }
        if (!this.isMapperDisabled()) {
            this.register(DefaultResponseExceptionMapper.class);
        }
        this.builderDelegate.register(new ExceptionMapping(this.localProviderInstances), 1);
        ClassLoader classLoader = LibertyRestClientBuilderImpl.getClassLoader(aClass);
        if (this.proxyHost != null) {
            resteasyClientBuilder = this.builderDelegate.defaultProxy(this.proxyHost, this.proxyPort);
        } else {
            List<String> noProxyHosts = this.getProxyHostsAsRegex();
            String envProxyHost = this.getSystemProperty("http.proxyHost", null);
            boolean isUriMatched = false;
            if (envProxyHost != null && !noProxyHosts.isEmpty()) {
                String s;
                Pattern p;
                Matcher m;
                Iterator<String> iterator = noProxyHosts.iterator();
                while (iterator.hasNext() && !(isUriMatched = (m = (p = Pattern.compile(s = iterator.next())).matcher(this.baseURI.getHost())).matches())) {
                }
            }
            if (envProxyHost != null && !isUriMatched) {
                resteasyClientBuilder = this.builderDelegate.defaultProxy(envProxyHost, Integer.parseInt(this.getSystemProperty("http.proxyPort", "80")));
            } else {
                String userProxyHost = Optional.ofNullable(this.getConfiguration().getProperty("org.jboss.resteasy.jaxrs.client.proxy.host")).filter(String.class::isInstance).map(String.class::cast).orElse(null);
                Integer userProxyPort = Optional.ofNullable(this.getConfiguration().getProperty("org.jboss.resteasy.jaxrs.client.proxy.port")).filter(Integer.class::isInstance).map(Integer.class::cast).orElse(null);
                String userProxyScheme = Optional.ofNullable(this.getConfiguration().getProperty("org.jboss.resteasy.jaxrs.client.proxy.scheme")).filter(String.class::isInstance).map(String.class::cast).orElse(null);
                if (userProxyHost != null && userProxyPort != null) {
                    resteasyClientBuilder = this.builderDelegate.defaultProxy(userProxyHost, userProxyPort, userProxyScheme);
                } else {
                    this.selectHttpProxy().ifPresent(proxyAddress -> this.builderDelegate.defaultProxy(proxyAddress.getHostString(), proxyAddress.getPort()));
                    resteasyClientBuilder = this.builderDelegate;
                }
            }
        }
        if (this.executorService != null) {
            resteasyClientBuilder.executorService((ExecutorService)new AsyncClientExecutorService((ExecutorService)this.executorService));
        } else {
            boolean cleanupExecutor;
            Optional<ExecutorService> managedExecutor = OsgiServices.getManagedExecutorService();
            if (managedExecutor.isPresent()) {
                cleanupExecutor = false;
                this.executorService = ContextualExecutors.wrap((ExecutorService)managedExecutor.get(), (boolean)true);
            } else {
                this.executorService = ContextualExecutors.threadPool();
                cleanupExecutor = !this.executorService.isManaged();
            }
            resteasyClientBuilder.executorService((ExecutorService)new AsyncClientExecutorService((ExecutorService)this.executorService), cleanupExecutor);
        }
        resteasyClientBuilder.register((Object)DEFAULT_MEDIA_TYPE_FILTER);
        resteasyClientBuilder.register((Object)METHOD_INJECTION_FILTER);
        resteasyClientBuilder.register((Object)new ClientHeadersRequestFilter(this.headers));
        this.register(new MpPublisherMessageBodyReader((ExecutorService)this.executorService));
        resteasyClientBuilder.sslContext(this.sslContext);
        resteasyClientBuilder.trustStore(this.trustStore);
        resteasyClientBuilder.keyStore(this.keyStore, this.keystorePassword);
        resteasyClientBuilder.hostnameVerifier(this.hostnameVerifier);
        resteasyClientBuilder.setIsTrustSelfSignedCertificates(false);
        this.checkQueryParamStyleProperty(aClass);
        this.checkFollowRedirectProperty(aClass);
        resteasyClientBuilder.setFollowRedirects(this.followRedirect);
        if (this.readTimeout != null) {
            resteasyClientBuilder.readTimeout(this.readTimeout.longValue(), this.readTimeoutUnit);
        }
        if (this.connectTimeout != null) {
            resteasyClientBuilder.connectTimeout(this.connectTimeout.longValue(), this.connectTimeoutUnit);
        }
        if (httpEngine != null) {
            resteasyClientBuilder.httpEngine(httpEngine);
        } else {
            boolean registerEngine = false;
            for (Object p : this.getBuilderDelegate().getProviderFactory().getProviderInstances()) {
                if (!(p instanceof ClientHttpEngine)) continue;
                resteasyClientBuilder.httpEngine((ClientHttpEngine)p);
                registerEngine = true;
                break;
            }
            if (!registerEngine && this.useURLConnection()) {
                resteasyClientBuilder.httpEngine(new URLConnectionClientEngineBuilder().resteasyClientBuilder((ResteasyClientBuilder)resteasyClientBuilder).build());
                resteasyClientBuilder.sslContext(null);
                resteasyClientBuilder.trustStore(null);
                resteasyClientBuilder.keyStore(null, "");
            }
        }
        if (!this.invocationInterceptorFactories.isEmpty()) {
            resteasyClientBuilder.register((Object)new AsyncInvocationInterceptorThreadContext(this.invocationInterceptorFactories));
        }
        ResteasyClient client = resteasyClientBuilder.build();
        ((MpClient)client).setQueryParamStyle(this.queryParamStyle);
        client.register(AsyncInterceptorRxInvokerProvider.class);
        Object actualClient = client.target(this.baseURI).proxyBuilder(aClass).classloader(classLoader).defaultConsumes("application/json").defaultProduces("application/json").build();
        Class[] interfaces = new Class[]{aClass, RestClientProxy.class, Closeable.class};
        BeanManager beanManager = LibertyRestClientBuilderImpl.getBeanManager();
        Map<Method, List<InterceptorInvoker>> interceptorInvokers = LibertyRestClientBuilderImpl.initInterceptorInvokers(beanManager, aClass);
        Object proxy = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new LibertyProxyInvocationHandler(aClass, actualClient, this.getLocalProviderInstances(), client, beanManager, interceptorInvokers));
        ClientHeaderProviders.registerForClass(aClass, proxy, beanManager);
        return (T)proxy;
    }

    public <T> T build(Class<T> aClass) throws IllegalStateException, RestClientDefinitionException {
        return this.build(aClass, null);
    }

    private List<String> getProxyHostsAsRegex() {
        String noProxyHostsSysProps = this.getSystemProperty("http.nonProxyHosts", null);
        if (noProxyHostsSysProps == null) {
            noProxyHostsSysProps = "localhost|127.*|[::1]";
        } else {
            String src2 = noProxyHostsSysProps.replace(".", "\\.");
            noProxyHostsSysProps = src2.replace("*", "[A-Za-z0-9-]*");
        }
        return Arrays.asList(noProxyHostsSysProps.split("\\|"));
    }

    private boolean useURLConnection() {
        if (this.useURLConnection == null) {
            String defaultToURLConnection = this.getSystemProperty("org.jboss.resteasy.microprofile.defaultToURLConnectionHttpClient", "false");
            this.useURLConnection = defaultToURLConnection.equalsIgnoreCase("true");
        }
        return this.useURLConnection;
    }

    private Optional<InetSocketAddress> selectHttpProxy() {
        ProxySelector proxySelector = System.getSecurityManager() == null ? ProxySelector.getDefault() : AccessController.doPrivileged(() -> ProxySelector.getDefault());
        return proxySelector.select(this.baseURI).stream().filter(proxy -> proxy.type() == Proxy.Type.HTTP).map(java.net.Proxy::address).map(InetSocketAddress.class::cast).findFirst();
    }

    private void checkQueryParamStyleProperty(Class<?> aClass) {
        if (this.queryParamStyle == null && this.config != null) {
            Optional prop = this.config.getOptionalValue(aClass.getName() + "/mp-rest/queryParamStyle", String.class);
            if (prop.isPresent()) {
                this.queryParamStyle(QueryParamStyle.valueOf((String)((String)prop.get()).trim().toUpperCase()));
            } else {
                RegisterRestClient registerRestClient = aClass.getAnnotation(RegisterRestClient.class);
                if (registerRestClient != null && registerRestClient.configKey() != null && !registerRestClient.configKey().isEmpty() && (prop = this.config.getOptionalValue(registerRestClient.configKey() + "/mp-rest/queryParamStyle", String.class)).isPresent()) {
                    this.queryParamStyle(QueryParamStyle.valueOf((String)((String)prop.get()).trim().toUpperCase()));
                }
            }
        }
        if (this.queryParamStyle == null) {
            this.queryParamStyle = QueryParamStyle.MULTI_PAIRS;
        }
    }

    private void checkFollowRedirectProperty(Class<?> aClass) {
        if (!this.followRedirect && this.config != null) {
            Optional prop = this.config.getOptionalValue(aClass.getName() + "/mp-rest/followRedirects", Boolean.class);
            if (prop.isPresent()) {
                if ((Boolean)prop.get() != this.followRedirect) {
                    this.followRedirects((Boolean)prop.get());
                }
            } else {
                RegisterRestClient registerRestClient = aClass.getAnnotation(RegisterRestClient.class);
                if (registerRestClient != null && registerRestClient.configKey() != null && !registerRestClient.configKey().isEmpty() && (prop = this.config.getOptionalValue(registerRestClient.configKey() + "/mp-rest/followRedirects", Boolean.class)).isPresent() && (Boolean)prop.get() != this.followRedirect) {
                    this.followRedirects((Boolean)prop.get());
                }
            }
        }
    }

    private boolean isMapperDisabled() {
        Optional defaultMapperProp;
        boolean disabled = false;
        Optional optional = defaultMapperProp = this.config == null ? Optional.empty() : this.config.getOptionalValue(DEFAULT_MAPPER_PROP, Boolean.class);
        if (defaultMapperProp.isPresent() && ((Boolean)defaultMapperProp.get()).equals(Boolean.TRUE)) {
            disabled = true;
        } else if (!defaultMapperProp.isPresent()) {
            try {
                Object property = this.builderDelegate.getConfiguration().getProperty(DEFAULT_MAPPER_PROP);
                if (property != null) {
                    disabled = (Boolean)property;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (disabled) {
            LOGGER.warnf("The default ResponseExceptionMapper has been disabled", new Object[0]);
        }
        return disabled;
    }

    private String getReflectName(AnnotatedElement element) {
        if (element instanceof Parameter) {
            return ((Parameter)element).getName();
        }
        if (element instanceof Field) {
            return ((Field)element).getName();
        }
        if (element instanceof Method) {
            Method m = (Method)element;
            if (!m.getName().startsWith("get")) {
                return null;
            }
            return Character.toLowerCase(m.getName().charAt(3)) + m.getName().substring(4);
        }
        return null;
    }

    private String getPathParamName(AnnotatedElement element) {
        if (element.isAnnotationPresent(PathParam.class)) {
            PathParam pp = element.getAnnotation(PathParam.class);
            return pp.value();
        }
        if (element.isAnnotationPresent(org.jboss.resteasy.annotations.jaxrs.PathParam.class)) {
            org.jboss.resteasy.annotations.jaxrs.PathParam pp = element.getAnnotation(org.jboss.resteasy.annotations.jaxrs.PathParam.class);
            if (pp.value().length() > 0) {
                return pp.value();
            }
            return this.getReflectName(element);
        }
        return null;
    }

    private void verifyBeanPathParam(Class<?> beanType, Map<String, Object> paramMap) {
        String name;
        for (Field field : beanType.getDeclaredFields()) {
            name = this.getPathParamName(field);
            if (name == null) continue;
            paramMap.put(name, "foobar");
        }
        for (AccessibleObject accessibleObject : beanType.getDeclaredMethods()) {
            name = this.getPathParamName(accessibleObject);
            if (name == null) continue;
            paramMap.put(name, "foobar");
        }
    }

    private <T> void verifyInterface(Class<T> typeDef) {
        Method[] methods;
        for (Method method : methods = typeDef.getMethods()) {
            boolean hasHttpMethod = false;
            for (Annotation annotation : method.getAnnotations()) {
                boolean isHttpMethod;
                boolean bl = isHttpMethod = annotation.annotationType().getAnnotation(HttpMethod.class) != null;
                if (!hasHttpMethod && isHttpMethod) {
                    hasHttpMethod = true;
                    continue;
                }
                if (!hasHttpMethod || !isHttpMethod) continue;
                throw new RestClientDefinitionException("Ambiguous @HttpMethod defintion on type " + typeDef);
            }
        }
        Path classPathAnno = typeDef.getAnnotation(Path.class);
        ResteasyUriBuilder template = null;
        for (Method method : methods) {
            Path methodPathAnno = method.getAnnotation(Path.class);
            template = methodPathAnno != null ? (classPathAnno == null ? (ResteasyUriBuilder)new ResteasyUriBuilderImpl().uri(methodPathAnno.value()) : (ResteasyUriBuilder)new ResteasyUriBuilderImpl().uri(classPathAnno.value() + "/" + methodPathAnno.value())) : (classPathAnno != null ? (ResteasyUriBuilder)new ResteasyUriBuilderImpl().uri(classPathAnno.value()) : null);
            if (template == null) continue;
            template.host("localhost");
            HashSet allVariables = new HashSet(template.getPathParamNamesInDeclarationOrder());
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            for (Parameter p : method.getParameters()) {
                PathParam pathParam = p.getAnnotation(PathParam.class);
                if (pathParam != null) {
                    paramMap.put(pathParam.value(), "foobar");
                    continue;
                }
                if (p.isAnnotationPresent(org.jboss.resteasy.annotations.jaxrs.PathParam.class)) {
                    org.jboss.resteasy.annotations.jaxrs.PathParam rePathParam = p.getAnnotation(org.jboss.resteasy.annotations.jaxrs.PathParam.class);
                    String name = rePathParam.value() == null || rePathParam.value().length() == 0 ? p.getName() : rePathParam.value();
                    paramMap.put(name, "foobar");
                    continue;
                }
                if (!p.isAnnotationPresent(BeanParam.class)) continue;
                this.verifyBeanPathParam(p.getType(), paramMap);
            }
            if (allVariables.size() != paramMap.size()) {
                throw new RestClientDefinitionException("Parameters and variables don't match on " + typeDef + "::" + method.getName());
            }
            try {
                template.resolveTemplates(paramMap, false).build(new Object[0]);
            }
            catch (IllegalArgumentException ex) {
                throw new RestClientDefinitionException("Parameter names don't match variable names on " + typeDef + "::" + method.getName(), (Throwable)ex);
            }
        }
    }

    public Configuration getConfiguration() {
        return this.getConfigurationWrapper();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RestClientBuilder property(String name, Object value) {
        if (name.startsWith(RESTEASY_PROPERTY_PREFIX)) {
            Object[] arguments;
            String builderMethodName = name.substring(RESTEASY_PROPERTY_PREFIX.length());
            Method builderMethod = Arrays.stream(ResteasyClientBuilder.class.getMethods()).filter(m -> builderMethodName.equals(m.getName()) && m.getParameterCount() >= 1).findFirst().orElse(null);
            if (builderMethod == null) {
                throw new IllegalArgumentException("ResteasyClientBuilder setter method not found: " + builderMethodName);
            }
            if (builderMethod.getParameterCount() > 1) {
                if (!(value instanceof List)) throw new IllegalArgumentException("Value must be an instance of List<> for ResteasyClientBuilder setter method: " + builderMethodName);
                arguments = ((List)value).toArray();
            } else {
                arguments = new Object[]{value};
            }
            try {
                builderMethod.invoke((Object)this.builderDelegate, arguments);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException("Unable to invoke ResteasyClientBuilder method: " + builderMethodName, e);
            }
        }
        this.builderDelegate.property(name, value);
        return this;
    }

    private Object newInstanceOf(Class<?> clazz) {
        if (PROVIDER_FACTORY != null) {
            return PROVIDER_FACTORY.injectedInstance(clazz);
        }
        return this.getBuilderDelegate().getProviderFactory().injectedInstance(clazz);
    }

    public RestClientBuilder register(Class<?> aClass) {
        this.register(this.newInstanceOf(aClass));
        return this;
    }

    public RestClientBuilder register(Class<?> aClass, int i) {
        this.register(this.newInstanceOf(aClass), i);
        return this;
    }

    public RestClientBuilder register(Class<?> aClass, Class<?>[] classes) {
        this.register(this.newInstanceOf(aClass), classes);
        return this;
    }

    public RestClientBuilder register(Class<?> aClass, Map<Class<?>, Integer> map) {
        this.register(this.newInstanceOf(aClass), map);
        return this;
    }

    public RestClientBuilder register(Object o) {
        if (o instanceof ResponseExceptionMapper) {
            ResponseExceptionMapper mapper = (ResponseExceptionMapper)o;
            this.register((Object)mapper, mapper.getPriority());
        } else if (o instanceof ParamConverterProvider) {
            this.register(o, 5000);
        } else if (o instanceof AsyncInvocationInterceptorFactory) {
            this.invocationInterceptorFactories.add((AsyncInvocationInterceptorFactory)o);
        } else {
            this.builderDelegate.register(o);
        }
        return this;
    }

    public RestClientBuilder register(Object o, int i) {
        if (o instanceof ResponseExceptionMapper) {
            ResponseExceptionMapper mapper = (ResponseExceptionMapper)o;
            HashMap contracts = new HashMap();
            contracts.put(ResponseExceptionMapper.class, i);
            this.registerLocalProviderInstance(mapper, contracts);
            this.builderDelegate.register(mapper, i);
        } else if (o instanceof ParamConverterProvider) {
            ParamConverterProvider converter = (ParamConverterProvider)o;
            HashMap contracts = new HashMap();
            contracts.put(ParamConverterProvider.class, i);
            this.registerLocalProviderInstance(converter, contracts);
            this.builderDelegate.register(converter, i);
        } else if (o instanceof AsyncInvocationInterceptorFactory) {
            this.invocationInterceptorFactories.add((AsyncInvocationInterceptorFactory)o);
        } else {
            this.builderDelegate.register(o, i);
        }
        return this;
    }

    public RestClientBuilder register(Object o, Class<?>[] classes) {
        for (Class<ResponseExceptionMapper> clazz : classes) {
            if (!clazz.isAssignableFrom(ResponseExceptionMapper.class)) continue;
            this.register(o);
        }
        this.builderDelegate.register(o, classes);
        return this;
    }

    public RestClientBuilder register(Object o, Map<Class<?>, Integer> map) {
        if (o instanceof ResponseExceptionMapper) {
            ResponseExceptionMapper mapper = (ResponseExceptionMapper)o;
            HashMap contracts = new HashMap();
            contracts.put(ResponseExceptionMapper.class, map.get(ResponseExceptionMapper.class));
            this.registerLocalProviderInstance(mapper, contracts);
            this.builderDelegate.register(o, map);
        } else {
            this.builderDelegate.register(o, map);
        }
        return this;
    }

    public Set<Object> getLocalProviderInstances() {
        return this.localProviderInstances;
    }

    public void registerLocalProviderInstance(Object provider, Map<Class<?>, Integer> contracts) {
        for (Object registered : this.getLocalProviderInstances()) {
            if (registered != provider) continue;
            return;
        }
        this.localProviderInstances.add(provider);
        this.configurationWrapper.registerLocalContract(provider.getClass(), contracts);
    }

    ResteasyClientBuilder getBuilderDelegate() {
        return this.builderDelegate;
    }

    private static BeanManager getBeanManager() {
        try {
            CDI current = CDI.current();
            return current != null ? current.getBeanManager() : null;
        }
        catch (Throwable t) {
            LOGGER.warnf("CDI container is not available", (Object)t);
            return null;
        }
    }

    private String getSystemProperty(String key, String def) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key, def);
        }
        return AccessController.doPrivileged(() -> System.getProperty(key, def));
    }

    private static Method[] resolveMethods(Class<?> type) {
        if (AutoCloseable.class.isAssignableFrom(type)) {
            return (Method[])Stream.of(type.getMethods()).filter(method -> !IGNORED_METHODS.contains(method)).toArray(Method[]::new);
        }
        return type.getMethods();
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(clazz::getClassLoader);
    }

    private static Map<Method, List<InterceptorInvoker>> initInterceptorInvokers(BeanManager beanManager, Class<?> restClient) {
        HashMap<Method, List<InterceptorInvoker>> invokers = new HashMap<Method, List<InterceptorInvoker>>();
        if (beanManager != null) {
            CreationalContext creationalContext = beanManager != null ? beanManager.createCreationalContext(null) : null;
            HashMap<Interceptor, Object> interceptorInstances = new HashMap<Interceptor, Object>();
            AnnotatedType restClientType = beanManager.createAnnotatedType(restClient);
            List<Annotation> classBindings = LibertyRestClientBuilderImpl.getBindings(restClientType.getAnnotations(), beanManager);
            for (AnnotatedMethod method : restClientType.getMethods()) {
                Annotation[] mpFTInterceptorBindings;
                ArrayList mpFTInterceptors;
                Method javaMethod = method.getJavaMember();
                if (javaMethod.isDefault() || method.isStatic()) continue;
                List<Annotation> methodBindings = LibertyRestClientBuilderImpl.getBindings(method.getAnnotations(), beanManager);
                if (classBindings.isEmpty() && methodBindings.isEmpty()) continue;
                if (FT_ANNO_CLASS != null) {
                    if (LibertyRestClientBuilderImpl.containsFTannotation(methodBindings)) {
                        methodBindings.add(LibertyRestClientBuilderImpl.getFTAnnotation());
                    }
                    if (LibertyRestClientBuilderImpl.containsFTannotation(classBindings)) {
                        classBindings.add(LibertyRestClientBuilderImpl.getFTAnnotation());
                    }
                }
                ArrayList arrayList = mpFTInterceptors = (mpFTInterceptorBindings = LibertyRestClientBuilderImpl.mergeToFTAnnos(methodBindings, classBindings)).length == 0 ? Collections.emptyList() : new ArrayList(beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, mpFTInterceptorBindings));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Resolved interceptors from beanManager, " + beanManager + ":" + mpFTInterceptors));
                }
                if (mpFTInterceptors.isEmpty()) continue;
                ArrayList<InterceptorInvoker> chain = new ArrayList<InterceptorInvoker>();
                for (Interceptor interceptor : mpFTInterceptors) {
                    chain.add(new InterceptorInvoker(interceptor, interceptorInstances.computeIfAbsent(interceptor, i -> beanManager.getReference((Bean)i, (Type)i.getBeanClass(), creationalContext))));
                }
                invokers.put(javaMethod, chain);
            }
        }
        return invokers;
    }

    private static boolean containsFTannotation(List<Annotation> interceptorBindings) {
        for (Annotation anno : interceptorBindings) {
            if (!LibertyRestClientBuilderImpl.isMPFTAnnotation(anno)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMPFTAnnotation(Annotation anno) {
        String className = anno.annotationType().getName();
        return className.startsWith("org.eclipse.microprofile.faulttolerance") || className.equals("com.ibm.ws.microprofile.faulttolerance.cdi.FaultTolerance");
    }

    private static Annotation getFTAnnotation() {
        return new Annotation(){
            static final long serialVersionUID = 2394522821555128490L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Class<? extends Annotation> annotationType() {
                return FT_ANNO_CLASS;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.microprofile.client.ot.LibertyRestClientBuilderImpl$1", 1.class, null, null);
            }
        };
    }

    private static List<Annotation> getBindings(Set<Annotation> annotations, BeanManager beanManager) {
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            if (!beanManager.isInterceptorBinding(annotation.annotationType())) continue;
            bindings.add(annotation);
        }
        return bindings;
    }

    private static Annotation[] mergeToFTAnnos(List<Annotation> methodBindings, List<Annotation> classBindings) {
        Set types = methodBindings.stream().map(a -> a.annotationType()).collect(Collectors.toSet());
        ArrayList<Annotation> merged = new ArrayList<Annotation>(methodBindings);
        for (Annotation annotation : classBindings) {
            if (types.contains(annotation.annotationType())) continue;
            merged.add(annotation);
        }
        return merged.stream().filter(LibertyRestClientBuilderImpl::isMPFTAnnotation).collect(Collectors.toList()).toArray(new Annotation[0]);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.microprofile.client.ot.LibertyRestClientBuilderImpl", LibertyRestClientBuilderImpl.class, null, null);
        LOGGER = Logger.getLogger(RestClientBuilderImpl.class);
        DEFAULT_MEDIA_TYPE_FILTER = new DefaultMediaTypeFilter();
        IGNORED_METHODS = new ArrayList<Method>();
        METHOD_INJECTION_FILTER = new MethodInjectionFilter();
        HEADERS_REQUEST_FILTER = new ClientHeadersRequestFilter();
        FT_ANNO_CLASS = LibertyRestClientBuilderImpl.getFTAnnotationClass();
        Collections.addAll(IGNORED_METHODS, Closeable.class.getMethods());
        Collections.addAll(IGNORED_METHODS, AutoCloseable.class.getMethods());
    }
}

