/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PartialResponse
extends Response
implements Serializable {
    private InputStream entityStream;
    private final transient ClientResponseContext responseContext;

    PartialResponse(ClientResponseContext responseContext) {
        this.responseContext = responseContext;
        this.entityStream = responseContext.getEntityStream();
    }

    public int getStatus() {
        return this.responseContext.getStatus();
    }

    public Response.StatusType getStatusInfo() {
        return this.responseContext.getStatusInfo();
    }

    public Object getEntity() {
        throw this.notSupported();
    }

    private RuntimeException notSupported() {
        RuntimeException ex = new RuntimeException("method call not supported");
        return ex;
    }

    public synchronized <T> T readEntity(Class<T> entityType) {
        if (entityType.isAssignableFrom(String.class)) {
            return (T)PartialResponse.readStringEntity(this.entityStream);
        }
        throw this.notSupported();
    }

    public static String readStringEntity(InputStream input) {
        String string;
        BufferedReader buffer = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        try {
            string = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new WebApplicationException("Failed to read entity", (Throwable)e);
            }
        }
        buffer.close();
        return string;
    }

    public <T> T readEntity(GenericType<T> entityType) {
        throw this.notSupported();
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        throw this.notSupported();
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        throw this.notSupported();
    }

    public boolean hasEntity() {
        return this.responseContext.hasEntity();
    }

    public synchronized boolean bufferEntity() {
        try {
            byte[] buffer = new byte[4096];
            int read = 0;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            while ((read = this.entityStream.read(buffer)) >= 0) {
                outStream.write(buffer, 0, read);
            }
            this.entityStream = new ByteArrayInputStream(outStream.toByteArray());
            return true;
        }
        catch (Exception any) {
            return false;
        }
    }

    public synchronized void close() {
        try {
            this.responseContext.getEntityStream().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public MediaType getMediaType() {
        return this.responseContext.getMediaType();
    }

    public Locale getLanguage() {
        return this.responseContext.getLanguage();
    }

    public int getLength() {
        return this.responseContext.getLength();
    }

    public Set<String> getAllowedMethods() {
        return this.responseContext.getAllowedMethods();
    }

    public Map<String, NewCookie> getCookies() {
        return this.responseContext.getCookies();
    }

    public EntityTag getEntityTag() {
        return this.responseContext.getEntityTag();
    }

    public Date getDate() {
        return this.responseContext.getDate();
    }

    public Date getLastModified() {
        return this.responseContext.getLastModified();
    }

    public URI getLocation() {
        return this.responseContext.getLocation();
    }

    public Set<Link> getLinks() {
        return this.responseContext.getLinks();
    }

    public boolean hasLink(String relation) {
        return this.responseContext.hasLink(relation);
    }

    public Link getLink(String relation) {
        return this.responseContext.getLink(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        throw new RuntimeException("method call not supported");
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.responseContext.getHeaders();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.responseContext.getHeaders();
    }

    public String getHeaderString(String name) {
        return this.responseContext.getHeaderString(name);
    }
}

