/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.internal.archive;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.internal.interfaces.Application;
import com.ibm.ws.cdi.internal.interfaces.ArchiveType;
import com.ibm.ws.cdi.internal.interfaces.BuildCompatibleExtensionFinder;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.CDIRuntime;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.internal.interfaces.Resource;
import com.ibm.ws.cdi.internal.interfaces.ResourceInjectionBag;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceRefConfigList;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefBindingHelper;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractCDIArchive
implements CDIArchive {
    private static final TraceComponent tc = Tr.register(AbstractCDIArchive.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private final CDIRuntime cdiRuntime;
    private final String name;
    private Set<String> annotationNames;
    private ReferenceContext referenceContext;
    static final long serialVersionUID = -301712185318755928L;

    public AbstractCDIArchive(String name, CDIRuntime cdiRuntime) {
        this.cdiRuntime = cdiRuntime;
        this.name = name;
    }

    @FFDCIgnore(value={ClassNotFoundException.class, LinkageError.class})
    public Map<String, Class<?>> loadBdaClasses(Set<String> internalClassNames, Set<String> additionalClassNames) throws CDIException {
        Class<?> clazz;
        HashMap classes = new HashMap();
        ClassLoader classLoader = this.getClassLoader();
        for (String className : additionalClassNames) {
            try {
                clazz = classLoader.loadClass(className);
                classes.put(className, clazz);
            }
            catch (ClassNotFoundException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Skipping additional class which can't be loaded", (Object[])new Object[]{className, classLoader});
            }
            catch (LinkageError e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Skipping additional class which can't be loaded", (Object[])new Object[]{className, classLoader});
            }
        }
        for (String className : internalClassNames) {
            try {
                clazz = classLoader.loadClass(className);
                if (clazz.getClassLoader() == classLoader) {
                    classes.put(className, clazz);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Skipping class which is external to the BDA", (Object[])new Object[]{clazz, clazz.getClassLoader(), classLoader});
            }
            catch (ClassNotFoundException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Skipping class which can't be loaded", (Object[])new Object[]{className, classLoader});
            }
            catch (LinkageError e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Skipping class which can't be loaded", (Object[])new Object[]{className, classLoader});
            }
        }
        return classes;
    }

    @Override
    public Set<String> getExtensionClasses() {
        HashSet<String> serviceClazzes = new HashSet<String>();
        if (this.getType() == ArchiveType.WEB_MODULE) {
            Resource webInfClassesMetaInfServicesEntry = this.getResource(CDIUtils.WEB_INF_CLASSES_META_INF_SERVICES_CDI_EXTENSION);
            serviceClazzes.addAll(CDIUtils.parseServiceSPIExtensionFile(webInfClassesMetaInfServicesEntry));
        }
        Resource metaInfServicesEntry = this.getResource(CDIUtils.META_INF_SERVICES_CDI_EXTENSION);
        serviceClazzes.addAll(CDIUtils.parseServiceSPIExtensionFile(metaInfServicesEntry));
        return serviceClazzes;
    }

    @Override
    public Set<String> getBuildCompatibleExtensionClasses() {
        BuildCompatibleExtensionFinder finder = this.cdiRuntime.getBuildCompatibleExtensionFinder();
        if (finder == null) {
            return Collections.emptySet();
        }
        return finder.findBceClassNames(this);
    }

    @Override
    public Resource getBeansXml() {
        Resource beansXmlEntry = null;
        if (this.getType() == ArchiveType.WEB_MODULE) {
            Resource webInfClassesMetaInfBeansXmlEntry = this.getResource("WEB-INF/classes/META-INF/beans.xml");
            Resource webInfBeansXmlEntry = this.getResource("WEB-INF/beans.xml");
            if (webInfBeansXmlEntry != null) {
                beansXmlEntry = webInfBeansXmlEntry;
                if (webInfClassesMetaInfBeansXmlEntry != null && tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"multiple.beans.xml.warning.CWOWB1001W", (Object[])new Object[]{this.getApplication().getName() + "#" + this.getName(), "WEB-INF/beans.xml", "WEB-INF/classes/META-INF/beans.xml"});
                }
            } else {
                beansXmlEntry = webInfClassesMetaInfBeansXmlEntry;
            }
        } else {
            beansXmlEntry = this.getResource("META-INF/beans.xml");
        }
        return beansXmlEntry;
    }

    public BeanDiscoveryMode getBeanDiscoveryMode(CDIRuntime cdiRuntime, BeansXml beansXml) {
        BeanDiscoveryMode mode = BeanDiscoveryMode.ANNOTATED;
        if (beansXml != null) {
            mode = beansXml.getBeanDiscoveryMode();
        } else if (cdiRuntime.isImplicitBeanArchivesScanningDisabled(this)) {
            mode = BeanDiscoveryMode.NONE;
        }
        return mode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ReferenceContext getReferenceContext(Set<Class<?>> injectionClasses) throws CDIException {
        if (this.referenceContext == null) {
            ComponentNameSpaceConfiguration compNSConfig;
            ModuleMetaData moduleMetaData;
            ApplicationMetaData applicationMetaData;
            block8: {
                InjectionEngine injectionEngine = this.cdiRuntime.getInjectionEngine();
                Application cdiApplication = this.getApplication();
                applicationMetaData = cdiApplication.getApplicationMetaData();
                MetaData metaData = this.getMetaData();
                moduleMetaData = null;
                if (metaData != null && metaData instanceof ModuleMetaData) {
                    moduleMetaData = (ModuleMetaData)metaData;
                }
                this.referenceContext = moduleMetaData != null && this.getType() != ArchiveType.CLIENT_MODULE ? injectionEngine.getCommonReferenceContext(moduleMetaData) : injectionEngine.createReferenceContext((MetaData)applicationMetaData);
                J2EEName j2eeName = this.getJ2EEName();
                if (j2eeName == null) {
                    j2eeName = cdiApplication.getJ2EEName();
                }
                String displayName = null;
                compNSConfig = new ComponentNameSpaceConfiguration(displayName, j2eeName);
                ResourceInjectionBag bag = this.getAllBindings();
                if (bag != null) {
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Looking for env entries", (Object[])new Object[0]);
                        }
                        JNDIEnvironmentRefBindingHelper.setAllBndAndExt((ComponentNameSpaceConfiguration)compNSConfig, bag.allBindings, bag.envEntryValues, (ResourceRefConfigList)bag.resourceRefConfigList);
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cdi.internal.archive.AbstractCDIArchive", (String)"247", (Object)this, (Object[])new Object[]{injectionClasses});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                        Tr.debug((TraceComponent)tc, (String)("Caught Exception looking for Env Entries: " + e), (Object[])new Object[0]);
                    }
                }
            }
            compNSConfig.setClassLoader(this.getClassLoader());
            if (moduleMetaData != null) {
                compNSConfig.setModuleMetaData(moduleMetaData);
            }
            compNSConfig.setApplicationMetaData(applicationMetaData);
            compNSConfig.setMetaDataComplete(false);
            compNSConfig.setOwningFlow(ComponentNameSpaceConfiguration.ReferenceFlowKind.MANAGED_BEAN);
            compNSConfig.setInjectionClasses(new ArrayList(injectionClasses));
            this.referenceContext.add(compNSConfig);
        }
        return this.referenceContext;
    }

    @Override
    public ReferenceContext getReferenceContext() throws CDIException {
        return this.referenceContext;
    }

    @Override
    public CDIRuntime getCDIRuntime() {
        return this.cdiRuntime;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "CDIArchive: " + this.name;
    }

    @Override
    public Set<String> getBeanDefiningAnnotations() throws CDIException {
        if (this.annotationNames == null) {
            this.annotationNames = this.getAnnotatedClasses(CDIUtils.BEAN_DEFINING_META_ANNOTATION_NAMES);
        }
        return this.annotationNames;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCDIArchive other = (AbstractCDIArchive)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

